/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.bson.BSONCallback;
import org.bson.BSONCallbackAdapter;
import org.bson.BSONDecoder;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.BsonBinaryReader;
import org.bson.BsonWriterSettings;
import org.bson.ByteBufNIO;
import org.bson.io.Bits;
import org.bson.io.ByteBufferBsonInput;

public class BasicBSONDecoder
implements BSONDecoder {
    @Override
    public BSONObject readObject(byte[] bytes2) {
        BasicBSONCallback bsonCallback = new BasicBSONCallback();
        this.decode(bytes2, (BSONCallback)bsonCallback);
        return (BSONObject)bsonCallback.get();
    }

    @Override
    public BSONObject readObject(InputStream in2) throws IOException {
        return this.readObject(this.readFully(in2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int decode(byte[] bytes2, BSONCallback callback) {
        BsonBinaryReader reader = new BsonBinaryReader(new ByteBufferBsonInput(new ByteBufNIO(ByteBuffer.wrap(bytes2))));
        try {
            BSONCallbackAdapter writer2 = new BSONCallbackAdapter(new BsonWriterSettings(), callback);
            writer2.pipe(reader);
            int n = reader.getBsonInput().getPosition();
            return n;
        }
        finally {
            reader.close();
        }
    }

    @Override
    public int decode(InputStream in2, BSONCallback callback) throws IOException {
        return this.decode(this.readFully(in2), callback);
    }

    private byte[] readFully(InputStream input2) throws IOException {
        byte[] sizeBytes = new byte[4];
        Bits.readFully(input2, sizeBytes);
        int size2 = Bits.readInt(sizeBytes);
        byte[] buffer = new byte[size2];
        System.arraycopy(sizeBytes, 0, buffer, 0, 4);
        Bits.readFully(input2, buffer, 4, size2 - 4);
        return buffer;
    }
}

