/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonContextType;
import org.bson.BsonDbPointer;
import org.bson.BsonDocument;
import org.bson.BsonElement;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonReader;
import org.bson.BsonRegularExpression;
import org.bson.BsonSerializationException;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.BsonWriterSettings;
import org.bson.FieldNameValidator;
import org.bson.NoOpFieldNameValidator;
import org.bson.StringUtils;
import org.bson.assertions.Assertions;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public abstract class AbstractBsonWriter
implements BsonWriter,
Closeable {
    private final BsonWriterSettings settings;
    private final Stack<FieldNameValidator> fieldNameValidatorStack = new Stack();
    private State state;
    private Context context;
    private int serializationDepth;
    private boolean closed;

    protected AbstractBsonWriter(BsonWriterSettings settings2) {
        this(settings2, new NoOpFieldNameValidator());
    }

    protected AbstractBsonWriter(BsonWriterSettings settings2, FieldNameValidator validator) {
        if (validator == null) {
            throw new IllegalArgumentException("Validator can not be null");
        }
        this.settings = settings2;
        this.fieldNameValidatorStack.push(validator);
        this.state = State.INITIAL;
    }

    protected String getName() {
        return this.context.name;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected void setState(State state2) {
        this.state = state2;
    }

    protected State getState() {
        return this.state;
    }

    protected Context getContext() {
        return this.context;
    }

    protected void setContext(Context context) {
        this.context = context;
    }

    protected abstract void doWriteStartDocument();

    protected abstract void doWriteEndDocument();

    protected abstract void doWriteStartArray();

    protected abstract void doWriteEndArray();

    protected abstract void doWriteBinaryData(BsonBinary var1);

    protected abstract void doWriteBoolean(boolean var1);

    protected abstract void doWriteDateTime(long var1);

    protected abstract void doWriteDBPointer(BsonDbPointer var1);

    protected abstract void doWriteDouble(double var1);

    protected abstract void doWriteInt32(int var1);

    protected abstract void doWriteInt64(long var1);

    protected abstract void doWriteDecimal128(Decimal128 var1);

    protected abstract void doWriteJavaScript(String var1);

    protected abstract void doWriteJavaScriptWithScope(String var1);

    protected abstract void doWriteMaxKey();

    protected abstract void doWriteMinKey();

    protected abstract void doWriteNull();

    protected abstract void doWriteObjectId(ObjectId var1);

    protected abstract void doWriteRegularExpression(BsonRegularExpression var1);

    protected abstract void doWriteString(String var1);

    protected abstract void doWriteSymbol(String var1);

    protected abstract void doWriteTimestamp(BsonTimestamp var1);

    protected abstract void doWriteUndefined();

    @Override
    public void writeStartDocument(String name) {
        this.writeName(name);
        this.writeStartDocument();
    }

    @Override
    public void writeStartDocument() {
        this.checkPreconditions("writeStartDocument", State.INITIAL, State.VALUE, State.SCOPE_DOCUMENT, State.DONE);
        if (this.context != null && this.context.name != null) {
            this.fieldNameValidatorStack.push(this.fieldNameValidatorStack.peek().getValidatorForField(this.getName()));
        }
        ++this.serializationDepth;
        if (this.serializationDepth > this.settings.getMaxSerializationDepth()) {
            throw new BsonSerializationException("Maximum serialization depth exceeded (does the object being serialized have a circular reference?).");
        }
        this.doWriteStartDocument();
        this.setState(State.NAME);
    }

    @Override
    public void writeEndDocument() {
        this.checkPreconditions("writeEndDocument", State.NAME);
        BsonContextType contextType = this.getContext().getContextType();
        if (contextType != BsonContextType.DOCUMENT && contextType != BsonContextType.SCOPE_DOCUMENT) {
            this.throwInvalidContextType("WriteEndDocument", contextType, BsonContextType.DOCUMENT, BsonContextType.SCOPE_DOCUMENT);
        }
        if (this.context.getParentContext() != null && this.context.getParentContext().name != null) {
            this.fieldNameValidatorStack.pop();
        }
        --this.serializationDepth;
        this.doWriteEndDocument();
        if (this.getContext() == null || this.getContext().getContextType() == BsonContextType.TOP_LEVEL) {
            this.setState(State.DONE);
        } else {
            this.setState(this.getNextState());
        }
    }

    @Override
    public void writeStartArray(String name) {
        this.writeName(name);
        this.writeStartArray();
    }

    @Override
    public void writeStartArray() {
        this.checkPreconditions("writeStartArray", State.VALUE);
        if (this.context != null && this.context.name != null) {
            this.fieldNameValidatorStack.push(this.fieldNameValidatorStack.peek().getValidatorForField(this.getName()));
        }
        ++this.serializationDepth;
        if (this.serializationDepth > this.settings.getMaxSerializationDepth()) {
            throw new BsonSerializationException("Maximum serialization depth exceeded (does the object being serialized have a circular reference?).");
        }
        this.doWriteStartArray();
        this.setState(State.VALUE);
    }

    @Override
    public void writeEndArray() {
        this.checkPreconditions("writeEndArray", State.VALUE);
        if (this.getContext().getContextType() != BsonContextType.ARRAY) {
            this.throwInvalidContextType("WriteEndArray", this.getContext().getContextType(), BsonContextType.ARRAY);
        }
        if (this.context.getParentContext() != null && this.context.getParentContext().name != null) {
            this.fieldNameValidatorStack.pop();
        }
        --this.serializationDepth;
        this.doWriteEndArray();
        this.setState(this.getNextState());
    }

    @Override
    public void writeBinaryData(String name, BsonBinary binary) {
        Assertions.notNull("name", name);
        Assertions.notNull("value", binary);
        this.writeName(name);
        this.writeBinaryData(binary);
    }

    @Override
    public void writeBinaryData(BsonBinary binary) {
        Assertions.notNull("value", binary);
        this.checkPreconditions("writeBinaryData", State.VALUE, State.INITIAL);
        this.doWriteBinaryData(binary);
        this.setState(this.getNextState());
    }

    @Override
    public void writeBoolean(String name, boolean value2) {
        this.writeName(name);
        this.writeBoolean(value2);
    }

    @Override
    public void writeBoolean(boolean value2) {
        this.checkPreconditions("writeBoolean", State.VALUE, State.INITIAL);
        this.doWriteBoolean(value2);
        this.setState(this.getNextState());
    }

    @Override
    public void writeDateTime(String name, long value2) {
        this.writeName(name);
        this.writeDateTime(value2);
    }

    @Override
    public void writeDateTime(long value2) {
        this.checkPreconditions("writeDateTime", State.VALUE, State.INITIAL);
        this.doWriteDateTime(value2);
        this.setState(this.getNextState());
    }

    @Override
    public void writeDBPointer(String name, BsonDbPointer value2) {
        Assertions.notNull("name", name);
        Assertions.notNull("value", value2);
        this.writeName(name);
        this.writeDBPointer(value2);
    }

    @Override
    public void writeDBPointer(BsonDbPointer value2) {
        Assertions.notNull("value", value2);
        this.checkPreconditions("writeDBPointer", State.VALUE, State.INITIAL);
        this.doWriteDBPointer(value2);
        this.setState(this.getNextState());
    }

    @Override
    public void writeDouble(String name, double value2) {
        this.writeName(name);
        this.writeDouble(value2);
    }

    @Override
    public void writeDouble(double value2) {
        this.checkPreconditions("writeDBPointer", State.VALUE, State.INITIAL);
        this.doWriteDouble(value2);
        this.setState(this.getNextState());
    }

    @Override
    public void writeInt32(String name, int value2) {
        this.writeName(name);
        this.writeInt32(value2);
    }

    @Override
    public void writeInt32(int value2) {
        this.checkPreconditions("writeInt32", State.VALUE);
        this.doWriteInt32(value2);
        this.setState(this.getNextState());
    }

    @Override
    public void writeInt64(String name, long value2) {
        this.writeName(name);
        this.writeInt64(value2);
    }

    @Override
    public void writeInt64(long value2) {
        this.checkPreconditions("writeInt64", State.VALUE);
        this.doWriteInt64(value2);
        this.setState(this.getNextState());
    }

    @Override
    public void writeDecimal128(Decimal128 value2) {
        Assertions.notNull("value", value2);
        this.checkPreconditions("writeInt64", State.VALUE);
        this.doWriteDecimal128(value2);
        this.setState(this.getNextState());
    }

    @Override
    public void writeDecimal128(String name, Decimal128 value2) {
        Assertions.notNull("name", name);
        Assertions.notNull("value", value2);
        this.writeName(name);
        this.writeDecimal128(value2);
    }

    @Override
    public void writeJavaScript(String name, String code2) {
        Assertions.notNull("name", name);
        Assertions.notNull("value", code2);
        this.writeName(name);
        this.writeJavaScript(code2);
    }

    @Override
    public void writeJavaScript(String code2) {
        Assertions.notNull("value", code2);
        this.checkPreconditions("writeJavaScript", State.VALUE);
        this.doWriteJavaScript(code2);
        this.setState(this.getNextState());
    }

    @Override
    public void writeJavaScriptWithScope(String name, String code2) {
        Assertions.notNull("name", name);
        Assertions.notNull("value", code2);
        this.writeName(name);
        this.writeJavaScriptWithScope(code2);
    }

    @Override
    public void writeJavaScriptWithScope(String code2) {
        Assertions.notNull("value", code2);
        this.checkPreconditions("writeJavaScriptWithScope", State.VALUE);
        this.doWriteJavaScriptWithScope(code2);
        this.setState(State.SCOPE_DOCUMENT);
    }

    @Override
    public void writeMaxKey(String name) {
        this.writeName(name);
        this.writeMaxKey();
    }

    @Override
    public void writeMaxKey() {
        this.checkPreconditions("writeMaxKey", State.VALUE);
        this.doWriteMaxKey();
        this.setState(this.getNextState());
    }

    @Override
    public void writeMinKey(String name) {
        this.writeName(name);
        this.writeMinKey();
    }

    @Override
    public void writeMinKey() {
        this.checkPreconditions("writeMinKey", State.VALUE);
        this.doWriteMinKey();
        this.setState(this.getNextState());
    }

    @Override
    public void writeName(String name) {
        Assertions.notNull("name", name);
        if (this.state != State.NAME) {
            this.throwInvalidState("WriteName", State.NAME);
        }
        if (!this.fieldNameValidatorStack.peek().validate(name)) {
            throw new IllegalArgumentException(String.format("Invalid BSON field name %s", name));
        }
        this.doWriteName(name);
        this.context.name = name;
        this.state = State.VALUE;
    }

    protected void doWriteName(String name) {
    }

    @Override
    public void writeNull(String name) {
        this.writeName(name);
        this.writeNull();
    }

    @Override
    public void writeNull() {
        this.checkPreconditions("writeNull", State.VALUE);
        this.doWriteNull();
        this.setState(this.getNextState());
    }

    @Override
    public void writeObjectId(String name, ObjectId objectId) {
        Assertions.notNull("name", name);
        Assertions.notNull("value", objectId);
        this.writeName(name);
        this.writeObjectId(objectId);
    }

    @Override
    public void writeObjectId(ObjectId objectId) {
        Assertions.notNull("value", objectId);
        this.checkPreconditions("writeObjectId", State.VALUE);
        this.doWriteObjectId(objectId);
        this.setState(this.getNextState());
    }

    @Override
    public void writeRegularExpression(String name, BsonRegularExpression regularExpression) {
        Assertions.notNull("name", name);
        Assertions.notNull("value", regularExpression);
        this.writeName(name);
        this.writeRegularExpression(regularExpression);
    }

    @Override
    public void writeRegularExpression(BsonRegularExpression regularExpression) {
        Assertions.notNull("value", regularExpression);
        this.checkPreconditions("writeRegularExpression", State.VALUE);
        this.doWriteRegularExpression(regularExpression);
        this.setState(this.getNextState());
    }

    @Override
    public void writeString(String name, String value2) {
        Assertions.notNull("name", name);
        Assertions.notNull("value", value2);
        this.writeName(name);
        this.writeString(value2);
    }

    @Override
    public void writeString(String value2) {
        Assertions.notNull("value", value2);
        this.checkPreconditions("writeString", State.VALUE);
        this.doWriteString(value2);
        this.setState(this.getNextState());
    }

    @Override
    public void writeSymbol(String name, String value2) {
        Assertions.notNull("name", name);
        Assertions.notNull("value", value2);
        this.writeName(name);
        this.writeSymbol(value2);
    }

    @Override
    public void writeSymbol(String value2) {
        Assertions.notNull("value", value2);
        this.checkPreconditions("writeSymbol", State.VALUE);
        this.doWriteSymbol(value2);
        this.setState(this.getNextState());
    }

    @Override
    public void writeTimestamp(String name, BsonTimestamp value2) {
        Assertions.notNull("name", name);
        Assertions.notNull("value", value2);
        this.writeName(name);
        this.writeTimestamp(value2);
    }

    @Override
    public void writeTimestamp(BsonTimestamp value2) {
        Assertions.notNull("value", value2);
        this.checkPreconditions("writeTimestamp", State.VALUE);
        this.doWriteTimestamp(value2);
        this.setState(this.getNextState());
    }

    @Override
    public void writeUndefined(String name) {
        this.writeName(name);
        this.writeUndefined();
    }

    @Override
    public void writeUndefined() {
        this.checkPreconditions("writeUndefined", State.VALUE);
        this.doWriteUndefined();
        this.setState(this.getNextState());
    }

    protected State getNextState() {
        if (this.getContext().getContextType() == BsonContextType.ARRAY) {
            return State.VALUE;
        }
        return State.NAME;
    }

    protected boolean checkState(State[] validStates) {
        for (State cur : validStates) {
            if (cur != this.getState()) continue;
            return true;
        }
        return false;
    }

    protected void checkPreconditions(String methodName, State ... validStates) {
        if (this.isClosed()) {
            throw new IllegalStateException("BsonWriter is closed");
        }
        if (!this.checkState(validStates)) {
            this.throwInvalidState(methodName, validStates);
        }
    }

    protected void throwInvalidContextType(String methodName, BsonContextType actualContextType, BsonContextType ... validContextTypes) {
        String validContextTypesString = StringUtils.join(" or ", Arrays.asList(validContextTypes));
        throw new BsonInvalidOperationException(String.format("%s can only be called when ContextType is %s, not when ContextType is %s.", new Object[]{methodName, validContextTypesString, actualContextType}));
    }

    protected void throwInvalidState(String methodName, State ... validStates) {
        if (!(this.state != State.INITIAL && this.state != State.SCOPE_DOCUMENT && this.state != State.DONE || methodName.startsWith("end") || methodName.equals("writeName"))) {
            String typeName = methodName.substring(5);
            if (typeName.startsWith("start")) {
                typeName = typeName.substring(5);
            }
            String article = "A";
            if (Arrays.asList(Character.valueOf('A'), Character.valueOf('E'), Character.valueOf('I'), Character.valueOf('O'), Character.valueOf('U')).contains(Character.valueOf(typeName.charAt(0)))) {
                article = "An";
            }
            throw new BsonInvalidOperationException(String.format("%s %s value cannot be written to the root level of a BSON document.", article, typeName));
        }
        String validStatesString = StringUtils.join(" or ", Arrays.asList(validStates));
        throw new BsonInvalidOperationException(String.format("%s can only be called when State is %s, not when State is %s", new Object[]{methodName, validStatesString, this.state}));
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void pipe(BsonReader reader) {
        Assertions.notNull("reader", reader);
        this.pipeDocument(reader, null);
    }

    public void pipe(BsonReader reader, List<BsonElement> extraElements) {
        Assertions.notNull("reader", reader);
        Assertions.notNull("extraElements", extraElements);
        this.pipeDocument(reader, extraElements);
    }

    protected void pipeExtraElements(List<BsonElement> extraElements) {
        Assertions.notNull("extraElements", extraElements);
        for (BsonElement cur : extraElements) {
            this.writeName(cur.getName());
            this.pipeValue(cur.getValue());
        }
    }

    protected boolean abortPipe() {
        return false;
    }

    private void pipeDocument(BsonReader reader, List<BsonElement> extraElements) {
        reader.readStartDocument();
        this.writeStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            this.writeName(reader.readName());
            this.pipeValue(reader);
            if (!this.abortPipe()) continue;
            return;
        }
        reader.readEndDocument();
        if (extraElements != null) {
            this.pipeExtraElements(extraElements);
        }
        this.writeEndDocument();
    }

    private void pipeJavascriptWithScope(BsonReader reader) {
        this.writeJavaScriptWithScope(reader.readJavaScriptWithScope());
        this.pipeDocument(reader, null);
    }

    private void pipeValue(BsonReader reader) {
        switch (reader.getCurrentBsonType()) {
            case DOCUMENT: {
                this.pipeDocument(reader, null);
                break;
            }
            case ARRAY: {
                this.pipeArray(reader);
                break;
            }
            case DOUBLE: {
                this.writeDouble(reader.readDouble());
                break;
            }
            case STRING: {
                this.writeString(reader.readString());
                break;
            }
            case BINARY: {
                this.writeBinaryData(reader.readBinaryData());
                break;
            }
            case UNDEFINED: {
                reader.readUndefined();
                this.writeUndefined();
                break;
            }
            case OBJECT_ID: {
                this.writeObjectId(reader.readObjectId());
                break;
            }
            case BOOLEAN: {
                this.writeBoolean(reader.readBoolean());
                break;
            }
            case DATE_TIME: {
                this.writeDateTime(reader.readDateTime());
                break;
            }
            case NULL: {
                reader.readNull();
                this.writeNull();
                break;
            }
            case REGULAR_EXPRESSION: {
                this.writeRegularExpression(reader.readRegularExpression());
                break;
            }
            case JAVASCRIPT: {
                this.writeJavaScript(reader.readJavaScript());
                break;
            }
            case SYMBOL: {
                this.writeSymbol(reader.readSymbol());
                break;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                this.pipeJavascriptWithScope(reader);
                break;
            }
            case INT32: {
                this.writeInt32(reader.readInt32());
                break;
            }
            case TIMESTAMP: {
                this.writeTimestamp(reader.readTimestamp());
                break;
            }
            case INT64: {
                this.writeInt64(reader.readInt64());
                break;
            }
            case DECIMAL128: {
                this.writeDecimal128(reader.readDecimal128());
                break;
            }
            case MIN_KEY: {
                reader.readMinKey();
                this.writeMinKey();
                break;
            }
            case DB_POINTER: {
                this.writeDBPointer(reader.readDBPointer());
                break;
            }
            case MAX_KEY: {
                reader.readMaxKey();
                this.writeMaxKey();
                break;
            }
            default: {
                throw new IllegalArgumentException("unhandled BSON type: " + (Object)((Object)reader.getCurrentBsonType()));
            }
        }
    }

    private void pipeDocument(BsonDocument value2) {
        this.writeStartDocument();
        for (Map.Entry<String, BsonValue> cur : value2.entrySet()) {
            this.writeName(cur.getKey());
            this.pipeValue(cur.getValue());
        }
        this.writeEndDocument();
    }

    private void pipeArray(BsonReader reader) {
        reader.readStartArray();
        this.writeStartArray();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            this.pipeValue(reader);
            if (!this.abortPipe()) continue;
            return;
        }
        reader.readEndArray();
        this.writeEndArray();
    }

    private void pipeArray(BsonArray array2) {
        this.writeStartArray();
        for (BsonValue cur : array2) {
            this.pipeValue(cur);
        }
        this.writeEndArray();
    }

    private void pipeJavascriptWithScope(BsonJavaScriptWithScope javaScriptWithScope) {
        this.writeJavaScriptWithScope(javaScriptWithScope.getCode());
        this.pipeDocument(javaScriptWithScope.getScope());
    }

    private void pipeValue(BsonValue value2) {
        switch (value2.getBsonType()) {
            case DOCUMENT: {
                this.pipeDocument(value2.asDocument());
                break;
            }
            case ARRAY: {
                this.pipeArray(value2.asArray());
                break;
            }
            case DOUBLE: {
                this.writeDouble(value2.asDouble().getValue());
                break;
            }
            case STRING: {
                this.writeString(value2.asString().getValue());
                break;
            }
            case BINARY: {
                this.writeBinaryData(value2.asBinary());
                break;
            }
            case UNDEFINED: {
                this.writeUndefined();
                break;
            }
            case OBJECT_ID: {
                this.writeObjectId(value2.asObjectId().getValue());
                break;
            }
            case BOOLEAN: {
                this.writeBoolean(value2.asBoolean().getValue());
                break;
            }
            case DATE_TIME: {
                this.writeDateTime(value2.asDateTime().getValue());
                break;
            }
            case NULL: {
                this.writeNull();
                break;
            }
            case REGULAR_EXPRESSION: {
                this.writeRegularExpression(value2.asRegularExpression());
                break;
            }
            case JAVASCRIPT: {
                this.writeJavaScript(value2.asJavaScript().getCode());
                break;
            }
            case SYMBOL: {
                this.writeSymbol(value2.asSymbol().getSymbol());
                break;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                this.pipeJavascriptWithScope(value2.asJavaScriptWithScope());
                break;
            }
            case INT32: {
                this.writeInt32(value2.asInt32().getValue());
                break;
            }
            case TIMESTAMP: {
                this.writeTimestamp(value2.asTimestamp());
                break;
            }
            case INT64: {
                this.writeInt64(value2.asInt64().getValue());
                break;
            }
            case DECIMAL128: {
                this.writeDecimal128(value2.asDecimal128().getValue());
                break;
            }
            case MIN_KEY: {
                this.writeMinKey();
                break;
            }
            case DB_POINTER: {
                this.writeDBPointer(value2.asDBPointer());
                break;
            }
            case MAX_KEY: {
                this.writeMaxKey();
                break;
            }
            default: {
                throw new IllegalArgumentException("unhandled BSON type: " + (Object)((Object)value2.getBsonType()));
            }
        }
    }

    protected class Mark {
        private final Context markedContext;
        private final State markedState;
        private final String currentName;
        private final int serializationDepth;

        protected Mark() {
            this.markedContext = AbstractBsonWriter.this.context.copy();
            this.markedState = AbstractBsonWriter.this.state;
            this.currentName = AbstractBsonWriter.this.context.name;
            this.serializationDepth = AbstractBsonWriter.this.serializationDepth;
        }

        protected void reset() {
            AbstractBsonWriter.this.setContext(this.markedContext);
            AbstractBsonWriter.this.setState(this.markedState);
            AbstractBsonWriter.this.context.name = this.currentName;
            AbstractBsonWriter.this.serializationDepth = this.serializationDepth;
        }
    }

    public class Context {
        private final Context parentContext;
        private final BsonContextType contextType;
        private String name;

        public Context(Context from2) {
            this.parentContext = from2.parentContext;
            this.contextType = from2.contextType;
        }

        public Context(Context parentContext, BsonContextType contextType) {
            this.parentContext = parentContext;
            this.contextType = contextType;
        }

        public Context getParentContext() {
            return this.parentContext;
        }

        public BsonContextType getContextType() {
            return this.contextType;
        }

        public Context copy() {
            return new Context(this);
        }
    }

    public static enum State {
        INITIAL,
        NAME,
        VALUE,
        SCOPE_DOCUMENT,
        DONE,
        CLOSED;

    }
}

