/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MemberUtils;

public class FieldUtils {
    public static Field getField(Class<?> cls, String fieldName2) {
        Field field2 = FieldUtils.getField(cls, fieldName2, false);
        MemberUtils.setAccessibleWorkaround(field2);
        return field2;
    }

    public static Field getField(Class<?> cls, String fieldName2, boolean forceAccess) {
        Validate.isTrue(cls != null, "The class must not be null", new Object[0]);
        Validate.isTrue(StringUtils.isNotBlank(fieldName2), "The field name must not be blank/empty", new Object[0]);
        for (Class<?> acls = cls; acls != null; acls = acls.getSuperclass()) {
            try {
                Field field2 = acls.getDeclaredField(fieldName2);
                if (!Modifier.isPublic(field2.getModifiers())) {
                    if (!forceAccess) continue;
                    field2.setAccessible(true);
                }
                return field2;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        Field match = null;
        for (Class<?> class1 : ClassUtils.getAllInterfaces(cls)) {
            try {
                Field test = class1.getField(fieldName2);
                Validate.isTrue(match == null, "Reference to field %s is ambiguous relative to %s; a matching field exists on two or more implemented interfaces.", fieldName2, cls);
                match = test;
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        return match;
    }

    public static Field getDeclaredField(Class<?> cls, String fieldName2) {
        return FieldUtils.getDeclaredField(cls, fieldName2, false);
    }

    public static Field getDeclaredField(Class<?> cls, String fieldName2, boolean forceAccess) {
        Validate.isTrue(cls != null, "The class must not be null", new Object[0]);
        Validate.isTrue(StringUtils.isNotBlank(fieldName2), "The field name must not be blank/empty", new Object[0]);
        try {
            Field field2 = cls.getDeclaredField(fieldName2);
            if (!MemberUtils.isAccessible(field2)) {
                if (forceAccess) {
                    field2.setAccessible(true);
                } else {
                    return null;
                }
            }
            return field2;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Field[] getAllFields(Class<?> cls) {
        List<Field> allFieldsList = FieldUtils.getAllFieldsList(cls);
        return allFieldsList.toArray(new Field[allFieldsList.size()]);
    }

    public static List<Field> getAllFieldsList(Class<?> cls) {
        Validate.isTrue(cls != null, "The class must not be null", new Object[0]);
        ArrayList<Field> allFields = new ArrayList<Field>();
        for (Class<?> currentClass = cls; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields = currentClass.getDeclaredFields();
            Collections.addAll(allFields, declaredFields);
        }
        return allFields;
    }

    public static Field[] getFieldsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        List<Field> annotatedFieldsList = FieldUtils.getFieldsListWithAnnotation(cls, annotationCls);
        return annotatedFieldsList.toArray(new Field[annotatedFieldsList.size()]);
    }

    public static List<Field> getFieldsListWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        Validate.isTrue(annotationCls != null, "The annotation class must not be null", new Object[0]);
        List<Field> allFields = FieldUtils.getAllFieldsList(cls);
        ArrayList<Field> annotatedFields = new ArrayList<Field>();
        for (Field field2 : allFields) {
            if (field2.getAnnotation(annotationCls) == null) continue;
            annotatedFields.add(field2);
        }
        return annotatedFields;
    }

    public static Object readStaticField(Field field2) throws IllegalAccessException {
        return FieldUtils.readStaticField(field2, false);
    }

    public static Object readStaticField(Field field2, boolean forceAccess) throws IllegalAccessException {
        Validate.isTrue(field2 != null, "The field must not be null", new Object[0]);
        Validate.isTrue(Modifier.isStatic(field2.getModifiers()), "The field '%s' is not static", field2.getName());
        return FieldUtils.readField(field2, null, forceAccess);
    }

    public static Object readStaticField(Class<?> cls, String fieldName2) throws IllegalAccessException {
        return FieldUtils.readStaticField(cls, fieldName2, false);
    }

    public static Object readStaticField(Class<?> cls, String fieldName2, boolean forceAccess) throws IllegalAccessException {
        Field field2 = FieldUtils.getField(cls, fieldName2, forceAccess);
        Validate.isTrue(field2 != null, "Cannot locate field '%s' on %s", fieldName2, cls);
        return FieldUtils.readStaticField(field2, false);
    }

    public static Object readDeclaredStaticField(Class<?> cls, String fieldName2) throws IllegalAccessException {
        return FieldUtils.readDeclaredStaticField(cls, fieldName2, false);
    }

    public static Object readDeclaredStaticField(Class<?> cls, String fieldName2, boolean forceAccess) throws IllegalAccessException {
        Field field2 = FieldUtils.getDeclaredField(cls, fieldName2, forceAccess);
        Validate.isTrue(field2 != null, "Cannot locate declared field %s.%s", cls.getName(), fieldName2);
        return FieldUtils.readStaticField(field2, false);
    }

    public static Object readField(Field field2, Object target) throws IllegalAccessException {
        return FieldUtils.readField(field2, target, false);
    }

    public static Object readField(Field field2, Object target, boolean forceAccess) throws IllegalAccessException {
        Validate.isTrue(field2 != null, "The field must not be null", new Object[0]);
        if (forceAccess && !field2.isAccessible()) {
            field2.setAccessible(true);
        } else {
            MemberUtils.setAccessibleWorkaround(field2);
        }
        return field2.get(target);
    }

    public static Object readField(Object target, String fieldName2) throws IllegalAccessException {
        return FieldUtils.readField(target, fieldName2, false);
    }

    public static Object readField(Object target, String fieldName2, boolean forceAccess) throws IllegalAccessException {
        Validate.isTrue(target != null, "target object must not be null", new Object[0]);
        Class<?> cls = target.getClass();
        Field field2 = FieldUtils.getField(cls, fieldName2, forceAccess);
        Validate.isTrue(field2 != null, "Cannot locate field %s on %s", fieldName2, cls);
        return FieldUtils.readField(field2, target, false);
    }

    public static Object readDeclaredField(Object target, String fieldName2) throws IllegalAccessException {
        return FieldUtils.readDeclaredField(target, fieldName2, false);
    }

    public static Object readDeclaredField(Object target, String fieldName2, boolean forceAccess) throws IllegalAccessException {
        Validate.isTrue(target != null, "target object must not be null", new Object[0]);
        Class<?> cls = target.getClass();
        Field field2 = FieldUtils.getDeclaredField(cls, fieldName2, forceAccess);
        Validate.isTrue(field2 != null, "Cannot locate declared field %s.%s", cls, fieldName2);
        return FieldUtils.readField(field2, target, false);
    }

    public static void writeStaticField(Field field2, Object value2) throws IllegalAccessException {
        FieldUtils.writeStaticField(field2, value2, false);
    }

    public static void writeStaticField(Field field2, Object value2, boolean forceAccess) throws IllegalAccessException {
        Validate.isTrue(field2 != null, "The field must not be null", new Object[0]);
        Validate.isTrue(Modifier.isStatic(field2.getModifiers()), "The field %s.%s is not static", field2.getDeclaringClass().getName(), field2.getName());
        FieldUtils.writeField(field2, null, value2, forceAccess);
    }

    public static void writeStaticField(Class<?> cls, String fieldName2, Object value2) throws IllegalAccessException {
        FieldUtils.writeStaticField(cls, fieldName2, value2, false);
    }

    public static void writeStaticField(Class<?> cls, String fieldName2, Object value2, boolean forceAccess) throws IllegalAccessException {
        Field field2 = FieldUtils.getField(cls, fieldName2, forceAccess);
        Validate.isTrue(field2 != null, "Cannot locate field %s on %s", fieldName2, cls);
        FieldUtils.writeStaticField(field2, value2, false);
    }

    public static void writeDeclaredStaticField(Class<?> cls, String fieldName2, Object value2) throws IllegalAccessException {
        FieldUtils.writeDeclaredStaticField(cls, fieldName2, value2, false);
    }

    public static void writeDeclaredStaticField(Class<?> cls, String fieldName2, Object value2, boolean forceAccess) throws IllegalAccessException {
        Field field2 = FieldUtils.getDeclaredField(cls, fieldName2, forceAccess);
        Validate.isTrue(field2 != null, "Cannot locate declared field %s.%s", cls.getName(), fieldName2);
        FieldUtils.writeField(field2, null, value2, false);
    }

    public static void writeField(Field field2, Object target, Object value2) throws IllegalAccessException {
        FieldUtils.writeField(field2, target, value2, false);
    }

    public static void writeField(Field field2, Object target, Object value2, boolean forceAccess) throws IllegalAccessException {
        Validate.isTrue(field2 != null, "The field must not be null", new Object[0]);
        if (forceAccess && !field2.isAccessible()) {
            field2.setAccessible(true);
        } else {
            MemberUtils.setAccessibleWorkaround(field2);
        }
        field2.set(target, value2);
    }

    public static void removeFinalModifier(Field field2) {
        FieldUtils.removeFinalModifier(field2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void removeFinalModifier(Field field2, boolean forceAccess) {
        block7: {
            Validate.isTrue(field2 != null, "The field must not be null", new Object[0]);
            try {
                boolean doForceAccess;
                if (!Modifier.isFinal(field2.getModifiers())) break block7;
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                boolean bl = doForceAccess = forceAccess && !modifiersField.isAccessible();
                if (doForceAccess) {
                    modifiersField.setAccessible(true);
                }
                try {
                    modifiersField.setInt(field2, field2.getModifiers() & 0xFFFFFFEF);
                }
                finally {
                    if (doForceAccess) {
                        modifiersField.setAccessible(false);
                    }
                }
            }
            catch (IllegalAccessException | NoSuchFieldException ignored) {
                if (!SystemUtils.isJavaVersionAtLeast(JavaVersion.JAVA_12)) break block7;
                throw new UnsupportedOperationException("In java 12+ final cannot be removed.", ignored);
            }
        }
    }

    public static void writeField(Object target, String fieldName2, Object value2) throws IllegalAccessException {
        FieldUtils.writeField(target, fieldName2, value2, false);
    }

    public static void writeField(Object target, String fieldName2, Object value2, boolean forceAccess) throws IllegalAccessException {
        Validate.isTrue(target != null, "target object must not be null", new Object[0]);
        Class<?> cls = target.getClass();
        Field field2 = FieldUtils.getField(cls, fieldName2, forceAccess);
        Validate.isTrue(field2 != null, "Cannot locate declared field %s.%s", cls.getName(), fieldName2);
        FieldUtils.writeField(field2, target, value2, false);
    }

    public static void writeDeclaredField(Object target, String fieldName2, Object value2) throws IllegalAccessException {
        FieldUtils.writeDeclaredField(target, fieldName2, value2, false);
    }

    public static void writeDeclaredField(Object target, String fieldName2, Object value2, boolean forceAccess) throws IllegalAccessException {
        Validate.isTrue(target != null, "target object must not be null", new Object[0]);
        Class<?> cls = target.getClass();
        Field field2 = FieldUtils.getDeclaredField(cls, fieldName2, forceAccess);
        Validate.isTrue(field2 != null, "Cannot locate declared field %s.%s", cls.getName(), fieldName2);
        FieldUtils.writeField(field2, target, value2, false);
    }
}

