/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ExceptionUtils {
    static final String WRAPPED_MARKER = " [wrapped] ";
    private static final String[] CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};

    @Deprecated
    public static String[] getDefaultCauseMethodNames() {
        return ArrayUtils.clone(CAUSE_METHOD_NAMES);
    }

    @Deprecated
    public static Throwable getCause(Throwable throwable2) {
        return ExceptionUtils.getCause(throwable2, null);
    }

    @Deprecated
    public static Throwable getCause(Throwable throwable2, String[] methodNames2) {
        if (throwable2 == null) {
            return null;
        }
        if (methodNames2 == null) {
            Throwable cause = throwable2.getCause();
            if (cause != null) {
                return cause;
            }
            methodNames2 = CAUSE_METHOD_NAMES;
        }
        for (String methodName : methodNames2) {
            Throwable legacyCause;
            if (methodName == null || (legacyCause = ExceptionUtils.getCauseUsingMethodName(throwable2, methodName)) == null) continue;
            return legacyCause;
        }
        return null;
    }

    public static Throwable getRootCause(Throwable throwable2) {
        List<Throwable> list2 = ExceptionUtils.getThrowableList(throwable2);
        return list2.isEmpty() ? null : list2.get(list2.size() - 1);
    }

    private static Throwable getCauseUsingMethodName(Throwable throwable2, String methodName) {
        Method method2 = null;
        try {
            method2 = throwable2.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        if (method2 != null && Throwable.class.isAssignableFrom(method2.getReturnType())) {
            try {
                return (Throwable)method2.invoke((Object)throwable2, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static int getThrowableCount(Throwable throwable2) {
        return ExceptionUtils.getThrowableList(throwable2).size();
    }

    public static Throwable[] getThrowables(Throwable throwable2) {
        List<Throwable> list2 = ExceptionUtils.getThrowableList(throwable2);
        return list2.toArray(new Throwable[list2.size()]);
    }

    public static List<Throwable> getThrowableList(Throwable throwable2) {
        ArrayList<Throwable> list2 = new ArrayList<Throwable>();
        while (throwable2 != null && !list2.contains(throwable2)) {
            list2.add(throwable2);
            throwable2 = throwable2.getCause();
        }
        return list2;
    }

    public static int indexOfThrowable(Throwable throwable2, Class<?> clazz2) {
        return ExceptionUtils.indexOf(throwable2, clazz2, 0, false);
    }

    public static int indexOfThrowable(Throwable throwable2, Class<?> clazz2, int fromIndex) {
        return ExceptionUtils.indexOf(throwable2, clazz2, fromIndex, false);
    }

    public static int indexOfType(Throwable throwable2, Class<?> type) {
        return ExceptionUtils.indexOf(throwable2, type, 0, true);
    }

    public static int indexOfType(Throwable throwable2, Class<?> type, int fromIndex) {
        return ExceptionUtils.indexOf(throwable2, type, fromIndex, true);
    }

    private static int indexOf(Throwable throwable2, Class<?> type, int fromIndex, boolean subclass) {
        Throwable[] throwables;
        if (throwable2 == null || type == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex >= (throwables = ExceptionUtils.getThrowables(throwable2)).length) {
            return -1;
        }
        if (subclass) {
            for (int i = fromIndex; i < throwables.length; ++i) {
                if (!type.isAssignableFrom(throwables[i].getClass())) continue;
                return i;
            }
        } else {
            for (int i = fromIndex; i < throwables.length; ++i) {
                if (!type.equals(throwables[i].getClass())) continue;
                return i;
            }
        }
        return -1;
    }

    public static void printRootCauseStackTrace(Throwable throwable2) {
        ExceptionUtils.printRootCauseStackTrace(throwable2, System.err);
    }

    public static void printRootCauseStackTrace(Throwable throwable2, PrintStream stream2) {
        String[] trace2;
        if (throwable2 == null) {
            return;
        }
        Validate.isTrue(stream2 != null, "The PrintStream must not be null", new Object[0]);
        for (String element2 : trace2 = ExceptionUtils.getRootCauseStackTrace(throwable2)) {
            stream2.println(element2);
        }
        stream2.flush();
    }

    public static void printRootCauseStackTrace(Throwable throwable2, PrintWriter writer2) {
        String[] trace2;
        if (throwable2 == null) {
            return;
        }
        Validate.isTrue(writer2 != null, "The PrintWriter must not be null", new Object[0]);
        for (String element2 : trace2 = ExceptionUtils.getRootCauseStackTrace(throwable2)) {
            writer2.println(element2);
        }
        writer2.flush();
    }

    public static String[] getRootCauseStackTrace(Throwable throwable2) {
        if (throwable2 == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        Throwable[] throwables = ExceptionUtils.getThrowables(throwable2);
        int count2 = throwables.length;
        ArrayList<String> frames = new ArrayList<String>();
        List<String> nextTrace = ExceptionUtils.getStackFrameList(throwables[count2 - 1]);
        int i = count2;
        while (--i >= 0) {
            List<String> trace2 = nextTrace;
            if (i != 0) {
                nextTrace = ExceptionUtils.getStackFrameList(throwables[i - 1]);
                ExceptionUtils.removeCommonFrames(trace2, nextTrace);
            }
            if (i == count2 - 1) {
                frames.add(throwables[i].toString());
            } else {
                frames.add(WRAPPED_MARKER + throwables[i].toString());
            }
            frames.addAll(trace2);
        }
        return frames.toArray(new String[frames.size()]);
    }

    public static void removeCommonFrames(List<String> causeFrames, List<String> wrapperFrames) {
        if (causeFrames == null || wrapperFrames == null) {
            throw new IllegalArgumentException("The List must not be null");
        }
        int causeFrameIndex = causeFrames.size() - 1;
        for (int wrapperFrameIndex = wrapperFrames.size() - 1; causeFrameIndex >= 0 && wrapperFrameIndex >= 0; --causeFrameIndex, --wrapperFrameIndex) {
            String wrapperFrame;
            String causeFrame = causeFrames.get(causeFrameIndex);
            if (!causeFrame.equals(wrapperFrame = wrapperFrames.get(wrapperFrameIndex))) continue;
            causeFrames.remove(causeFrameIndex);
        }
    }

    public static String getStackTrace(Throwable throwable2) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable2.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static String[] getStackFrames(Throwable throwable2) {
        if (throwable2 == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return ExceptionUtils.getStackFrames(ExceptionUtils.getStackTrace(throwable2));
    }

    static String[] getStackFrames(String stackTrace) {
        String linebreak = System.lineSeparator();
        StringTokenizer frames = new StringTokenizer(stackTrace, linebreak);
        ArrayList<String> list2 = new ArrayList<String>();
        while (frames.hasMoreTokens()) {
            list2.add(frames.nextToken());
        }
        return list2.toArray(new String[list2.size()]);
    }

    static List<String> getStackFrameList(Throwable t) {
        String stackTrace = ExceptionUtils.getStackTrace(t);
        String linebreak = System.lineSeparator();
        StringTokenizer frames = new StringTokenizer(stackTrace, linebreak);
        ArrayList<String> list2 = new ArrayList<String>();
        boolean traceStarted = false;
        while (frames.hasMoreTokens()) {
            String token2 = frames.nextToken();
            int at2 = token2.indexOf("at");
            if (at2 != -1 && token2.substring(0, at2).trim().isEmpty()) {
                traceStarted = true;
                list2.add(token2);
                continue;
            }
            if (!traceStarted) continue;
            break;
        }
        return list2;
    }

    public static String getMessage(Throwable th) {
        if (th == null) {
            return "";
        }
        String clsName = ClassUtils.getShortClassName(th, null);
        String msg = th.getMessage();
        return clsName + ": " + StringUtils.defaultString(msg);
    }

    public static String getRootCauseMessage(Throwable th) {
        Throwable root2 = ExceptionUtils.getRootCause(th);
        root2 = root2 == null ? th : root2;
        return ExceptionUtils.getMessage(root2);
    }

    public static <R> R rethrow(Throwable throwable2) {
        return ExceptionUtils.typeErasure(throwable2);
    }

    private static <R, T extends Throwable> R typeErasure(Throwable throwable2) throws T {
        throw throwable2;
    }

    public static <R> R wrapAndThrow(Throwable throwable2) {
        if (throwable2 instanceof RuntimeException) {
            throw (RuntimeException)throwable2;
        }
        if (throwable2 instanceof Error) {
            throw (Error)throwable2;
        }
        throw new UndeclaredThrowableException(throwable2);
    }

    public static boolean hasCause(Throwable chain2, Class<? extends Throwable> type) {
        if (chain2 instanceof UndeclaredThrowableException) {
            chain2 = chain2.getCause();
        }
        return type.isInstance(chain2);
    }
}

