/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ToStringBuilder
implements Builder<String> {
    private static volatile ToStringStyle defaultStyle = ToStringStyle.DEFAULT_STYLE;
    private final StringBuffer buffer;
    private final Object object;
    private final ToStringStyle style;

    public static ToStringStyle getDefaultStyle() {
        return defaultStyle;
    }

    public static void setDefaultStyle(ToStringStyle style) {
        Validate.isTrue(style != null, "The style must not be null", new Object[0]);
        defaultStyle = style;
    }

    public static String reflectionToString(Object object) {
        return ReflectionToStringBuilder.toString(object);
    }

    public static String reflectionToString(Object object, ToStringStyle style) {
        return ReflectionToStringBuilder.toString(object, style);
    }

    public static String reflectionToString(Object object, ToStringStyle style, boolean outputTransients) {
        return ReflectionToStringBuilder.toString(object, style, outputTransients, false, null);
    }

    public static <T> String reflectionToString(T object, ToStringStyle style, boolean outputTransients, Class<? super T> reflectUpToClass) {
        return ReflectionToStringBuilder.toString(object, style, outputTransients, false, reflectUpToClass);
    }

    public ToStringBuilder(Object object) {
        this(object, null, null);
    }

    public ToStringBuilder(Object object, ToStringStyle style) {
        this(object, style, null);
    }

    public ToStringBuilder(Object object, ToStringStyle style, StringBuffer buffer) {
        if (style == null) {
            style = ToStringBuilder.getDefaultStyle();
        }
        if (buffer == null) {
            buffer = new StringBuffer(512);
        }
        this.buffer = buffer;
        this.style = style;
        this.object = object;
        style.appendStart(buffer, object);
    }

    public ToStringBuilder append(boolean value2) {
        this.style.append(this.buffer, null, value2);
        return this;
    }

    public ToStringBuilder append(boolean[] array2) {
        this.style.append(this.buffer, (String)null, array2, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(byte value2) {
        this.style.append(this.buffer, (String)null, value2);
        return this;
    }

    public ToStringBuilder append(byte[] array2) {
        this.style.append(this.buffer, (String)null, array2, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(char value2) {
        this.style.append(this.buffer, (String)null, value2);
        return this;
    }

    public ToStringBuilder append(char[] array2) {
        this.style.append(this.buffer, (String)null, array2, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(double value2) {
        this.style.append(this.buffer, null, value2);
        return this;
    }

    public ToStringBuilder append(double[] array2) {
        this.style.append(this.buffer, (String)null, array2, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(float value2) {
        this.style.append(this.buffer, (String)null, value2);
        return this;
    }

    public ToStringBuilder append(float[] array2) {
        this.style.append(this.buffer, (String)null, array2, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(int value2) {
        this.style.append(this.buffer, (String)null, value2);
        return this;
    }

    public ToStringBuilder append(int[] array2) {
        this.style.append(this.buffer, (String)null, array2, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(long value2) {
        this.style.append(this.buffer, (String)null, value2);
        return this;
    }

    public ToStringBuilder append(long[] array2) {
        this.style.append(this.buffer, (String)null, array2, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(Object obj) {
        this.style.append(this.buffer, null, obj, null);
        return this;
    }

    public ToStringBuilder append(Object[] array2) {
        this.style.append(this.buffer, (String)null, array2, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(short value2) {
        this.style.append(this.buffer, (String)null, value2);
        return this;
    }

    public ToStringBuilder append(short[] array2) {
        this.style.append(this.buffer, (String)null, array2, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName2, boolean value2) {
        this.style.append(this.buffer, fieldName2, value2);
        return this;
    }

    public ToStringBuilder append(String fieldName2, boolean[] array2) {
        this.style.append(this.buffer, fieldName2, array2, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName2, boolean[] array2, boolean fullDetail) {
        this.style.append(this.buffer, fieldName2, array2, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder append(String fieldName2, byte value2) {
        this.style.append(this.buffer, fieldName2, value2);
        return this;
    }

    public ToStringBuilder append(String fieldName2, byte[] array2) {
        this.style.append(this.buffer, fieldName2, array2, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName2, byte[] array2, boolean fullDetail) {
        this.style.append(this.buffer, fieldName2, array2, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder append(String fieldName2, char value2) {
        this.style.append(this.buffer, fieldName2, value2);
        return this;
    }

    public ToStringBuilder append(String fieldName2, char[] array2) {
        this.style.append(this.buffer, fieldName2, array2, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName2, char[] array2, boolean fullDetail) {
        this.style.append(this.buffer, fieldName2, array2, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder append(String fieldName2, double value2) {
        this.style.append(this.buffer, fieldName2, value2);
        return this;
    }

    public ToStringBuilder append(String fieldName2, double[] array2) {
        this.style.append(this.buffer, fieldName2, array2, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName2, double[] array2, boolean fullDetail) {
        this.style.append(this.buffer, fieldName2, array2, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder append(String fieldName2, float value2) {
        this.style.append(this.buffer, fieldName2, value2);
        return this;
    }

    public ToStringBuilder append(String fieldName2, float[] array2) {
        this.style.append(this.buffer, fieldName2, array2, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName2, float[] array2, boolean fullDetail) {
        this.style.append(this.buffer, fieldName2, array2, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder append(String fieldName2, int value2) {
        this.style.append(this.buffer, fieldName2, value2);
        return this;
    }

    public ToStringBuilder append(String fieldName2, int[] array2) {
        this.style.append(this.buffer, fieldName2, array2, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName2, int[] array2, boolean fullDetail) {
        this.style.append(this.buffer, fieldName2, array2, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder append(String fieldName2, long value2) {
        this.style.append(this.buffer, fieldName2, value2);
        return this;
    }

    public ToStringBuilder append(String fieldName2, long[] array2) {
        this.style.append(this.buffer, fieldName2, array2, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName2, long[] array2, boolean fullDetail) {
        this.style.append(this.buffer, fieldName2, array2, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder append(String fieldName2, Object obj) {
        this.style.append(this.buffer, fieldName2, obj, null);
        return this;
    }

    public ToStringBuilder append(String fieldName2, Object obj, boolean fullDetail) {
        this.style.append(this.buffer, fieldName2, obj, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder append(String fieldName2, Object[] array2) {
        this.style.append(this.buffer, fieldName2, array2, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName2, Object[] array2, boolean fullDetail) {
        this.style.append(this.buffer, fieldName2, array2, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder append(String fieldName2, short value2) {
        this.style.append(this.buffer, fieldName2, value2);
        return this;
    }

    public ToStringBuilder append(String fieldName2, short[] array2) {
        this.style.append(this.buffer, fieldName2, array2, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName2, short[] array2, boolean fullDetail) {
        this.style.append(this.buffer, fieldName2, array2, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder appendAsObjectToString(Object srcObject) {
        ObjectUtils.identityToString(this.getStringBuffer(), srcObject);
        return this;
    }

    public ToStringBuilder appendSuper(String superToString) {
        if (superToString != null) {
            this.style.appendSuper(this.buffer, superToString);
        }
        return this;
    }

    public ToStringBuilder appendToString(String toString2) {
        if (toString2 != null) {
            this.style.appendToString(this.buffer, toString2);
        }
        return this;
    }

    public Object getObject() {
        return this.object;
    }

    public StringBuffer getStringBuffer() {
        return this.buffer;
    }

    public ToStringStyle getStyle() {
        return this.style;
    }

    public String toString() {
        if (this.getObject() == null) {
            this.getStringBuffer().append(this.getStyle().getNullText());
        } else {
            this.style.appendEnd(this.getStringBuffer(), this.getObject());
        }
        return this.getStringBuffer().toString();
    }

    @Override
    public String build() {
        return this.toString();
    }
}

