/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

public class CharSequenceUtils {
    private static final int NOT_FOUND = -1;

    public static CharSequence subSequence(CharSequence cs, int start2) {
        return cs == null ? null : cs.subSequence(start2, cs.length());
    }

    static int indexOf(CharSequence cs, int searchChar, int start2) {
        if (cs instanceof String) {
            return ((String)cs).indexOf(searchChar, start2);
        }
        int sz = cs.length();
        if (start2 < 0) {
            start2 = 0;
        }
        if (searchChar < 65536) {
            for (int i = start2; i < sz; ++i) {
                if (cs.charAt(i) != searchChar) continue;
                return i;
            }
        }
        if (searchChar <= 0x10FFFF) {
            char[] chars = Character.toChars(searchChar);
            for (int i = start2; i < sz - 1; ++i) {
                char high = cs.charAt(i);
                char low = cs.charAt(i + 1);
                if (high != chars[0] || low != chars[1]) continue;
                return i;
            }
        }
        return -1;
    }

    static int indexOf(CharSequence cs, CharSequence searchChar, int start2) {
        return cs.toString().indexOf(searchChar.toString(), start2);
    }

    static int lastIndexOf(CharSequence cs, int searchChar, int start2) {
        if (cs instanceof String) {
            return ((String)cs).lastIndexOf(searchChar, start2);
        }
        int sz = cs.length();
        if (start2 < 0) {
            return -1;
        }
        if (start2 >= sz) {
            start2 = sz - 1;
        }
        if (searchChar < 65536) {
            for (int i = start2; i >= 0; --i) {
                if (cs.charAt(i) != searchChar) continue;
                return i;
            }
        }
        if (searchChar <= 0x10FFFF) {
            char[] chars = Character.toChars(searchChar);
            if (start2 == sz - 1) {
                return -1;
            }
            for (int i = start2; i >= 0; --i) {
                char high = cs.charAt(i);
                char low = cs.charAt(i + 1);
                if (chars[0] != high || chars[1] != low) continue;
                return i;
            }
        }
        return -1;
    }

    static int lastIndexOf(CharSequence cs, CharSequence searchChar, int start2) {
        return cs.toString().lastIndexOf(searchChar.toString(), start2);
    }

    static char[] toCharArray(CharSequence cs) {
        if (cs instanceof String) {
            return ((String)cs).toCharArray();
        }
        int sz = cs.length();
        char[] array2 = new char[cs.length()];
        for (int i = 0; i < sz; ++i) {
            array2[i] = cs.charAt(i);
        }
        return array2;
    }

    static boolean regionMatches(CharSequence cs, boolean ignoreCase, int thisStart, CharSequence substring, int start2, int length2) {
        if (cs instanceof String && substring instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, thisStart, (String)substring, start2, length2);
        }
        int index1 = thisStart;
        int index2 = start2;
        int tmpLen = length2;
        int srcLen = cs.length() - thisStart;
        int otherLen = substring.length() - start2;
        if (thisStart < 0 || start2 < 0 || length2 < 0) {
            return false;
        }
        if (srcLen < length2 || otherLen < length2) {
            return false;
        }
        while (tmpLen-- > 0) {
            char c2;
            char c1;
            if ((c1 = cs.charAt(index1++)) == (c2 = substring.charAt(index2++))) continue;
            if (!ignoreCase) {
                return false;
            }
            if (Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }
}

