/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.reflect.MemberUtils;

public class FieldUtils {
    public static Field getField(Class cls, String fieldName2) {
        Field field2 = FieldUtils.getField(cls, fieldName2, false);
        MemberUtils.setAccessibleWorkaround(field2);
        return field2;
    }

    public static Field getField(Class cls, String fieldName2, boolean forceAccess) {
        if (cls == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        if (fieldName2 == null) {
            throw new IllegalArgumentException("The field name must not be null");
        }
        for (Class acls = cls; acls != null; acls = acls.getSuperclass()) {
            try {
                Field field2 = acls.getDeclaredField(fieldName2);
                if (!Modifier.isPublic(field2.getModifiers())) {
                    if (!forceAccess) continue;
                    field2.setAccessible(true);
                }
                return field2;
            }
            catch (NoSuchFieldException ex) {
                // empty catch block
            }
        }
        Field match = null;
        Iterator intf = ClassUtils.getAllInterfaces(cls).iterator();
        while (intf.hasNext()) {
            try {
                Field test = ((Class)intf.next()).getField(fieldName2);
                if (match != null) {
                    throw new IllegalArgumentException("Reference to field " + fieldName2 + " is ambiguous relative to " + cls + "; a matching field exists on two or more implemented interfaces.");
                }
                match = test;
            }
            catch (NoSuchFieldException ex) {}
        }
        return match;
    }

    public static Field getDeclaredField(Class cls, String fieldName2) {
        return FieldUtils.getDeclaredField(cls, fieldName2, false);
    }

    public static Field getDeclaredField(Class cls, String fieldName2, boolean forceAccess) {
        if (cls == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        if (fieldName2 == null) {
            throw new IllegalArgumentException("The field name must not be null");
        }
        try {
            Field field2 = cls.getDeclaredField(fieldName2);
            if (!MemberUtils.isAccessible(field2)) {
                if (forceAccess) {
                    field2.setAccessible(true);
                } else {
                    return null;
                }
            }
            return field2;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Object readStaticField(Field field2) throws IllegalAccessException {
        return FieldUtils.readStaticField(field2, false);
    }

    public static Object readStaticField(Field field2, boolean forceAccess) throws IllegalAccessException {
        if (field2 == null) {
            throw new IllegalArgumentException("The field must not be null");
        }
        if (!Modifier.isStatic(field2.getModifiers())) {
            throw new IllegalArgumentException("The field '" + field2.getName() + "' is not static");
        }
        return FieldUtils.readField(field2, (Object)null, forceAccess);
    }

    public static Object readStaticField(Class cls, String fieldName2) throws IllegalAccessException {
        return FieldUtils.readStaticField(cls, fieldName2, false);
    }

    public static Object readStaticField(Class cls, String fieldName2, boolean forceAccess) throws IllegalAccessException {
        Field field2 = FieldUtils.getField(cls, fieldName2, forceAccess);
        if (field2 == null) {
            throw new IllegalArgumentException("Cannot locate field " + fieldName2 + " on " + cls);
        }
        return FieldUtils.readStaticField(field2, false);
    }

    public static Object readDeclaredStaticField(Class cls, String fieldName2) throws IllegalAccessException {
        return FieldUtils.readDeclaredStaticField(cls, fieldName2, false);
    }

    public static Object readDeclaredStaticField(Class cls, String fieldName2, boolean forceAccess) throws IllegalAccessException {
        Field field2 = FieldUtils.getDeclaredField(cls, fieldName2, forceAccess);
        if (field2 == null) {
            throw new IllegalArgumentException("Cannot locate declared field " + cls.getName() + "." + fieldName2);
        }
        return FieldUtils.readStaticField(field2, false);
    }

    public static Object readField(Field field2, Object target) throws IllegalAccessException {
        return FieldUtils.readField(field2, target, false);
    }

    public static Object readField(Field field2, Object target, boolean forceAccess) throws IllegalAccessException {
        if (field2 == null) {
            throw new IllegalArgumentException("The field must not be null");
        }
        if (forceAccess && !field2.isAccessible()) {
            field2.setAccessible(true);
        } else {
            MemberUtils.setAccessibleWorkaround(field2);
        }
        return field2.get(target);
    }

    public static Object readField(Object target, String fieldName2) throws IllegalAccessException {
        return FieldUtils.readField(target, fieldName2, false);
    }

    public static Object readField(Object target, String fieldName2, boolean forceAccess) throws IllegalAccessException {
        if (target == null) {
            throw new IllegalArgumentException("target object must not be null");
        }
        Class<?> cls = target.getClass();
        Field field2 = FieldUtils.getField(cls, fieldName2, forceAccess);
        if (field2 == null) {
            throw new IllegalArgumentException("Cannot locate field " + fieldName2 + " on " + cls);
        }
        return FieldUtils.readField(field2, target);
    }

    public static Object readDeclaredField(Object target, String fieldName2) throws IllegalAccessException {
        return FieldUtils.readDeclaredField(target, fieldName2, false);
    }

    public static Object readDeclaredField(Object target, String fieldName2, boolean forceAccess) throws IllegalAccessException {
        if (target == null) {
            throw new IllegalArgumentException("target object must not be null");
        }
        Class<?> cls = target.getClass();
        Field field2 = FieldUtils.getDeclaredField(cls, fieldName2, forceAccess);
        if (field2 == null) {
            throw new IllegalArgumentException("Cannot locate declared field " + cls.getName() + "." + fieldName2);
        }
        return FieldUtils.readField(field2, target);
    }

    public static void writeStaticField(Field field2, Object value2) throws IllegalAccessException {
        FieldUtils.writeStaticField(field2, value2, false);
    }

    public static void writeStaticField(Field field2, Object value2, boolean forceAccess) throws IllegalAccessException {
        if (field2 == null) {
            throw new IllegalArgumentException("The field must not be null");
        }
        if (!Modifier.isStatic(field2.getModifiers())) {
            throw new IllegalArgumentException("The field '" + field2.getName() + "' is not static");
        }
        FieldUtils.writeField(field2, (Object)null, value2, forceAccess);
    }

    public static void writeStaticField(Class cls, String fieldName2, Object value2) throws IllegalAccessException {
        FieldUtils.writeStaticField(cls, fieldName2, value2, false);
    }

    public static void writeStaticField(Class cls, String fieldName2, Object value2, boolean forceAccess) throws IllegalAccessException {
        Field field2 = FieldUtils.getField(cls, fieldName2, forceAccess);
        if (field2 == null) {
            throw new IllegalArgumentException("Cannot locate field " + fieldName2 + " on " + cls);
        }
        FieldUtils.writeStaticField(field2, value2);
    }

    public static void writeDeclaredStaticField(Class cls, String fieldName2, Object value2) throws IllegalAccessException {
        FieldUtils.writeDeclaredStaticField(cls, fieldName2, value2, false);
    }

    public static void writeDeclaredStaticField(Class cls, String fieldName2, Object value2, boolean forceAccess) throws IllegalAccessException {
        Field field2 = FieldUtils.getDeclaredField(cls, fieldName2, forceAccess);
        if (field2 == null) {
            throw new IllegalArgumentException("Cannot locate declared field " + cls.getName() + "." + fieldName2);
        }
        FieldUtils.writeField(field2, (Object)null, value2);
    }

    public static void writeField(Field field2, Object target, Object value2) throws IllegalAccessException {
        FieldUtils.writeField(field2, target, value2, false);
    }

    public static void writeField(Field field2, Object target, Object value2, boolean forceAccess) throws IllegalAccessException {
        if (field2 == null) {
            throw new IllegalArgumentException("The field must not be null");
        }
        if (forceAccess && !field2.isAccessible()) {
            field2.setAccessible(true);
        } else {
            MemberUtils.setAccessibleWorkaround(field2);
        }
        field2.set(target, value2);
    }

    public static void writeField(Object target, String fieldName2, Object value2) throws IllegalAccessException {
        FieldUtils.writeField(target, fieldName2, value2, false);
    }

    public static void writeField(Object target, String fieldName2, Object value2, boolean forceAccess) throws IllegalAccessException {
        if (target == null) {
            throw new IllegalArgumentException("target object must not be null");
        }
        Class<?> cls = target.getClass();
        Field field2 = FieldUtils.getField(cls, fieldName2, forceAccess);
        if (field2 == null) {
            throw new IllegalArgumentException("Cannot locate declared field " + cls.getName() + "." + fieldName2);
        }
        FieldUtils.writeField(field2, target, value2);
    }

    public static void writeDeclaredField(Object target, String fieldName2, Object value2) throws IllegalAccessException {
        FieldUtils.writeDeclaredField(target, fieldName2, value2, false);
    }

    public static void writeDeclaredField(Object target, String fieldName2, Object value2, boolean forceAccess) throws IllegalAccessException {
        if (target == null) {
            throw new IllegalArgumentException("target object must not be null");
        }
        Class<?> cls = target.getClass();
        Field field2 = FieldUtils.getDeclaredField(cls, fieldName2, forceAccess);
        if (field2 == null) {
            throw new IllegalArgumentException("Cannot locate declared field " + cls.getName() + "." + fieldName2);
        }
        FieldUtils.writeField(field2, target, value2);
    }
}

