/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class Validate {
    public static void isTrue(boolean expression2, String message, Object value2) {
        if (!expression2) {
            throw new IllegalArgumentException(message + value2);
        }
    }

    public static void isTrue(boolean expression2, String message, long value2) {
        if (!expression2) {
            throw new IllegalArgumentException(message + value2);
        }
    }

    public static void isTrue(boolean expression2, String message, double value2) {
        if (!expression2) {
            throw new IllegalArgumentException(message + value2);
        }
    }

    public static void isTrue(boolean expression2, String message) {
        if (!expression2) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isTrue(boolean expression2) {
        if (!expression2) {
            throw new IllegalArgumentException("The validated expression is false");
        }
    }

    public static void notNull(Object object) {
        Validate.notNull(object, "The validated object is null");
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Object[] array2, String message) {
        if (array2 == null || array2.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Object[] array2) {
        Validate.notEmpty(array2, "The validated array is empty");
    }

    public static void notEmpty(Collection collection, String message) {
        if (collection == null || collection.size() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Collection collection) {
        Validate.notEmpty(collection, "The validated collection is empty");
    }

    public static void notEmpty(Map map2, String message) {
        if (map2 == null || map2.size() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Map map2) {
        Validate.notEmpty(map2, "The validated map is empty");
    }

    public static void notEmpty(String string2, String message) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(String string2) {
        Validate.notEmpty(string2, "The validated string is empty");
    }

    public static void noNullElements(Object[] array2, String message) {
        Validate.notNull(array2);
        for (int i = 0; i < array2.length; ++i) {
            if (array2[i] != null) continue;
            throw new IllegalArgumentException(message);
        }
    }

    public static void noNullElements(Object[] array2) {
        Validate.notNull(array2);
        for (int i = 0; i < array2.length; ++i) {
            if (array2[i] != null) continue;
            throw new IllegalArgumentException("The validated array contains null element at index: " + i);
        }
    }

    public static void noNullElements(Collection collection, String message) {
        Validate.notNull(collection);
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            throw new IllegalArgumentException(message);
        }
    }

    public static void noNullElements(Collection collection) {
        Validate.notNull(collection);
        int i = 0;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            if (it.next() == null) {
                throw new IllegalArgumentException("The validated collection contains null element at index: " + i);
            }
            ++i;
        }
    }

    public static void allElementsOfType(Collection collection, Class clazz2, String message) {
        Validate.notNull(collection);
        Validate.notNull(clazz2);
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            if (clazz2.isInstance(it.next())) continue;
            throw new IllegalArgumentException(message);
        }
    }

    public static void allElementsOfType(Collection collection, Class clazz2) {
        Validate.notNull(collection);
        Validate.notNull(clazz2);
        int i = 0;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            if (!clazz2.isInstance(it.next())) {
                throw new IllegalArgumentException("The validated collection contains an element not of type " + clazz2.getName() + " at index: " + i);
            }
            ++i;
        }
    }
}

