/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ChunkedOutputStream
extends FilterOutputStream {
    private static final int DEFAULT_CHUNK_SIZE = 4096;
    private final int chunkSize;

    public ChunkedOutputStream(OutputStream stream2, int chunkSize) {
        super(stream2);
        if (chunkSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.chunkSize = chunkSize;
    }

    public ChunkedOutputStream(OutputStream stream2) {
        this(stream2, 4096);
    }

    @Override
    public void write(byte[] data, int srcOffset, int length2) throws IOException {
        int bytes2 = length2;
        int dstOffset = srcOffset;
        while (bytes2 > 0) {
            int chunk = Math.min(bytes2, this.chunkSize);
            this.out.write(data, dstOffset, chunk);
            bytes2 -= chunk;
            dstOffset += chunk;
        }
    }
}

