/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree.xpath;

import java.util.List;
import java.util.Locale;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.xpath.ConfigurationNodeIteratorAttribute;
import org.apache.commons.configuration.tree.xpath.ConfigurationNodeIteratorChildren;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;

class ConfigurationNodePointer
extends NodePointer {
    private static final long serialVersionUID = -1087475639680007713L;
    private ConfigurationNode node;

    public ConfigurationNodePointer(ConfigurationNode node4, Locale locale) {
        super(null, locale);
        this.node = node4;
    }

    public ConfigurationNodePointer(NodePointer parent2, ConfigurationNode node4) {
        super(parent2);
        this.node = node4;
    }

    public boolean isLeaf() {
        return this.node.getChildrenCount() < 1;
    }

    public boolean isCollection() {
        return false;
    }

    public int getLength() {
        return 1;
    }

    public boolean isAttribute() {
        return this.node.isAttribute();
    }

    public QName getName() {
        return new QName(null, this.node.getName());
    }

    public Object getBaseValue() {
        return this.node;
    }

    public Object getImmediateNode() {
        return this.node;
    }

    public Object getValue() {
        return this.node.getValue();
    }

    public void setValue(Object value2) {
        this.node.setValue(value2);
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        ConfigurationNode node1 = (ConfigurationNode)pointer1.getBaseValue();
        ConfigurationNode node22 = (ConfigurationNode)pointer2.getBaseValue();
        if (node1.isAttribute() && !node22.isAttribute()) {
            return -1;
        }
        if (node22.isAttribute() && !node1.isAttribute()) {
            return 1;
        }
        List<ConfigurationNode> subNodes = node1.isAttribute() ? this.node.getAttributes() : this.node.getChildren();
        for (ConfigurationNode child : subNodes) {
            if (child == node1) {
                return -1;
            }
            if (child != node22) continue;
            return 1;
        }
        return 0;
    }

    public NodeIterator attributeIterator(QName name) {
        return new ConfigurationNodeIteratorAttribute((NodePointer)this, name);
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse2, NodePointer startWith) {
        return new ConfigurationNodeIteratorChildren(this, test, reverse2, startWith);
    }

    public boolean testNode(NodeTest test) {
        if (test instanceof NodeTypeTest && ((NodeTypeTest)test).getNodeType() == 2) {
            return true;
        }
        return super.testNode(test);
    }
}

