/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.NodeCombiner;
import org.apache.commons.configuration.tree.ViewNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionCombiner
extends NodeCombiner {
    @Override
    public ConfigurationNode combine(ConfigurationNode node1, ConfigurationNode node22) {
        ViewNode result2 = this.createViewNode();
        result2.setName(node1.getName());
        result2.appendAttributes(node1);
        result2.appendAttributes(node22);
        LinkedList<ConfigurationNode> children2 = new LinkedList<ConfigurationNode>(node22.getChildren());
        for (ConfigurationNode child1 : node1.getChildren()) {
            ConfigurationNode child2 = this.findCombineNode(node1, node22, child1, children2);
            if (child2 != null) {
                result2.addChild(this.combine(child1, child2));
                children2.remove(child2);
                continue;
            }
            result2.addChild(child1);
        }
        for (ConfigurationNode c : children2) {
            result2.addChild(c);
        }
        return result2;
    }

    protected ConfigurationNode findCombineNode(ConfigurationNode node1, ConfigurationNode node22, ConfigurationNode child, List<ConfigurationNode> children2) {
        ConfigurationNode child2;
        if (child.getValue() == null && !this.isListNode(child) && node1.getChildrenCount(child.getName()) == 1 && node22.getChildrenCount(child.getName()) == 1 && (child2 = node22.getChildren(child.getName()).iterator().next()).getValue() == null) {
            return child2;
        }
        return null;
    }
}

