/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree;

import java.io.PrintStream;
import java.util.Iterator;
import org.apache.commons.configuration.tree.ConfigurationNode;

public final class TreeUtils {
    private TreeUtils() {
    }

    public static void printTree(PrintStream stream2, ConfigurationNode result2) {
        if (stream2 != null) {
            TreeUtils.printTree(stream2, "", result2);
        }
    }

    private static void printTree(PrintStream stream2, String indent2, ConfigurationNode result2) {
        StringBuffer buffer = new StringBuffer(indent2).append("<").append(result2.getName());
        for (ConfigurationNode node4 : result2.getAttributes()) {
            buffer.append(" ").append(node4.getName()).append("='").append(node4.getValue()).append("'");
        }
        buffer.append(">");
        stream2.print(buffer.toString());
        if (result2.getValue() != null) {
            stream2.print(result2.getValue());
        }
        boolean newline = false;
        if (result2.getChildrenCount() > 0) {
            stream2.print("\n");
            Iterator<ConfigurationNode> iter2 = result2.getChildren().iterator();
            while (iter2.hasNext()) {
                TreeUtils.printTree(stream2, indent2 + "  ", iter2.next());
            }
            newline = true;
        }
        if (newline) {
            stream2.print(indent2);
        }
        stream2.println("</" + result2.getName() + ">");
    }
}

