/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree;

import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.NodeCombiner;
import org.apache.commons.configuration.tree.ViewNode;

public class OverrideCombiner
extends NodeCombiner {
    public ConfigurationNode combine(ConfigurationNode node1, ConfigurationNode node22) {
        ViewNode result2 = this.createViewNode();
        result2.setName(node1.getName());
        for (ConfigurationNode child : node1.getChildren()) {
            ConfigurationNode child2 = this.canCombine(node1, node22, child);
            if (child2 != null) {
                result2.addChild(this.combine(child, child2));
                continue;
            }
            result2.addChild(child);
        }
        for (ConfigurationNode child : node22.getChildren()) {
            if (node1.getChildrenCount(child.getName()) >= 1) continue;
            result2.addChild(child);
        }
        this.addAttributes(result2, node1, node22);
        result2.setValue(node1.getValue() != null ? node1.getValue() : node22.getValue());
        return result2;
    }

    protected void addAttributes(ViewNode result2, ConfigurationNode node1, ConfigurationNode node22) {
        result2.appendAttributes(node1);
        for (ConfigurationNode attr : node22.getAttributes()) {
            if (node1.getAttributeCount(attr.getName()) != 0) continue;
            result2.addAttribute(attr);
        }
    }

    protected ConfigurationNode canCombine(ConfigurationNode node1, ConfigurationNode node22, ConfigurationNode child) {
        if (node22.getChildrenCount(child.getName()) == 1 && node1.getChildrenCount(child.getName()) == 1 && !this.isListNode(child)) {
            return node22.getChildren(child.getName()).get(0);
        }
        return null;
    }
}

