/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationKey;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.NodeAddData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExpressionEngine
implements ExpressionEngine {
    public static final String DEFAULT_PROPERTY_DELIMITER = ".";
    public static final String DEFAULT_ESCAPED_DELIMITER = "..";
    public static final String DEFAULT_ATTRIBUTE_START = "[@";
    public static final String DEFAULT_ATTRIBUTE_END = "]";
    public static final String DEFAULT_INDEX_START = "(";
    public static final String DEFAULT_INDEX_END = ")";
    private String propertyDelimiter = ".";
    private String escapedDelimiter = "..";
    private String attributeStart = "[@";
    private String attributeEnd = "]";
    private String indexStart = "(";
    private String indexEnd = ")";

    public String getAttributeEnd() {
        return this.attributeEnd;
    }

    public void setAttributeEnd(String attributeEnd) {
        this.attributeEnd = attributeEnd;
    }

    public String getAttributeStart() {
        return this.attributeStart;
    }

    public void setAttributeStart(String attributeStart) {
        this.attributeStart = attributeStart;
    }

    public String getEscapedDelimiter() {
        return this.escapedDelimiter;
    }

    public void setEscapedDelimiter(String escapedDelimiter) {
        this.escapedDelimiter = escapedDelimiter;
    }

    public String getIndexEnd() {
        return this.indexEnd;
    }

    public void setIndexEnd(String indexEnd) {
        this.indexEnd = indexEnd;
    }

    public String getIndexStart() {
        return this.indexStart;
    }

    public void setIndexStart(String indexStart) {
        this.indexStart = indexStart;
    }

    public String getPropertyDelimiter() {
        return this.propertyDelimiter;
    }

    public void setPropertyDelimiter(String propertyDelimiter) {
        this.propertyDelimiter = propertyDelimiter;
    }

    @Override
    public List<ConfigurationNode> query(ConfigurationNode root2, String key) {
        LinkedList<ConfigurationNode> nodes2 = new LinkedList<ConfigurationNode>();
        this.findNodesForKey(new DefaultConfigurationKey(this, key).iterator(), root2, nodes2);
        return nodes2;
    }

    @Override
    public String nodeKey(ConfigurationNode node4, String parentKey) {
        if (parentKey == null) {
            return "";
        }
        DefaultConfigurationKey key = new DefaultConfigurationKey(this, parentKey);
        if (node4.isAttribute()) {
            key.appendAttribute(node4.getName());
        } else {
            key.append(node4.getName(), true);
        }
        return key.toString();
    }

    @Override
    public NodeAddData prepareAdd(ConfigurationNode root2, String key) {
        DefaultConfigurationKey.KeyIterator it = new DefaultConfigurationKey(this, key).iterator();
        if (!it.hasNext()) {
            throw new IllegalArgumentException("Key for add operation must be defined!");
        }
        NodeAddData result2 = new NodeAddData();
        result2.setParent(this.findLastPathNode(it, root2));
        while (it.hasNext()) {
            if (!it.isPropertyKey()) {
                throw new IllegalArgumentException("Invalid key for add operation: " + key + " (Attribute key in the middle.)");
            }
            result2.addPathNode(it.currentKey());
            it.next();
        }
        result2.setNewNodeName(it.currentKey());
        result2.setAttribute(!it.isPropertyKey());
        return result2;
    }

    protected void findNodesForKey(DefaultConfigurationKey.KeyIterator keyPart, ConfigurationNode node4, Collection<ConfigurationNode> nodes2) {
        if (!keyPart.hasNext()) {
            nodes2.add(node4);
        } else {
            String key = keyPart.nextKey(false);
            if (keyPart.isPropertyKey()) {
                this.processSubNodes(keyPart, node4.getChildren(key), nodes2);
            }
            if (keyPart.isAttribute()) {
                this.processSubNodes(keyPart, node4.getAttributes(key), nodes2);
            }
        }
    }

    protected ConfigurationNode findLastPathNode(DefaultConfigurationKey.KeyIterator keyIt, ConfigurationNode node4) {
        String keyPart = keyIt.nextKey(false);
        if (keyIt.hasNext()) {
            int idx;
            if (!keyIt.isPropertyKey()) {
                throw new IllegalArgumentException("Invalid path for add operation: Attribute key in the middle!");
            }
            int n = idx = keyIt.hasIndex() ? keyIt.getIndex() : node4.getChildrenCount(keyPart) - 1;
            if (idx < 0 || idx >= node4.getChildrenCount(keyPart)) {
                return node4;
            }
            return this.findLastPathNode(keyIt, node4.getChildren(keyPart).get(idx));
        }
        return node4;
    }

    private void processSubNodes(DefaultConfigurationKey.KeyIterator keyPart, List<ConfigurationNode> subNodes, Collection<ConfigurationNode> nodes2) {
        if (keyPart.hasIndex()) {
            if (keyPart.getIndex() >= 0 && keyPart.getIndex() < subNodes.size()) {
                this.findNodesForKey((DefaultConfigurationKey.KeyIterator)keyPart.clone(), subNodes.get(keyPart.getIndex()), nodes2);
            }
        } else {
            for (ConfigurationNode node4 : subNodes) {
                this.findNodesForKey((DefaultConfigurationKey.KeyIterator)keyPart.clone(), node4, nodes2);
            }
        }
    }
}

