/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.ConfigurationNodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfigurationNode
implements ConfigurationNode,
Cloneable {
    private SubNodes children;
    private SubNodes attributes;
    private ConfigurationNode parent;
    private Object value;
    private Object reference;
    private String name;
    private boolean attribute;

    public DefaultConfigurationNode() {
        this(null);
    }

    public DefaultConfigurationNode(String name) {
        this(name, null);
    }

    public DefaultConfigurationNode(String name, Object value2) {
        this.setName(name);
        this.setValue(value2);
        this.initSubNodes();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.checkState();
        this.name = name;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object val) {
        this.value = val;
    }

    @Override
    public Object getReference() {
        return this.reference;
    }

    @Override
    public void setReference(Object reference) {
        this.reference = reference;
    }

    @Override
    public ConfigurationNode getParentNode() {
        return this.parent;
    }

    @Override
    public void setParentNode(ConfigurationNode parent2) {
        this.parent = parent2;
    }

    @Override
    public void addChild(ConfigurationNode child) {
        this.children.addNode(child);
        child.setAttribute(false);
        child.setParentNode(this);
    }

    @Override
    public List<ConfigurationNode> getChildren() {
        return this.children.getSubNodes();
    }

    @Override
    public int getChildrenCount() {
        return this.children.getSubNodes().size();
    }

    @Override
    public List<ConfigurationNode> getChildren(String name) {
        return this.children.getSubNodes(name);
    }

    @Override
    public int getChildrenCount(String name) {
        return this.children.getSubNodes(name).size();
    }

    @Override
    public ConfigurationNode getChild(int index2) {
        return this.children.getNode(index2);
    }

    @Override
    public boolean removeChild(ConfigurationNode child) {
        return this.children.removeNode(child);
    }

    @Override
    public boolean removeChild(String childName) {
        return this.children.removeNodes(childName);
    }

    @Override
    public void removeChildren() {
        this.children.clear();
    }

    @Override
    public boolean isAttribute() {
        return this.attribute;
    }

    @Override
    public void setAttribute(boolean f2) {
        this.checkState();
        this.attribute = f2;
    }

    @Override
    public void addAttribute(ConfigurationNode attr) {
        this.attributes.addNode(attr);
        attr.setAttribute(true);
        attr.setParentNode(this);
    }

    @Override
    public List<ConfigurationNode> getAttributes() {
        return this.attributes.getSubNodes();
    }

    @Override
    public int getAttributeCount() {
        return this.attributes.getSubNodes().size();
    }

    @Override
    public List<ConfigurationNode> getAttributes(String name) {
        return this.attributes.getSubNodes(name);
    }

    @Override
    public int getAttributeCount(String name) {
        return this.getAttributes(name).size();
    }

    @Override
    public boolean removeAttribute(ConfigurationNode node4) {
        return this.attributes.removeNode(node4);
    }

    @Override
    public boolean removeAttribute(String name) {
        return this.attributes.removeNodes(name);
    }

    @Override
    public ConfigurationNode getAttribute(int index2) {
        return this.attributes.getNode(index2);
    }

    @Override
    public void removeAttributes() {
        this.attributes.clear();
    }

    @Override
    public boolean isDefined() {
        return this.getValue() != null || this.getChildrenCount() > 0 || this.getAttributeCount() > 0;
    }

    @Override
    public void visit(ConfigurationNodeVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Visitor must not be null!");
        }
        if (!visitor.terminate()) {
            visitor.visitBeforeChildren(this);
            this.children.visit(visitor);
            this.attributes.visit(visitor);
            visitor.visitAfterChildren(this);
        }
    }

    @Override
    public Object clone() {
        try {
            DefaultConfigurationNode copy2 = (DefaultConfigurationNode)super.clone();
            copy2.initSubNodes();
            return copy2;
        }
        catch (CloneNotSupportedException cex) {
            throw new ConfigurationRuntimeException("Cannot clone " + this.getClass());
        }
    }

    protected void checkState() {
        if (this.getParentNode() != null) {
            throw new IllegalStateException("Node cannot be modified when added to a parent!");
        }
    }

    protected SubNodes createSubNodes(boolean attributes2) {
        return new SubNodes();
    }

    protected void removeReference() {
    }

    private void initSubNodes() {
        this.children = this.createSubNodes(false);
        this.attributes = this.createSubNodes(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SubNodes {
        private List<ConfigurationNode> nodes;
        private Map<String, List<ConfigurationNode>> namedNodes;

        protected SubNodes() {
        }

        public void addNode(ConfigurationNode node4) {
            if (node4 == null || node4.getName() == null) {
                throw new IllegalArgumentException("Node to add must have a defined name!");
            }
            node4.setParentNode(null);
            if (this.nodes == null) {
                this.nodes = new ArrayList<ConfigurationNode>();
                this.namedNodes = new HashMap<String, List<ConfigurationNode>>();
            }
            this.nodes.add(node4);
            List<ConfigurationNode> lst = this.namedNodes.get(node4.getName());
            if (lst == null) {
                lst = new LinkedList<ConfigurationNode>();
                this.namedNodes.put(node4.getName(), lst);
            }
            lst.add(node4);
        }

        public boolean removeNode(ConfigurationNode node4) {
            if (this.nodes != null && node4 != null && this.nodes.contains(node4)) {
                this.detachNode(node4);
                this.nodes.remove(node4);
                List<ConfigurationNode> lst = this.namedNodes.get(node4.getName());
                if (lst != null) {
                    lst.remove(node4);
                    if (lst.isEmpty()) {
                        this.namedNodes.remove(node4.getName());
                    }
                }
                return true;
            }
            return false;
        }

        public boolean removeNodes(String name) {
            List<ConfigurationNode> lst;
            if (this.nodes != null && name != null && (lst = this.namedNodes.remove(name)) != null) {
                this.detachNodes(lst);
                this.nodes.removeAll(lst);
                return true;
            }
            return false;
        }

        public void clear() {
            if (this.nodes != null) {
                this.detachNodes(this.nodes);
                this.nodes = null;
                this.namedNodes = null;
            }
        }

        public ConfigurationNode getNode(int index2) {
            if (this.nodes == null) {
                throw new IndexOutOfBoundsException("No sub nodes available!");
            }
            return this.nodes.get(index2);
        }

        public List<ConfigurationNode> getSubNodes() {
            if (this.nodes == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.nodes);
        }

        public List<ConfigurationNode> getSubNodes(String name) {
            if (name == null) {
                return this.getSubNodes();
            }
            List<ConfigurationNode> result2 = this.nodes == null ? null : this.namedNodes.get(name);
            if (result2 == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(result2);
        }

        public void visit(ConfigurationNodeVisitor visitor) {
            if (this.nodes != null) {
                Iterator<ConfigurationNode> it = this.nodes.iterator();
                while (it.hasNext() && !visitor.terminate()) {
                    it.next().visit(visitor);
                }
            }
        }

        protected void detachNode(ConfigurationNode subNode) {
            subNode.setParentNode(null);
            if (subNode instanceof DefaultConfigurationNode) {
                ((DefaultConfigurationNode)subNode).removeReference();
            }
        }

        protected void detachNodes(Collection<? extends ConfigurationNode> subNodes) {
            for (ConfigurationNode configurationNode : subNodes) {
                this.detachNode(configurationNode);
            }
        }
    }
}

