/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.interpol;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.interpol.ConstantLookup;
import org.apache.commons.configuration.interpol.EnvironmentLookup;
import org.apache.commons.lang.text.StrLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationInterpolator
extends StrLookup {
    public static final String PREFIX_SYSPROPERTIES = "sys";
    public static final String PREFIX_CONSTANTS = "const";
    public static final String PREFIX_ENVIRONMENT = "env";
    private static final char PREFIX_SEPARATOR = ':';
    private static Map<String, StrLookup> globalLookups = new HashMap<String, StrLookup>();
    private Map<String, StrLookup> localLookups;
    private StrLookup defaultLookup;
    private ConfigurationInterpolator parentInterpolator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationInterpolator() {
        Map<String, StrLookup> map2 = globalLookups;
        synchronized (map2) {
            this.localLookups = new HashMap<String, StrLookup>(globalLookups);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerGlobalLookup(String prefix, StrLookup lookup2) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix for lookup object must not be null!");
        }
        if (lookup2 == null) {
            throw new IllegalArgumentException("Lookup object must not be null!");
        }
        Map<String, StrLookup> map2 = globalLookups;
        synchronized (map2) {
            globalLookups.put(prefix, lookup2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deregisterGlobalLookup(String prefix) {
        Map<String, StrLookup> map2 = globalLookups;
        synchronized (map2) {
            return globalLookups.remove(prefix) != null;
        }
    }

    public void registerLookup(String prefix, StrLookup lookup2) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix for lookup object must not be null!");
        }
        if (lookup2 == null) {
            throw new IllegalArgumentException("Lookup object must not be null!");
        }
        this.localLookups.put(prefix, lookup2);
    }

    public boolean deregisterLookup(String prefix) {
        return this.localLookups.remove(prefix) != null;
    }

    public Set<String> prefixSet() {
        return this.localLookups.keySet();
    }

    public StrLookup getDefaultLookup() {
        return this.defaultLookup;
    }

    public void setDefaultLookup(StrLookup defaultLookup) {
        this.defaultLookup = defaultLookup;
    }

    @Override
    public String lookup(String var) {
        String value2;
        if (var == null) {
            return null;
        }
        int prefixPos = var.indexOf(58);
        if (prefixPos >= 0) {
            String prefix = var.substring(0, prefixPos);
            String name = var.substring(prefixPos + 1);
            String value3 = this.fetchLookupForPrefix(prefix).lookup(name);
            if (value3 == null && this.getParentInterpolator() != null) {
                value3 = this.getParentInterpolator().lookup(name);
            }
            if (value3 != null) {
                return value3;
            }
        }
        if ((value2 = this.fetchNoPrefixLookup().lookup(var)) == null && this.getParentInterpolator() != null) {
            value2 = this.getParentInterpolator().lookup(var);
        }
        return value2;
    }

    protected StrLookup fetchNoPrefixLookup() {
        return this.getDefaultLookup() != null ? this.getDefaultLookup() : StrLookup.noneLookup();
    }

    protected StrLookup fetchLookupForPrefix(String prefix) {
        StrLookup lookup2 = this.localLookups.get(prefix);
        if (lookup2 == null) {
            lookup2 = StrLookup.noneLookup();
        }
        return lookup2;
    }

    public void registerLocalLookups(ConfigurationInterpolator interpolator) {
        interpolator.localLookups.putAll(this.localLookups);
    }

    public void setParentInterpolator(ConfigurationInterpolator parentInterpolator) {
        this.parentInterpolator = parentInterpolator;
    }

    public ConfigurationInterpolator getParentInterpolator() {
        return this.parentInterpolator;
    }

    static {
        globalLookups.put(PREFIX_SYSPROPERTIES, StrLookup.systemPropertiesLookup());
        globalLookups.put(PREFIX_CONSTANTS, new ConstantLookup());
        globalLookups.put(PREFIX_ENVIRONMENT, new EnvironmentLookup());
    }
}

