/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.AbstractHierarchicalFileConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.configuration.resolver.DefaultEntityResolver;
import org.apache.commons.configuration.resolver.EntityRegistry;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConfiguration
extends AbstractHierarchicalFileConfiguration
implements EntityResolver,
EntityRegistry {
    private static final long serialVersionUID = 2453781111653383552L;
    private static final String DEFAULT_ROOT_NAME = "configuration";
    private static final String ATTR_SPACE = "xml:space";
    private static final String VALUE_PRESERVE = "preserve";
    private static final char ATTR_VALUE_DELIMITER = '|';
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private Document document;
    private String rootElementName;
    private String publicID;
    private String systemID;
    private DocumentBuilder documentBuilder;
    private boolean validating;
    private boolean schemaValidation;
    private boolean attributeSplittingDisabled;
    private EntityResolver entityResolver = new DefaultEntityResolver();

    public XMLConfiguration() {
        this.setLogger(LogFactory.getLog(XMLConfiguration.class));
    }

    public XMLConfiguration(HierarchicalConfiguration c) {
        super(c);
        XMLConfiguration.clearReferences(this.getRootNode());
        this.setRootElementName(this.getRootNode().getName());
        this.setLogger(LogFactory.getLog(XMLConfiguration.class));
    }

    public XMLConfiguration(String fileName) throws ConfigurationException {
        super(fileName);
        this.setLogger(LogFactory.getLog(XMLConfiguration.class));
    }

    public XMLConfiguration(File file) throws ConfigurationException {
        super(file);
        this.setLogger(LogFactory.getLog(XMLConfiguration.class));
    }

    public XMLConfiguration(URL url) throws ConfigurationException {
        super(url);
        this.setLogger(LogFactory.getLog(XMLConfiguration.class));
    }

    public String getRootElementName() {
        if (this.getDocument() == null) {
            return this.rootElementName == null ? DEFAULT_ROOT_NAME : this.rootElementName;
        }
        return this.getDocument().getDocumentElement().getNodeName();
    }

    public void setRootElementName(String name) {
        if (this.getDocument() != null) {
            throw new UnsupportedOperationException("The name of the root element cannot be changed when loaded from an XML document!");
        }
        this.rootElementName = name;
        this.getRootNode().setName(name);
    }

    public DocumentBuilder getDocumentBuilder() {
        return this.documentBuilder;
    }

    public void setDocumentBuilder(DocumentBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
    }

    public String getPublicID() {
        return this.publicID;
    }

    public void setPublicID(String publicID) {
        this.publicID = publicID;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public void setSystemID(String systemID) {
        this.systemID = systemID;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        if (!this.schemaValidation) {
            this.validating = validating;
        }
    }

    public boolean isSchemaValidation() {
        return this.schemaValidation;
    }

    public void setSchemaValidation(boolean schemaValidation) {
        this.schemaValidation = schemaValidation;
        if (schemaValidation) {
            this.validating = true;
        }
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public boolean isAttributeSplittingDisabled() {
        return this.attributeSplittingDisabled;
    }

    public void setAttributeSplittingDisabled(boolean attributeSplittingDisabled) {
        this.attributeSplittingDisabled = attributeSplittingDisabled;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public void clear() {
        super.clear();
        this.setRoot(new HierarchicalConfiguration.Node());
        this.document = null;
    }

    public void initProperties(Document document2, boolean elemRefs) {
        if (document2.getDoctype() != null) {
            this.setPublicID(document2.getDoctype().getPublicId());
            this.setSystemID(document2.getDoctype().getSystemId());
        }
        this.constructHierarchy(this.getRoot(), document2.getDocumentElement(), elemRefs, true);
        this.getRootNode().setName(document2.getDocumentElement().getNodeName());
        if (elemRefs) {
            this.getRoot().setReference(document2.getDocumentElement());
        }
    }

    private Map<String, Collection<String>> constructHierarchy(HierarchicalConfiguration.Node node4, Element element2, boolean elemRefs, boolean trim2) {
        boolean trimFlag = this.shouldTrim(element2, trim2);
        Map<String, Collection<String>> attributes2 = this.processAttributes(node4, element2, elemRefs);
        attributes2.put(ATTR_SPACE, Collections.singleton(String.valueOf(trimFlag)));
        StringBuilder buffer = new StringBuilder();
        NodeList list2 = element2.getChildNodes();
        for (int i = 0; i < list2.getLength(); ++i) {
            Node w3cNode = list2.item(i);
            if (w3cNode instanceof Element) {
                Element child = (Element)w3cNode;
                XMLNode childNode = new XMLNode(child.getTagName(), elemRefs ? child : null);
                Map<String, Collection<String>> attrmap = this.constructHierarchy(childNode, child, elemRefs, trimFlag);
                node4.addChild(childNode);
                Collection<String> attrSpace = attrmap.remove(ATTR_SPACE);
                Boolean childTrim = CollectionUtils.isEmpty(attrSpace) ? Boolean.FALSE : Boolean.valueOf(attrSpace.iterator().next());
                this.handleDelimiters(node4, childNode, childTrim, attrmap);
                continue;
            }
            if (!(w3cNode instanceof Text)) continue;
            Text data = (Text)w3cNode;
            buffer.append(data.getData());
        }
        String text2 = XMLConfiguration.determineValue(node4, buffer.toString(), trimFlag);
        if (text2.length() > 0 || !node4.hasChildren() && node4 != this.getRoot()) {
            node4.setValue(text2);
        }
        return attributes2;
    }

    private static String determineValue(ConfigurationNode node4, String content, boolean trimFlag) {
        boolean shouldTrim = trimFlag || StringUtils.isBlank(content) && node4.getChildrenCount() > 0;
        return shouldTrim ? content.trim() : content;
    }

    private Map<String, Collection<String>> processAttributes(HierarchicalConfiguration.Node node4, Element element2, boolean elemRefs) {
        NamedNodeMap attributes2 = element2.getAttributes();
        HashMap<String, Collection<String>> attrmap = new HashMap<String, Collection<String>>();
        for (int i = 0; i < attributes2.getLength(); ++i) {
            Node w3cNode = attributes2.item(i);
            if (!(w3cNode instanceof Attr)) continue;
            Attr attr = (Attr)w3cNode;
            List<String> values2 = this.isAttributeSplittingDisabled() ? Collections.singletonList(attr.getValue()) : PropertyConverter.split(attr.getValue(), this.isDelimiterParsingDisabled() ? (char)'|' : (char)this.getListDelimiter());
            this.appendAttributes(node4, element2, elemRefs, attr.getName(), values2);
            attrmap.put(attr.getName(), values2);
        }
        return attrmap;
    }

    private void appendAttributes(HierarchicalConfiguration.Node node4, Element element2, boolean elemRefs, String attr, Collection<String> values2) {
        for (String value2 : values2) {
            XMLNode child = new XMLNode(attr, elemRefs ? element2 : null);
            ((DefaultConfigurationNode)child).setValue(value2);
            node4.addAttribute(child);
        }
    }

    private void handleDelimiters(HierarchicalConfiguration.Node parent2, HierarchicalConfiguration.Node child, boolean trim2, Map<String, Collection<String>> attrmap) {
        if (child.getValue() != null) {
            List<String> values2;
            if (this.isDelimiterParsingDisabled()) {
                ArrayList<String> values22 = new ArrayList<String>();
                values22.add(child.getValue().toString());
            } else {
                values2 = PropertyConverter.split(child.getValue().toString(), this.getListDelimiter(), trim2);
            }
            if (values2.size() > 1) {
                Iterator<String> it = values2.iterator();
                HierarchicalConfiguration.Node c = this.createNode(child.getName());
                c.setValue(it.next());
                for (ConfigurationNode configurationNode : child.getAttributes()) {
                    configurationNode.setReference(null);
                    c.addAttribute(configurationNode);
                }
                parent2.remove(child);
                parent2.addChild(c);
                while (it.hasNext()) {
                    c = new XMLNode(child.getName(), null);
                    c.setValue(it.next());
                    for (Map.Entry entry2 : attrmap.entrySet()) {
                        this.appendAttributes(c, null, false, (String)entry2.getKey(), (Collection)entry2.getValue());
                    }
                    parent2.addChild(c);
                }
            } else if (values2.size() == 1) {
                child.setValue(values2.get(0));
            }
        }
    }

    private boolean shouldTrim(Element element2, boolean currentTrim) {
        Attr attr = element2.getAttributeNode(ATTR_SPACE);
        if (attr == null) {
            return currentTrim;
        }
        return !VALUE_PRESERVE.equals(attr.getValue());
    }

    protected DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        if (this.getDocumentBuilder() != null) {
            return this.getDocumentBuilder();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        if (this.isValidating()) {
            factory.setValidating(true);
            if (this.isSchemaValidation()) {
                factory.setNamespaceAware(true);
                factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            }
        }
        DocumentBuilder result2 = factory.newDocumentBuilder();
        result2.setEntityResolver(this.entityResolver);
        if (this.isValidating()) {
            result2.setErrorHandler(new DefaultHandler(){

                public void error(SAXParseException ex) throws SAXException {
                    throw ex;
                }
            });
        }
        return result2;
    }

    protected Document createDocument() throws ConfigurationException {
        try {
            Object builder;
            if (this.document == null) {
                builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document newDocument = ((DocumentBuilder)builder).newDocument();
                Element rootElem = newDocument.createElement(this.getRootElementName());
                newDocument.appendChild(rootElem);
                this.document = newDocument;
            }
            builder = new XMLBuilderVisitor(this.document, this.isDelimiterParsingDisabled() ? (char)'\u0000' : this.getListDelimiter(), this.isAttributeSplittingDisabled());
            ((XMLBuilderVisitor)builder).processDocument(this.getRoot());
            this.initRootElementText(this.document, this.getRootNode().getValue());
            return this.document;
        }
        catch (DOMException domEx) {
            throw new ConfigurationException(domEx);
        }
        catch (ParserConfigurationException pex) {
            throw new ConfigurationException(pex);
        }
    }

    private void initRootElementText(Document doc, Object value2) {
        Element elem2 = doc.getDocumentElement();
        NodeList children2 = elem2.getChildNodes();
        for (int i = 0; i < children2.getLength(); ++i) {
            Node nd = children2.item(i);
            if (nd.getNodeType() != 3) continue;
            elem2.removeChild(nd);
        }
        if (value2 != null) {
            elem2.appendChild(doc.createTextNode(String.valueOf(value2)));
        }
    }

    @Override
    protected HierarchicalConfiguration.Node createNode(String name) {
        return new XMLNode(name, null);
    }

    @Override
    public void load(InputStream in2) throws ConfigurationException {
        this.load(new InputSource(in2));
    }

    @Override
    public void load(Reader in2) throws ConfigurationException {
        this.load(new InputSource(in2));
    }

    private void load(InputSource source2) throws ConfigurationException {
        try {
            URL sourceURL = this.getDelegate().getURL();
            if (sourceURL != null) {
                source2.setSystemId(sourceURL.toString());
            }
            DocumentBuilder builder = this.createDocumentBuilder();
            Document newDocument = builder.parse(source2);
            Document oldDocument = this.document;
            this.document = null;
            this.initProperties(newDocument, oldDocument == null);
            this.document = oldDocument == null ? newDocument : oldDocument;
        }
        catch (SAXParseException spe) {
            throw new ConfigurationException("Error parsing " + source2.getSystemId(), spe);
        }
        catch (Exception e) {
            this.getLogger().debug("Unable to load the configuraton", e);
            throw new ConfigurationException("Unable to load the configuration", e);
        }
    }

    @Override
    public void save(Writer writer2) throws ConfigurationException {
        try {
            Transformer transformer = this.createTransformer();
            DOMSource source2 = new DOMSource(this.createDocument());
            StreamResult result2 = new StreamResult(writer2);
            transformer.transform(source2, result2);
        }
        catch (TransformerException e) {
            throw new ConfigurationException("Unable to save the configuration", e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new ConfigurationException("Unable to save the configuration", e);
        }
    }

    public void validate() throws ConfigurationException {
        try {
            Transformer transformer = this.createTransformer();
            DOMSource source2 = new DOMSource(this.createDocument());
            StringWriter writer2 = new StringWriter();
            StreamResult result2 = new StreamResult(writer2);
            transformer.transform(source2, result2);
            StringReader reader = new StringReader(writer2.getBuffer().toString());
            DocumentBuilder builder = this.createDocumentBuilder();
            builder.parse(new InputSource(reader));
        }
        catch (SAXException e) {
            throw new ConfigurationException("Validation failed", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Validation failed", e);
        }
        catch (TransformerException e) {
            throw new ConfigurationException("Validation failed", e);
        }
        catch (ParserConfigurationException pce) {
            throw new ConfigurationException("Validation failed", pce);
        }
    }

    protected Transformer createTransformer() throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        if (this.getEncoding() != null) {
            transformer.setOutputProperty("encoding", this.getEncoding());
        }
        if (this.getPublicID() != null) {
            transformer.setOutputProperty("doctype-public", this.getPublicID());
        }
        if (this.getSystemID() != null) {
            transformer.setOutputProperty("doctype-system", this.getSystemID());
        }
        return transformer;
    }

    @Override
    public Object clone() {
        XMLConfiguration copy2 = (XMLConfiguration)super.clone();
        copy2.document = null;
        copy2.setDelegate(copy2.createDelegate());
        XMLConfiguration.clearReferences(copy2.getRootNode());
        return copy2;
    }

    @Override
    protected AbstractHierarchicalFileConfiguration.FileConfigurationDelegate createDelegate() {
        return new XMLFileConfigurationDelegate();
    }

    @Override
    public void addNodes(String key, Collection<? extends ConfigurationNode> nodes2) {
        if (nodes2 != null && !nodes2.isEmpty()) {
            ArrayList<XMLNode> xmlNodes = new ArrayList<XMLNode>(nodes2.size());
            for (ConfigurationNode configurationNode : nodes2) {
                xmlNodes.add(this.convertToXMLNode(configurationNode));
            }
            super.addNodes(key, xmlNodes);
        } else {
            super.addNodes(key, nodes2);
        }
    }

    private XMLNode convertToXMLNode(ConfigurationNode node4) {
        if (node4 instanceof XMLNode) {
            return (XMLNode)node4;
        }
        XMLNode nd = (XMLNode)this.createNode(node4.getName());
        nd.setValue(node4.getValue());
        nd.setAttribute(node4.isAttribute());
        for (ConfigurationNode child : node4.getChildren()) {
            nd.addChild(this.convertToXMLNode(child));
        }
        for (ConfigurationNode attr : node4.getAttributes()) {
            nd.addAttribute(this.convertToXMLNode(attr));
        }
        return nd;
    }

    @Override
    public void registerEntityId(String publicId, URL entityURL) {
        if (this.entityResolver instanceof EntityRegistry) {
            ((EntityRegistry)((Object)this.entityResolver)).registerEntityId(publicId, entityURL);
        }
    }

    @Override
    @Deprecated
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        try {
            return this.entityResolver.resolveEntity(publicId, systemId);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public Map<String, URL> getRegisteredEntities() {
        if (this.entityResolver instanceof EntityRegistry) {
            return ((EntityRegistry)((Object)this.entityResolver)).getRegisteredEntities();
        }
        return new HashMap<String, URL>();
    }

    private class XMLFileConfigurationDelegate
    extends AbstractHierarchicalFileConfiguration.FileConfigurationDelegate {
        private XMLFileConfigurationDelegate() {
        }

        public void load(InputStream in2) throws ConfigurationException {
            XMLConfiguration.this.load(in2);
        }
    }

    static class XMLBuilderVisitor
    extends HierarchicalConfiguration.BuilderVisitor {
        private Document document;
        private final char listDelimiter;
        private boolean isAttributeSplittingDisabled;

        public XMLBuilderVisitor(Document doc, char listDelimiter, boolean isAttributeSplittingDisabled) {
            this.document = doc;
            this.listDelimiter = listDelimiter;
            this.isAttributeSplittingDisabled = isAttributeSplittingDisabled;
        }

        public void processDocument(HierarchicalConfiguration.Node rootNode) {
            rootNode.visit(this, null);
        }

        protected Object insert(HierarchicalConfiguration.Node newNode, HierarchicalConfiguration.Node parent2, HierarchicalConfiguration.Node sibling1, HierarchicalConfiguration.Node sibling2) {
            if (newNode.isAttribute()) {
                XMLBuilderVisitor.updateAttribute(parent2, this.getElement(parent2), newNode.getName(), this.listDelimiter, this.isAttributeSplittingDisabled);
                return null;
            }
            Element elem2 = this.document.createElement(newNode.getName());
            if (newNode.getValue() != null) {
                String txt = newNode.getValue().toString();
                if (this.listDelimiter != '\u0000') {
                    txt = PropertyConverter.escapeListDelimiter(txt, this.listDelimiter);
                }
                elem2.appendChild(this.document.createTextNode(txt));
            }
            if (sibling2 == null) {
                this.getElement(parent2).appendChild(elem2);
            } else if (sibling1 != null) {
                this.getElement(parent2).insertBefore(elem2, this.getElement(sibling1).getNextSibling());
            } else {
                this.getElement(parent2).insertBefore(elem2, this.getElement(parent2).getFirstChild());
            }
            return elem2;
        }

        private static void updateAttribute(HierarchicalConfiguration.Node node4, Element elem2, String name, char listDelimiter, boolean isAttributeSplittingDisabled) {
            if (node4 != null && elem2 != null) {
                boolean hasAttribute = false;
                List<ConfigurationNode> attrs = node4.getAttributes(name);
                StringBuilder buf = new StringBuilder();
                char delimiter = listDelimiter != '\u0000' ? listDelimiter : (char)'|';
                for (ConfigurationNode attr : attrs) {
                    if (attr.getValue() != null) {
                        hasAttribute = true;
                        if (buf.length() > 0) {
                            buf.append(delimiter);
                        }
                        String value2 = isAttributeSplittingDisabled ? attr.getValue().toString() : PropertyConverter.escapeDelimiters(attr.getValue().toString(), delimiter);
                        buf.append(value2);
                    }
                    attr.setReference(elem2);
                }
                if (!hasAttribute) {
                    elem2.removeAttribute(name);
                } else {
                    elem2.setAttribute(name, buf.toString());
                }
            }
        }

        static void updateAttribute(HierarchicalConfiguration.Node node4, String name, char listDelimiter, boolean isAttributeSplittingDisabled) {
            if (node4 != null) {
                XMLBuilderVisitor.updateAttribute(node4, (Element)node4.getReference(), name, listDelimiter, isAttributeSplittingDisabled);
            }
        }

        private Element getElement(HierarchicalConfiguration.Node node4) {
            return node4.getName() != null && node4.getReference() != null ? (Element)node4.getReference() : this.document.getDocumentElement();
        }
    }

    class XMLNode
    extends HierarchicalConfiguration.Node {
        private static final long serialVersionUID = -4133988932174596562L;

        public XMLNode(String name, Element elem2) {
            super(name);
            this.setReference(elem2);
        }

        public void setValue(Object value2) {
            super.setValue(value2);
            if (this.getReference() != null && XMLConfiguration.this.document != null) {
                if (this.isAttribute()) {
                    this.updateAttribute();
                } else {
                    this.updateElement(value2);
                }
            }
        }

        protected void removeReference() {
            if (this.getReference() != null) {
                Element element2 = (Element)this.getReference();
                if (this.isAttribute()) {
                    this.updateAttribute();
                } else {
                    Node parentElem = element2.getParentNode();
                    if (parentElem != null) {
                        parentElem.removeChild(element2);
                    }
                }
            }
        }

        private void updateElement(Object value2) {
            Text txtNode = this.findTextNodeForUpdate();
            if (value2 == null) {
                if (txtNode != null) {
                    ((Element)this.getReference()).removeChild(txtNode);
                }
            } else if (txtNode == null) {
                String newValue = XMLConfiguration.this.isDelimiterParsingDisabled() ? value2.toString() : PropertyConverter.escapeDelimiters(value2.toString(), XMLConfiguration.this.getListDelimiter());
                txtNode = XMLConfiguration.this.document.createTextNode(newValue);
                if (((Element)this.getReference()).getFirstChild() != null) {
                    ((Element)this.getReference()).insertBefore(txtNode, ((Element)this.getReference()).getFirstChild());
                } else {
                    ((Element)this.getReference()).appendChild(txtNode);
                }
            } else {
                String newValue = XMLConfiguration.this.isDelimiterParsingDisabled() ? value2.toString() : PropertyConverter.escapeDelimiters(value2.toString(), XMLConfiguration.this.getListDelimiter());
                txtNode.setNodeValue(newValue);
            }
        }

        private void updateAttribute() {
            XMLBuilderVisitor.updateAttribute(this.getParent(), this.getName(), XMLConfiguration.this.getListDelimiter(), XMLConfiguration.this.isAttributeSplittingDisabled());
        }

        private Text findTextNodeForUpdate() {
            Text result2 = null;
            Element elem2 = (Element)this.getReference();
            NodeList children2 = elem2.getChildNodes();
            ArrayList<Node> textNodes = new ArrayList<Node>();
            for (int i = 0; i < children2.getLength(); ++i) {
                Node nd = children2.item(i);
                if (!(nd instanceof Text)) continue;
                if (result2 == null) {
                    result2 = (Text)nd;
                    continue;
                }
                textNodes.add(nd);
            }
            if (result2 instanceof CDATASection) {
                textNodes.add(result2);
                result2 = null;
            }
            for (Node tn : textNodes) {
                elem2.removeChild(tn);
            }
            return result2;
        }
    }
}

