/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNDIConfiguration
extends AbstractConfiguration {
    private String prefix;
    private Context context;
    private Context baseContext;
    private Set<String> clearedProperties = new HashSet<String>();

    public JNDIConfiguration() throws NamingException {
        this((String)null);
    }

    public JNDIConfiguration(String prefix) throws NamingException {
        this(new InitialContext(), prefix);
    }

    public JNDIConfiguration(Context context) {
        this(context, null);
    }

    public JNDIConfiguration(Context context, String prefix) {
        this.context = context;
        this.prefix = prefix;
        this.setLogger(LogFactory.getLog(this.getClass()));
        this.addErrorLogListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recursiveGetKeys(Set<String> keys2, Context context, String prefix, Set<Context> processedCtx) throws NamingException {
        processedCtx.add(context);
        NamingEnumeration<NameClassPair> elements2 = null;
        try {
            elements2 = context.list("");
            while (elements2.hasMore()) {
                NameClassPair nameClassPair = elements2.next();
                String name = nameClassPair.getName();
                Object object = context.lookup(name);
                StringBuilder key = new StringBuilder();
                key.append(prefix);
                if (key.length() > 0) {
                    key.append(".");
                }
                key.append(name);
                if (object instanceof Context) {
                    Context subcontext = (Context)object;
                    if (processedCtx.contains(subcontext)) continue;
                    this.recursiveGetKeys(keys2, subcontext, key.toString(), processedCtx);
                    continue;
                }
                keys2.add(key.toString());
            }
        }
        finally {
            if (elements2 != null) {
                elements2.close();
            }
        }
    }

    @Override
    public Iterator<String> getKeys() {
        return this.getKeys("");
    }

    @Override
    public Iterator<String> getKeys(String prefix) {
        String[] splitPath = StringUtils.split(prefix, ".");
        List<String> path2 = Arrays.asList(splitPath);
        try {
            Context context = this.getContext(path2, this.getBaseContext());
            HashSet<String> keys2 = new HashSet<String>();
            if (context != null) {
                this.recursiveGetKeys(keys2, context, prefix, new HashSet<Context>());
            } else if (this.containsKey(prefix)) {
                keys2.add(prefix);
            }
            return keys2.iterator();
        }
        catch (NameNotFoundException e) {
            return new ArrayList().iterator();
        }
        catch (NamingException e) {
            this.fireError(5, null, null, e);
            return new ArrayList().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context getContext(List<String> path2, Context context) throws NamingException {
        if (path2 == null || path2.isEmpty()) {
            return context;
        }
        String key = path2.get(0);
        NamingEnumeration<NameClassPair> elements2 = null;
        try {
            elements2 = context.list("");
            while (elements2.hasMore()) {
                NameClassPair nameClassPair = elements2.next();
                String name = nameClassPair.getName();
                Object object = context.lookup(name);
                if (!(object instanceof Context) || !name.equals(key)) continue;
                Context subcontext = (Context)object;
                Context context2 = this.getContext(path2.subList(1, path2.size()), subcontext);
                return context2;
            }
        }
        finally {
            if (elements2 != null) {
                elements2.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        boolean bl;
        block6: {
            NamingEnumeration<NameClassPair> enumeration = null;
            try {
                enumeration = this.getBaseContext().list("");
                boolean bl2 = bl = !enumeration.hasMore();
                if (enumeration == null) break block6;
            }
            catch (Throwable throwable2) {
                try {
                    if (enumeration != null) {
                        enumeration.close();
                    }
                    throw throwable2;
                }
                catch (NamingException e) {
                    this.fireError(5, null, null, e);
                    return true;
                }
            }
            enumeration.close();
        }
        return bl;
    }

    @Override
    public void setProperty(String key, Object value2) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    @Override
    public void clearProperty(String key) {
        this.clearedProperties.add(key);
    }

    @Override
    public boolean containsKey(String key) {
        if (this.clearedProperties.contains(key)) {
            return false;
        }
        key = key.replaceAll("\\.", "/");
        try {
            this.getBaseContext().lookup(key);
            return true;
        }
        catch (NameNotFoundException e) {
            return false;
        }
        catch (NamingException e) {
            this.fireError(5, key, null, e);
            return false;
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.baseContext = null;
    }

    @Override
    public Object getProperty(String key) {
        if (this.clearedProperties.contains(key)) {
            return null;
        }
        try {
            key = key.replaceAll("\\.", "/");
            return this.getBaseContext().lookup(key);
        }
        catch (NameNotFoundException e) {
            return null;
        }
        catch (NotContextException nctxex) {
            return null;
        }
        catch (NamingException e) {
            this.fireError(5, key, null, e);
            return null;
        }
    }

    @Override
    protected void addPropertyDirect(String key, Object obj) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public Context getBaseContext() throws NamingException {
        if (this.baseContext == null) {
            this.baseContext = (Context)this.getContext().lookup(this.prefix == null ? "" : this.prefix);
        }
        return this.baseContext;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.clearedProperties.clear();
        this.context = context;
    }
}

