/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.configuration.AbstractFileConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class INIConfiguration
extends AbstractFileConfiguration {
    protected static final String COMMENT_CHARS = "#;";
    protected static final String SEPARATOR_CHARS = "=:";

    public INIConfiguration() {
    }

    public INIConfiguration(String filename) throws ConfigurationException {
        super(filename);
    }

    public INIConfiguration(File file) throws ConfigurationException {
        super(file);
    }

    public INIConfiguration(URL url) throws ConfigurationException {
        super(url);
    }

    @Override
    public void save(Writer writer2) throws ConfigurationException {
        PrintWriter out = new PrintWriter(writer2);
        for (String section : this.getSections()) {
            out.print("[");
            out.print(section);
            out.print("]");
            out.println();
            Configuration subset = this.subset(section);
            Iterator<String> keys2 = subset.getKeys();
            while (keys2.hasNext()) {
                String key = keys2.next();
                Object value22 = subset.getProperty(key);
                if (value22 instanceof Collection) {
                    for (Object value22 : (Collection)value22) {
                        out.print(key);
                        out.print(" = ");
                        out.print(this.formatValue(value22.toString()));
                        out.println();
                    }
                    continue;
                }
                out.print(key);
                out.print(" = ");
                out.print(this.formatValue(value22.toString()));
                out.println();
            }
            out.println();
        }
        out.flush();
    }

    @Override
    public void load(Reader reader) throws ConfigurationException {
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            String line2 = bufferedReader.readLine();
            String section = "";
            while (line2 != null) {
                if (!this.isCommentLine(line2 = line2.trim())) {
                    if (this.isSectionLine(line2)) {
                        section = line2.substring(1, line2.length() - 1) + ".";
                    } else {
                        String key = "";
                        String value2 = "";
                        int index2 = line2.indexOf("=");
                        if (index2 >= 0) {
                            key = section + line2.substring(0, index2);
                            value2 = this.parseValue(line2.substring(index2 + 1));
                        } else {
                            index2 = line2.indexOf(":");
                            if (index2 >= 0) {
                                key = section + line2.substring(0, index2);
                                value2 = this.parseValue(line2.substring(index2 + 1));
                            } else {
                                key = section + line2;
                            }
                        }
                        this.addProperty(key.trim(), value2);
                    }
                }
                line2 = bufferedReader.readLine();
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to load the configuration", e);
        }
    }

    private String parseValue(String value2) {
        boolean quoted2 = (value2 = value2.trim()).startsWith("\"") || value2.startsWith("'");
        boolean stop = false;
        boolean escape2 = false;
        char quote = quoted2 ? value2.charAt(0) : (char)'\u0000';
        StringBuilder result2 = new StringBuilder();
        for (int i = quoted2 ? 1 : 0; i < value2.length() && !stop; ++i) {
            char c = value2.charAt(i);
            if (quoted2) {
                if ('\\' == c && !escape2) {
                    escape2 = true;
                    continue;
                }
                if (!escape2 && quote == c) {
                    stop = true;
                    continue;
                }
                if (escape2 && quote == c) {
                    escape2 = false;
                    result2.append(c);
                    continue;
                }
                if (escape2) {
                    escape2 = false;
                    result2.append('\\');
                }
                result2.append(c);
                continue;
            }
            if (COMMENT_CHARS.indexOf(c) == -1) {
                result2.append(c);
                continue;
            }
            stop = true;
        }
        String v = result2.toString();
        if (!quoted2) {
            v = v.trim();
        }
        return v;
    }

    private String formatValue(String value2) {
        boolean quoted2 = false;
        for (int i = 0; i < COMMENT_CHARS.length() && !quoted2; ++i) {
            char c = COMMENT_CHARS.charAt(i);
            if (value2.indexOf(c) == -1) continue;
            quoted2 = true;
        }
        if (quoted2) {
            return '\"' + value2.replaceAll("\"", "\\\\\\\"") + '\"';
        }
        return value2;
    }

    protected boolean isCommentLine(String line2) {
        if (line2 == null) {
            return false;
        }
        return line2.length() < 1 || COMMENT_CHARS.indexOf(line2.charAt(0)) >= 0;
    }

    protected boolean isSectionLine(String line2) {
        if (line2 == null) {
            return false;
        }
        return line2.startsWith("[") && line2.endsWith("]");
    }

    public Set<String> getSections() {
        TreeSet<String> sections = new TreeSet<String>();
        Iterator<String> keys2 = this.getKeys();
        while (keys2.hasNext()) {
            String key = keys2.next();
            int index2 = key.indexOf(".");
            if (index2 < 0) continue;
            sections.add(key.substring(0, index2));
        }
        return sections;
    }
}

