/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.AbstractHierarchicalFileConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.ViewNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalINIConfiguration
extends AbstractHierarchicalFileConfiguration {
    protected static final String COMMENT_CHARS = "#;";
    protected static final String SEPARATOR_CHARS = "=:";
    private static final long serialVersionUID = 2548006161386850670L;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String QUOTE_CHARACTERS = "\"'";
    private static final String LINE_CONT = "\\";

    public HierarchicalINIConfiguration() {
    }

    public HierarchicalINIConfiguration(String filename) throws ConfigurationException {
        super(filename);
    }

    public HierarchicalINIConfiguration(File file) throws ConfigurationException {
        super(file);
    }

    public HierarchicalINIConfiguration(URL url) throws ConfigurationException {
        super(url);
    }

    @Override
    public void save(Writer writer2) throws ConfigurationException {
        PrintWriter out = new PrintWriter(writer2);
        for (String section : this.getSections()) {
            SubnodeConfiguration subset;
            if (section != null) {
                out.print("[");
                out.print(section);
                out.print("]");
                out.println();
                subset = this.createSubnodeConfiguration(this.getSectionNode(section));
            } else {
                subset = this.getSection(null);
            }
            Iterator<String> keys2 = subset.getKeys();
            while (keys2.hasNext()) {
                String key = keys2.next();
                Object value22 = subset.getProperty(key);
                if (value22 instanceof Collection) {
                    for (Object value22 : (Collection)value22) {
                        out.print(key);
                        out.print(" = ");
                        out.print(this.formatValue(value22.toString()));
                        out.println();
                    }
                    continue;
                }
                out.print(key);
                out.print(" = ");
                out.print(this.formatValue(value22.toString()));
                out.println();
            }
            out.println();
        }
        out.flush();
    }

    @Override
    public void load(Reader reader) throws ConfigurationException {
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            ConfigurationNode sectionNode = this.getRootNode();
            String line2 = bufferedReader.readLine();
            while (line2 != null) {
                if (!this.isCommentLine(line2 = line2.trim())) {
                    if (this.isSectionLine(line2)) {
                        String section = line2.substring(1, line2.length() - 1);
                        sectionNode = this.getSectionNode(section);
                    } else {
                        String key = "";
                        String value2 = "";
                        int index2 = HierarchicalINIConfiguration.findSeparator(line2);
                        if (index2 >= 0) {
                            key = line2.substring(0, index2);
                            value2 = HierarchicalINIConfiguration.parseValue(line2.substring(index2 + 1), bufferedReader);
                        } else {
                            key = line2;
                        }
                        key = key.trim();
                        if (key.length() < 1) {
                            key = " ";
                        }
                        this.createValueNodes(sectionNode, key, value2);
                    }
                }
                line2 = bufferedReader.readLine();
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to load the configuration", e);
        }
    }

    private void createValueNodes(ConfigurationNode sectionNode, String key, String value2) {
        Collection<String> values2 = this.isDelimiterParsingDisabled() ? Collections.singleton(value2) : PropertyConverter.split(value2, this.getListDelimiter(), false);
        for (String v : values2) {
            HierarchicalConfiguration.Node node4 = this.createNode(key);
            node4.setValue(v);
            sectionNode.addChild(node4);
        }
    }

    private static String parseValue(String val, BufferedReader reader) throws IOException {
        boolean lineContinues;
        StringBuilder propertyValue = new StringBuilder();
        String value2 = val.trim();
        do {
            int i;
            boolean quoted2 = value2.startsWith("\"") || value2.startsWith("'");
            boolean stop = false;
            boolean escape2 = false;
            char quote = quoted2 ? value2.charAt(0) : (char)'\u0000';
            StringBuilder result2 = new StringBuilder();
            char lastChar = '\u0000';
            for (i = quoted2 ? 1 : 0; i < value2.length() && !stop; ++i) {
                char c = value2.charAt(i);
                if (quoted2) {
                    if ('\\' == c && !escape2) {
                        escape2 = true;
                    } else if (!escape2 && quote == c) {
                        stop = true;
                    } else if (escape2 && quote == c) {
                        escape2 = false;
                        result2.append(c);
                    } else {
                        if (escape2) {
                            escape2 = false;
                            result2.append('\\');
                        }
                        result2.append(c);
                    }
                } else if (HierarchicalINIConfiguration.isCommentChar(c) && Character.isWhitespace(lastChar)) {
                    stop = true;
                } else {
                    result2.append(c);
                }
                lastChar = c;
            }
            String v = result2.toString();
            if (!quoted2) {
                lineContinues = HierarchicalINIConfiguration.lineContinues(v = v.trim());
                if (lineContinues) {
                    v = v.substring(0, v.length() - 1).trim();
                }
            } else {
                lineContinues = HierarchicalINIConfiguration.lineContinues(value2, i);
            }
            propertyValue.append(v);
            if (!lineContinues) continue;
            propertyValue.append(LINE_SEPARATOR);
            value2 = reader.readLine();
        } while (lineContinues && value2 != null);
        return propertyValue.toString();
    }

    private static boolean lineContinues(String line2) {
        String s2 = line2.trim();
        return s2.equals(LINE_CONT) || s2.length() > 2 && s2.endsWith(LINE_CONT) && Character.isWhitespace(s2.charAt(s2.length() - 2));
    }

    private static boolean lineContinues(String line2, int pos) {
        String s2;
        if (pos >= line2.length()) {
            s2 = line2;
        } else {
            int end;
            for (end = pos; end < line2.length() && !HierarchicalINIConfiguration.isCommentChar(line2.charAt(end)); ++end) {
            }
            s2 = line2.substring(pos, end);
        }
        return HierarchicalINIConfiguration.lineContinues(s2);
    }

    private static boolean isCommentChar(char c) {
        return COMMENT_CHARS.indexOf(c) >= 0;
    }

    private static int findSeparator(String line2) {
        int index2 = HierarchicalINIConfiguration.findSeparatorBeforeQuote(line2, HierarchicalINIConfiguration.findFirstOccurrence(line2, QUOTE_CHARACTERS));
        if (index2 < 0) {
            index2 = HierarchicalINIConfiguration.findFirstOccurrence(line2, SEPARATOR_CHARS);
        }
        return index2;
    }

    private static int findFirstOccurrence(String line2, String separators) {
        int index2 = -1;
        for (int i = 0; i < separators.length(); ++i) {
            char sep = separators.charAt(i);
            int pos = line2.indexOf(sep);
            if (pos < 0 || index2 >= 0 && pos >= index2) continue;
            index2 = pos;
        }
        return index2;
    }

    private static int findSeparatorBeforeQuote(String line2, int quoteIndex) {
        int index2;
        for (index2 = quoteIndex - 1; index2 >= 0 && Character.isWhitespace(line2.charAt(index2)); --index2) {
        }
        if (index2 >= 0 && SEPARATOR_CHARS.indexOf(line2.charAt(index2)) < 0) {
            index2 = -1;
        }
        return index2;
    }

    private String formatValue(String value2) {
        boolean quoted2 = false;
        for (int i = 0; i < COMMENT_CHARS.length() && !quoted2; ++i) {
            char c = COMMENT_CHARS.charAt(i);
            if (value2.indexOf(c) == -1) continue;
            quoted2 = true;
        }
        if (quoted2) {
            return '\"' + value2.replaceAll("\"", "\\\\\\\"") + '\"';
        }
        return value2;
    }

    protected boolean isCommentLine(String line2) {
        if (line2 == null) {
            return false;
        }
        return line2.length() < 1 || COMMENT_CHARS.indexOf(line2.charAt(0)) >= 0;
    }

    protected boolean isSectionLine(String line2) {
        if (line2 == null) {
            return false;
        }
        return line2.startsWith("[") && line2.endsWith("]");
    }

    public Set<String> getSections() {
        LinkedHashSet<String> sections = new LinkedHashSet<String>();
        boolean globalSection = false;
        boolean inSection = false;
        for (ConfigurationNode node4 : this.getRootNode().getChildren()) {
            if (HierarchicalINIConfiguration.isSectionNode(node4)) {
                inSection = true;
                sections.add(node4.getName());
                continue;
            }
            if (inSection || globalSection) continue;
            globalSection = true;
            sections.add(null);
        }
        return sections;
    }

    public SubnodeConfiguration getSection(String name) {
        if (name == null) {
            return this.getGlobalSection();
        }
        try {
            return this.configurationAt(name);
        }
        catch (IllegalArgumentException iex) {
            return new SubnodeConfiguration(this, this.getSectionNode(name));
        }
    }

    private ConfigurationNode getSectionNode(String sectionName) {
        List<ConfigurationNode> nodes2 = this.getRootNode().getChildren(sectionName);
        if (!nodes2.isEmpty()) {
            return nodes2.get(0);
        }
        HierarchicalConfiguration.Node node4 = this.createNode(sectionName);
        HierarchicalINIConfiguration.markSectionNode(node4);
        this.getRootNode().addChild(node4);
        return node4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubnodeConfiguration getGlobalSection() {
        ViewNode parent2 = new ViewNode();
        for (ConfigurationNode node4 : this.getRootNode().getChildren()) {
            if (HierarchicalINIConfiguration.isSectionNode(node4)) continue;
            ConfigurationNode configurationNode = node4;
            synchronized (configurationNode) {
                parent2.addChild(node4);
            }
        }
        return this.createSubnodeConfiguration(parent2);
    }

    private static void markSectionNode(ConfigurationNode node4) {
        node4.setReference(Boolean.TRUE);
    }

    private static boolean isSectionNode(ConfigurationNode node4) {
        return node4.getReference() != null || node4.getChildrenCount() > 0;
    }
}

