/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationKey;
import org.apache.commons.configuration.ConfigurationXMLReader;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class HierarchicalConfigurationXMLReader
extends ConfigurationXMLReader {
    private HierarchicalConfiguration configuration;

    public HierarchicalConfigurationXMLReader() {
    }

    public HierarchicalConfigurationXMLReader(HierarchicalConfiguration config) {
        this();
        this.setConfiguration(config);
    }

    public HierarchicalConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(HierarchicalConfiguration config) {
        this.configuration = config;
    }

    public Configuration getParsedConfiguration() {
        return this.getConfiguration();
    }

    protected void processKeys() {
        this.getConfiguration().getRoot().visit(new SAXVisitor(), null);
    }

    class SAXVisitor
    extends HierarchicalConfiguration.NodeVisitor {
        private static final String ATTR_TYPE = "CDATA";

        SAXVisitor() {
        }

        public void visitAfterChildren(HierarchicalConfiguration.Node node4, ConfigurationKey key) {
            if (!this.isAttributeNode(node4)) {
                HierarchicalConfigurationXMLReader.this.fireElementEnd(this.nodeName(node4));
            }
        }

        public void visitBeforeChildren(HierarchicalConfiguration.Node node4, ConfigurationKey key) {
            if (!this.isAttributeNode(node4)) {
                HierarchicalConfigurationXMLReader.this.fireElementStart(this.nodeName(node4), this.fetchAttributes(node4));
                if (node4.getValue() != null) {
                    HierarchicalConfigurationXMLReader.this.fireCharacters(node4.getValue().toString());
                }
            }
        }

        public boolean terminate() {
            return HierarchicalConfigurationXMLReader.this.getException() != null;
        }

        protected Attributes fetchAttributes(HierarchicalConfiguration.Node node4) {
            AttributesImpl attrs = new AttributesImpl();
            for (ConfigurationNode child : node4.getAttributes()) {
                if (child.getValue() == null) continue;
                String attr = child.getName();
                attrs.addAttribute("", attr, attr, ATTR_TYPE, child.getValue().toString());
            }
            return attrs;
        }

        private String nodeName(HierarchicalConfiguration.Node node4) {
            return node4.getName() == null ? HierarchicalConfigurationXMLReader.this.getRootName() : node4.getName();
        }

        private boolean isAttributeNode(HierarchicalConfiguration.Node node4) {
            return node4.isAttribute();
        }
    }
}

