/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationKey;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.ConfigurationNodeVisitorAdapter;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.configuration.tree.DefaultExpressionEngine;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.NodeAddData;
import org.apache.commons.configuration.tree.ViewNode;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalConfiguration
extends AbstractConfiguration
implements Serializable,
Cloneable {
    public static final int EVENT_CLEAR_TREE = 10;
    public static final int EVENT_ADD_NODES = 11;
    public static final int EVENT_SUBNODE_CHANGED = 12;
    private static final long serialVersionUID = 3373812230395363192L;
    private static ExpressionEngine defaultExpressionEngine;
    private Node root;
    private ConfigurationNode rootNode;
    private transient ExpressionEngine expressionEngine;

    public HierarchicalConfiguration() {
        this.setRootNode(new Node());
    }

    public HierarchicalConfiguration(HierarchicalConfiguration c) {
        this();
        if (c != null) {
            CloneVisitor visitor = new CloneVisitor();
            c.getRootNode().visit(visitor);
            this.setRootNode(visitor.getClone());
        }
    }

    public Object getReloadLock() {
        return this;
    }

    public Node getRoot() {
        if (this.root == null && this.rootNode != null) {
            return new Node(this.rootNode);
        }
        return this.root;
    }

    public void setRoot(Node node4) {
        if (node4 == null) {
            throw new IllegalArgumentException("Root node must not be null!");
        }
        this.root = node4;
        this.rootNode = null;
    }

    public ConfigurationNode getRootNode() {
        return this.rootNode != null ? this.rootNode : this.root;
    }

    public void setRootNode(ConfigurationNode rootNode) {
        if (rootNode == null) {
            throw new IllegalArgumentException("Root node must not be null!");
        }
        this.rootNode = rootNode;
        this.root = rootNode instanceof Node ? (Node)rootNode : null;
    }

    public static synchronized ExpressionEngine getDefaultExpressionEngine() {
        if (defaultExpressionEngine == null) {
            defaultExpressionEngine = new DefaultExpressionEngine();
        }
        return defaultExpressionEngine;
    }

    public static synchronized void setDefaultExpressionEngine(ExpressionEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("Default expression engine must not be null!");
        }
        defaultExpressionEngine = engine;
    }

    public ExpressionEngine getExpressionEngine() {
        return this.expressionEngine != null ? this.expressionEngine : HierarchicalConfiguration.getDefaultExpressionEngine();
    }

    public void setExpressionEngine(ExpressionEngine expressionEngine) {
        this.expressionEngine = expressionEngine;
    }

    @Override
    public Object getProperty(String key) {
        List<ConfigurationNode> nodes2 = this.fetchNodeList(key);
        if (nodes2.size() == 0) {
            return null;
        }
        ArrayList<Object> list2 = new ArrayList<Object>();
        for (ConfigurationNode node4 : nodes2) {
            if (node4.getValue() == null) continue;
            list2.add(node4.getValue());
        }
        if (list2.size() < 1) {
            return null;
        }
        return list2.size() == 1 ? list2.get(0) : list2;
    }

    @Override
    protected void addPropertyDirect(String key, Object obj) {
        NodeAddData data = this.getExpressionEngine().prepareAdd(this.getRootNode(), key);
        ConfigurationNode node4 = this.processNodeAddData(data);
        node4.setValue(obj);
    }

    public void addNodes(String key, Collection<? extends ConfigurationNode> nodes2) {
        ConfigurationNode parent2;
        if (nodes2 == null || nodes2.isEmpty()) {
            return;
        }
        this.fireEvent(11, key, nodes2, true);
        List<ConfigurationNode> target = this.fetchNodeList(key);
        if (target.size() == 1) {
            ConfigurationNode parent22 = target.get(0);
        } else {
            parent2 = this.processNodeAddData(this.getExpressionEngine().prepareAdd(this.getRootNode(), key));
        }
        if (parent2.isAttribute()) {
            throw new IllegalArgumentException("Cannot add nodes to an attribute node!");
        }
        for (ConfigurationNode configurationNode : nodes2) {
            if (configurationNode.isAttribute()) {
                parent2.addAttribute(configurationNode);
            } else {
                parent2.addChild(configurationNode);
            }
            HierarchicalConfiguration.clearReferences(configurationNode);
        }
        this.fireEvent(11, key, nodes2, false);
    }

    @Override
    public boolean isEmpty() {
        return !this.nodeDefined(this.getRootNode());
    }

    @Override
    public Configuration subset(String prefix) {
        List<ConfigurationNode> nodes2 = this.fetchNodeList(prefix);
        if (nodes2.isEmpty()) {
            return new HierarchicalConfiguration();
        }
        final HierarchicalConfiguration parent2 = this;
        HierarchicalConfiguration result2 = new HierarchicalConfiguration(){

            protected Object interpolate(Object value2) {
                return parent2.interpolate(value2);
            }
        };
        CloneVisitor visitor = new CloneVisitor();
        Object value2 = null;
        int valueCount = 0;
        for (ConfigurationNode nd : nodes2) {
            if (nd.getValue() != null) {
                value2 = nd.getValue();
                ++valueCount;
            }
            nd.visit(visitor);
            for (ConfigurationNode c : visitor.getClone().getChildren()) {
                result2.getRootNode().addChild(c);
            }
            for (ConfigurationNode attr : visitor.getClone().getAttributes()) {
                result2.getRootNode().addAttribute(attr);
            }
        }
        if (valueCount == 1) {
            result2.getRootNode().setValue(value2);
        }
        return result2.isEmpty() ? new HierarchicalConfiguration() : result2;
    }

    public SubnodeConfiguration configurationAt(String key, boolean supportUpdates) {
        List<ConfigurationNode> nodes2 = this.fetchNodeList(key);
        if (nodes2.size() != 1) {
            throw new IllegalArgumentException("Passed in key must select exactly one node: " + key);
        }
        return supportUpdates ? this.createSubnodeConfiguration(nodes2.get(0), key) : this.createSubnodeConfiguration(nodes2.get(0));
    }

    public SubnodeConfiguration configurationAt(String key) {
        return this.configurationAt(key, false);
    }

    public List<HierarchicalConfiguration> configurationsAt(String key) {
        List<ConfigurationNode> nodes2 = this.fetchNodeList(key);
        ArrayList<HierarchicalConfiguration> configs = new ArrayList<HierarchicalConfiguration>(nodes2.size());
        for (ConfigurationNode node4 : nodes2) {
            configs.add(this.createSubnodeConfiguration(node4));
        }
        return configs;
    }

    protected SubnodeConfiguration createSubnodeConfiguration(ConfigurationNode node4) {
        SubnodeConfiguration result2 = new SubnodeConfiguration(this, node4);
        this.registerSubnodeConfiguration(result2);
        return result2;
    }

    protected SubnodeConfiguration createSubnodeConfiguration(ConfigurationNode node4, String subnodeKey) {
        SubnodeConfiguration result2 = this.createSubnodeConfiguration(node4);
        result2.setSubnodeKey(subnodeKey);
        return result2;
    }

    protected void subnodeConfigurationChanged(ConfigurationEvent event) {
        this.fireEvent(12, null, event, event.isBeforeUpdate());
    }

    void registerSubnodeConfiguration(SubnodeConfiguration config) {
        config.addConfigurationListener(new ConfigurationListener(){

            public void configurationChanged(ConfigurationEvent event) {
                HierarchicalConfiguration.this.subnodeConfigurationChanged(event);
            }
        });
    }

    @Override
    public boolean containsKey(String key) {
        return this.getProperty(key) != null;
    }

    @Override
    public void setProperty(String key, Object value2) {
        this.fireEvent(3, key, value2, true);
        Iterator<ConfigurationNode> itNodes = this.fetchNodeList(key).iterator();
        Iterator<Object> itValues = !this.isDelimiterParsingDisabled() || !(value2 instanceof String) ? PropertyConverter.toIterator(value2, this.getListDelimiter()) : Collections.singleton(value2).iterator();
        while (itNodes.hasNext() && itValues.hasNext()) {
            itNodes.next().setValue(itValues.next());
        }
        while (itValues.hasNext()) {
            this.addPropertyDirect(key, itValues.next());
        }
        while (itNodes.hasNext()) {
            this.clearNode(itNodes.next());
        }
        this.fireEvent(3, key, value2, false);
    }

    @Override
    public void clear() {
        this.fireEvent(4, null, null, true);
        this.getRootNode().removeAttributes();
        this.getRootNode().removeChildren();
        this.getRootNode().setValue(null);
        this.fireEvent(4, null, null, false);
    }

    public void clearTree(String key) {
        this.fireEvent(10, key, null, true);
        List<ConfigurationNode> nodes2 = this.fetchNodeList(key);
        for (ConfigurationNode node4 : nodes2) {
            this.removeNode(node4);
        }
        this.fireEvent(10, key, nodes2, false);
    }

    @Override
    public void clearProperty(String key) {
        this.fireEvent(2, key, null, true);
        List<ConfigurationNode> nodes2 = this.fetchNodeList(key);
        for (ConfigurationNode node4 : nodes2) {
            this.clearNode(node4);
        }
        this.fireEvent(2, key, null, false);
    }

    @Override
    public Iterator<String> getKeys() {
        DefinedKeysVisitor visitor = new DefinedKeysVisitor();
        this.getRootNode().visit(visitor);
        return visitor.getKeyList().iterator();
    }

    @Override
    public Iterator<String> getKeys(String prefix) {
        DefinedKeysVisitor visitor = new DefinedKeysVisitor(prefix);
        if (this.containsKey(prefix)) {
            visitor.getKeyList().add(prefix);
        }
        List<ConfigurationNode> nodes2 = this.fetchNodeList(prefix);
        for (ConfigurationNode node4 : nodes2) {
            for (ConfigurationNode c : node4.getChildren()) {
                c.visit(visitor);
            }
            for (ConfigurationNode attr : node4.getAttributes()) {
                attr.visit(visitor);
            }
        }
        return visitor.getKeyList().iterator();
    }

    public int getMaxIndex(String key) {
        return this.fetchNodeList(key).size() - 1;
    }

    @Override
    public Object clone() {
        try {
            HierarchicalConfiguration copy2 = (HierarchicalConfiguration)super.clone();
            CloneVisitor v = new CloneVisitor();
            this.getRootNode().visit(v);
            copy2.setRootNode(v.getClone());
            return copy2;
        }
        catch (CloneNotSupportedException cex) {
            throw new ConfigurationRuntimeException(cex);
        }
    }

    @Override
    public Configuration interpolatedConfiguration() {
        HierarchicalConfiguration c = (HierarchicalConfiguration)this.clone();
        c.getRootNode().visit(new ConfigurationNodeVisitorAdapter(){

            public void visitAfterChildren(ConfigurationNode node4) {
                node4.setValue(HierarchicalConfiguration.this.interpolate(node4.getValue()));
            }
        });
        return c;
    }

    protected List<ConfigurationNode> fetchNodeList(String key) {
        return this.getExpressionEngine().query(this.getRootNode(), key);
    }

    @Deprecated
    protected void findPropertyNodes(ConfigurationKey.KeyIterator keyPart, Node node4, Collection<ConfigurationNode> nodes2) {
    }

    @Deprecated
    protected boolean nodeDefined(Node node4) {
        return this.nodeDefined((ConfigurationNode)node4);
    }

    protected boolean nodeDefined(ConfigurationNode node4) {
        DefinedVisitor visitor = new DefinedVisitor();
        node4.visit(visitor);
        return visitor.isDefined();
    }

    @Deprecated
    protected void removeNode(Node node4) {
        this.removeNode((ConfigurationNode)node4);
    }

    protected void removeNode(ConfigurationNode node4) {
        ConfigurationNode parent2 = node4.getParentNode();
        if (parent2 != null) {
            parent2.removeChild(node4);
            if (!this.nodeDefined(parent2)) {
                this.removeNode(parent2);
            }
        }
    }

    @Deprecated
    protected void clearNode(Node node4) {
        this.clearNode((ConfigurationNode)node4);
    }

    protected void clearNode(ConfigurationNode node4) {
        node4.setValue(null);
        if (!this.nodeDefined(node4)) {
            this.removeNode(node4);
        }
    }

    @Deprecated
    protected Node fetchAddNode(ConfigurationKey.KeyIterator keyIt, Node startNode) {
        return null;
    }

    @Deprecated
    protected Node findLastPathNode(ConfigurationKey.KeyIterator keyIt, Node node4) {
        return null;
    }

    @Deprecated
    protected Node createAddPath(ConfigurationKey.KeyIterator keyIt, Node root2) {
        return null;
    }

    protected Node createNode(String name) {
        return new Node(name);
    }

    private ConfigurationNode processNodeAddData(NodeAddData data) {
        ConfigurationNode node4 = data.getParent();
        for (String name : data.getPathNodes()) {
            Node child = this.createNode(name);
            node4.addChild(child);
            node4 = child;
        }
        Node child = this.createNode(data.getNewNodeName());
        if (data.isAttribute()) {
            node4.addAttribute(child);
        } else {
            node4.addChild(child);
        }
        return child;
    }

    protected static void clearReferences(ConfigurationNode node4) {
        node4.visit(new ConfigurationNodeVisitorAdapter(){

            public void visitBeforeChildren(ConfigurationNode node4) {
                node4.setReference(null);
            }
        });
    }

    private static Node getNodeFor(Object obj) {
        Node nd;
        if (obj instanceof ViewNode) {
            final ViewNode viewNode = (ViewNode)obj;
            nd = new Node(viewNode){

                public void setReference(Object reference) {
                    super.setReference(reference);
                    viewNode.setReference(reference);
                }
            };
        } else {
            nd = (Node)obj;
        }
        return nd;
    }

    protected static abstract class BuilderVisitor
    extends NodeVisitor {
        protected BuilderVisitor() {
        }

        public void visitBeforeChildren(Node node4, ConfigurationKey key) {
            LinkedList<ConfigurationNode> subNodes = new LinkedList<ConfigurationNode>(node4.getChildren());
            subNodes.addAll(node4.getAttributes());
            Iterator children2 = subNodes.iterator();
            Node sibling1 = null;
            Node nd = null;
            while (children2.hasNext()) {
                Object obj;
                Object obj2;
                do {
                    sibling1 = nd;
                } while ((nd = HierarchicalConfiguration.getNodeFor(obj2 = children2.next())).getReference() != null && children2.hasNext());
                if (nd.getReference() != null) continue;
                LinkedList<Node> newNodes = new LinkedList<Node>();
                newNodes.add(nd);
                while (children2.hasNext() && (nd = HierarchicalConfiguration.getNodeFor(obj = children2.next())).getReference() == null) {
                    newNodes.add(nd);
                }
                Node sibling2 = nd.getReference() == null ? null : nd;
                for (Node insertNode : newNodes) {
                    if (insertNode.getReference() != null) continue;
                    Object ref2 = this.insert(insertNode, node4, sibling1, sibling2);
                    if (ref2 != null) {
                        insertNode.setReference(ref2);
                    }
                    sibling1 = insertNode;
                }
            }
        }

        protected abstract Object insert(Node var1, Node var2, Node var3, Node var4);
    }

    static class CloneVisitor
    extends ConfigurationNodeVisitorAdapter {
        private Stack<ConfigurationNode> copyStack = new Stack();
        private ConfigurationNode result;

        public void visitAfterChildren(ConfigurationNode node4) {
            ConfigurationNode copy2 = this.copyStack.pop();
            if (this.copyStack.isEmpty()) {
                this.result = copy2;
            }
        }

        public void visitBeforeChildren(ConfigurationNode node4) {
            ConfigurationNode copy2 = (ConfigurationNode)node4.clone();
            copy2.setParentNode(null);
            if (!this.copyStack.isEmpty()) {
                if (node4.isAttribute()) {
                    this.copyStack.peek().addAttribute(copy2);
                } else {
                    this.copyStack.peek().addChild(copy2);
                }
            }
            this.copyStack.push(copy2);
        }

        public ConfigurationNode getClone() {
            return this.result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DefinedKeysVisitor
    extends ConfigurationNodeVisitorAdapter {
        private Set<String> keyList = new LinkedHashSet<String>();
        private Stack<String> parentKeys = new Stack();

        public DefinedKeysVisitor() {
        }

        public DefinedKeysVisitor(String prefix) {
            this();
            this.parentKeys.push(prefix);
        }

        public Set<String> getKeyList() {
            return this.keyList;
        }

        @Override
        public void visitAfterChildren(ConfigurationNode node4) {
            this.parentKeys.pop();
        }

        @Override
        public void visitBeforeChildren(ConfigurationNode node4) {
            String parentKey = this.parentKeys.isEmpty() ? null : this.parentKeys.peek();
            String key = HierarchicalConfiguration.this.getExpressionEngine().nodeKey(node4, parentKey);
            this.parentKeys.push(key);
            if (node4.getValue() != null) {
                this.keyList.add(key);
            }
        }
    }

    static class DefinedVisitor
    extends ConfigurationNodeVisitorAdapter {
        private boolean defined;

        DefinedVisitor() {
        }

        public boolean terminate() {
            return this.isDefined();
        }

        public void visitBeforeChildren(ConfigurationNode node4) {
            this.defined = node4.getValue() != null;
        }

        public boolean isDefined() {
            return this.defined;
        }
    }

    public static class NodeVisitor {
        public void visitBeforeChildren(Node node4, ConfigurationKey key) {
        }

        public void visitAfterChildren(Node node4, ConfigurationKey key) {
        }

        public boolean terminate() {
            return false;
        }
    }

    public static class Node
    extends DefaultConfigurationNode
    implements Serializable {
        private static final long serialVersionUID = -6357500633536941775L;

        public Node() {
        }

        public Node(String name) {
            super(name);
        }

        public Node(String name, Object value2) {
            super(name, value2);
        }

        public Node(ConfigurationNode src) {
            this(src.getName(), src.getValue());
            ConfigurationNode parent2;
            this.setReference(src.getReference());
            for (ConfigurationNode nd : src.getChildren()) {
                parent2 = nd.getParentNode();
                this.addChild(nd);
                nd.setParentNode(parent2);
            }
            for (ConfigurationNode nd : src.getAttributes()) {
                parent2 = nd.getParentNode();
                this.addAttribute(nd);
                nd.setParentNode(parent2);
            }
        }

        public Node getParent() {
            return (Node)this.getParentNode();
        }

        public void setParent(Node node4) {
            this.setParentNode(node4);
        }

        public void addChild(Node node4) {
            this.addChild((ConfigurationNode)node4);
        }

        public boolean hasChildren() {
            return this.getChildrenCount() > 0 || this.getAttributeCount() > 0;
        }

        public boolean remove(Node child) {
            return child.isAttribute() ? this.removeAttribute(child) : this.removeChild(child);
        }

        public boolean remove(String name) {
            boolean childrenRemoved = this.removeChild(name);
            boolean attrsRemoved = this.removeAttribute(name);
            return childrenRemoved || attrsRemoved;
        }

        public void visit(NodeVisitor visitor, ConfigurationKey key) {
            ConfigurationNode obj;
            int length2 = 0;
            if (key != null) {
                length2 = key.length();
                if (this.getName() != null) {
                    key.append(StringUtils.replace(this.isAttribute() ? ConfigurationKey.constructAttributeKey(this.getName()) : this.getName(), String.valueOf('.'), ConfigurationKey.ESCAPED_DELIMITER));
                }
            }
            visitor.visitBeforeChildren(this, key);
            Iterator<ConfigurationNode> it = this.getChildren().iterator();
            while (it.hasNext() && !visitor.terminate()) {
                obj = it.next();
                HierarchicalConfiguration.getNodeFor(obj).visit(visitor, key);
            }
            it = this.getAttributes().iterator();
            while (it.hasNext() && !visitor.terminate()) {
                obj = it.next();
                HierarchicalConfiguration.getNodeFor(obj).visit(visitor, key);
            }
            visitor.visitAfterChildren(this, key);
            if (key != null) {
                key.setLength(length2);
            }
        }
    }
}

