/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.IOException;
import org.apache.commons.configuration.Configuration;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public abstract class ConfigurationXMLReader
implements XMLReader {
    protected static final String NS_URI = "";
    private static final String DEFAULT_ROOT_NAME = "config";
    private static final Attributes EMPTY_ATTRS = new AttributesImpl();
    private ContentHandler contentHandler;
    private SAXException exception;
    private String rootName;

    protected ConfigurationXMLReader() {
        this.setRootName(DEFAULT_ROOT_NAME);
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.parseConfiguration();
    }

    public void parse(InputSource input2) throws IOException, SAXException {
        this.parseConfiguration();
    }

    public boolean getFeature(String name) {
        return false;
    }

    public void setFeature(String name, boolean value2) {
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setDTDHandler(DTDHandler handler) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setEntityResolver(EntityResolver resolver) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setErrorHandler(ErrorHandler handler) {
    }

    public Object getProperty(String name) {
        return null;
    }

    public void setProperty(String name, Object value2) {
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String string2) {
        this.rootName = string2;
    }

    protected void fireElementStart(String name, Attributes attribs) {
        if (this.getException() == null) {
            try {
                Attributes at2 = attribs == null ? EMPTY_ATTRS : attribs;
                this.getContentHandler().startElement(NS_URI, name, name, at2);
            }
            catch (SAXException ex) {
                this.exception = ex;
            }
        }
    }

    protected void fireElementEnd(String name) {
        if (this.getException() == null) {
            try {
                this.getContentHandler().endElement(NS_URI, name, name);
            }
            catch (SAXException ex) {
                this.exception = ex;
            }
        }
    }

    protected void fireCharacters(String text2) {
        if (this.getException() == null) {
            try {
                char[] ch = text2.toCharArray();
                this.getContentHandler().characters(ch, 0, ch.length);
            }
            catch (SAXException ex) {
                this.exception = ex;
            }
        }
    }

    public SAXException getException() {
        return this.exception;
    }

    protected void parseConfiguration() throws IOException, SAXException {
        if (this.getParsedConfiguration() == null) {
            throw new IOException("No configuration specified!");
        }
        if (this.getContentHandler() != null) {
            this.exception = null;
            this.getContentHandler().startDocument();
            this.processKeys();
            if (this.getException() != null) {
                throw this.getException();
            }
            this.getContentHandler().endDocument();
        }
    }

    public abstract Configuration getParsedConfiguration();

    protected abstract void processKeys() throws IOException, SAXException;
}

