/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.HierarchicalReloadableConfiguration;
import org.apache.commons.configuration.Lock;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationKey;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.configuration.tree.DefaultExpressionEngine;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.NodeCombiner;
import org.apache.commons.configuration.tree.TreeUtils;
import org.apache.commons.configuration.tree.UnionCombiner;
import org.apache.commons.configuration.tree.ViewNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedConfiguration
extends HierarchicalReloadableConfiguration
implements ConfigurationListener,
Cloneable {
    public static final int EVENT_COMBINED_INVALIDATE = 40;
    private static final long serialVersionUID = 8338574525528692307L;
    private static final DefaultExpressionEngine AT_ENGINE = new DefaultExpressionEngine();
    private static final NodeCombiner DEFAULT_COMBINER = new UnionCombiner();
    private static final String PROP_RELOAD_CHECK = "CombinedConfigurationReloadCheck";
    private NodeCombiner nodeCombiner;
    private volatile ConfigurationNode combinedRoot;
    private List<ConfigData> configurations;
    private Map<String, AbstractConfiguration> namedConfigurations;
    private boolean ignoreReloadExceptions = true;
    private boolean reloadRequired;
    private ExpressionEngine conversionExpressionEngine;
    private boolean forceReloadCheck;

    public CombinedConfiguration(NodeCombiner comb) {
        this.setNodeCombiner(comb != null ? comb : DEFAULT_COMBINER);
        this.clear();
    }

    public CombinedConfiguration(NodeCombiner comb, Lock lock) {
        super(lock);
        this.setNodeCombiner(comb != null ? comb : DEFAULT_COMBINER);
        this.clear();
    }

    public CombinedConfiguration(Lock lock) {
        this(null, lock);
    }

    public CombinedConfiguration() {
        this(null, null);
    }

    public NodeCombiner getNodeCombiner() {
        return this.nodeCombiner;
    }

    public void setNodeCombiner(NodeCombiner nodeCombiner) {
        if (nodeCombiner == null) {
            throw new IllegalArgumentException("Node combiner must not be null!");
        }
        this.nodeCombiner = nodeCombiner;
        this.invalidate();
    }

    public boolean isForceReloadCheck() {
        return this.forceReloadCheck;
    }

    public void setForceReloadCheck(boolean forceReloadCheck) {
        this.forceReloadCheck = forceReloadCheck;
    }

    public ExpressionEngine getConversionExpressionEngine() {
        return this.conversionExpressionEngine;
    }

    public void setConversionExpressionEngine(ExpressionEngine conversionExpressionEngine) {
        this.conversionExpressionEngine = conversionExpressionEngine;
    }

    public boolean isIgnoreReloadExceptions() {
        return this.ignoreReloadExceptions;
    }

    public void setIgnoreReloadExceptions(boolean ignoreReloadExceptions) {
        this.ignoreReloadExceptions = ignoreReloadExceptions;
    }

    public void addConfiguration(AbstractConfiguration config, String name, String at2) {
        if (config == null) {
            throw new IllegalArgumentException("Added configuration must not be null!");
        }
        if (name != null && this.namedConfigurations.containsKey(name)) {
            throw new ConfigurationRuntimeException("A configuration with the name '" + name + "' already exists in this combined configuration!");
        }
        ConfigData cd = new ConfigData(config, name, at2);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Adding configuration " + config + " with name " + name);
        }
        this.configurations.add(cd);
        if (name != null) {
            this.namedConfigurations.put(name, config);
        }
        config.addConfigurationListener(this);
        this.invalidate();
    }

    public void addConfiguration(AbstractConfiguration config, String name) {
        this.addConfiguration(config, name, null);
    }

    public void addConfiguration(AbstractConfiguration config) {
        this.addConfiguration(config, null, null);
    }

    public int getNumberOfConfigurations() {
        return this.configurations.size();
    }

    public Configuration getConfiguration(int index2) {
        ConfigData cd = this.configurations.get(index2);
        return cd.getConfiguration();
    }

    public Configuration getConfiguration(String name) {
        return this.namedConfigurations.get(name);
    }

    public List<AbstractConfiguration> getConfigurations() {
        ArrayList<AbstractConfiguration> list2 = new ArrayList<AbstractConfiguration>(this.configurations.size());
        for (ConfigData cd : this.configurations) {
            list2.add(cd.getConfiguration());
        }
        return list2;
    }

    public List<String> getConfigurationNameList() {
        ArrayList<String> list2 = new ArrayList<String>(this.configurations.size());
        for (ConfigData cd : this.configurations) {
            list2.add(cd.getName());
        }
        return list2;
    }

    public boolean removeConfiguration(Configuration config) {
        for (int index2 = 0; index2 < this.getNumberOfConfigurations(); ++index2) {
            if (this.configurations.get(index2).getConfiguration() != config) continue;
            this.removeConfigurationAt(index2);
            return true;
        }
        return false;
    }

    public Configuration removeConfigurationAt(int index2) {
        ConfigData cd = this.configurations.remove(index2);
        if (cd.getName() != null) {
            this.namedConfigurations.remove(cd.getName());
        }
        cd.getConfiguration().removeConfigurationListener(this);
        this.invalidate();
        return cd.getConfiguration();
    }

    public Configuration removeConfiguration(String name) {
        Configuration conf = this.getConfiguration(name);
        if (conf != null) {
            this.removeConfiguration(conf);
        }
        return conf;
    }

    public Set<String> getConfigurationNames() {
        return this.namedConfigurations.keySet();
    }

    public void invalidate() {
        this.reloadRequired = true;
        this.fireEvent(40, null, null, false);
    }

    @Override
    public void configurationChanged(ConfigurationEvent event) {
        if (event.getType() == 21) {
            this.fireEvent(event.getType(), event.getPropertyName(), event.getPropertyValue(), event.isBeforeUpdate());
        } else if (!event.isBeforeUpdate()) {
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurationNode getRootNode() {
        Object object = this.getReloadLock();
        synchronized (object) {
            if (this.reloadRequired || this.combinedRoot == null) {
                this.combinedRoot = this.constructCombinedNode();
                this.reloadRequired = false;
            }
            return this.combinedRoot;
        }
    }

    @Override
    public void clear() {
        this.fireEvent(4, null, null, true);
        this.configurations = new ArrayList<ConfigData>();
        this.namedConfigurations = new HashMap<String, AbstractConfiguration>();
        this.fireEvent(4, null, null, false);
        this.invalidate();
    }

    @Override
    public Object clone() {
        CombinedConfiguration copy2 = (CombinedConfiguration)super.clone();
        copy2.clear();
        for (ConfigData cd : this.configurations) {
            copy2.addConfiguration((AbstractConfiguration)ConfigurationUtils.cloneConfiguration(cd.getConfiguration()), cd.getName(), cd.getAt());
        }
        copy2.setRootNode(new DefaultConfigurationNode());
        return copy2;
    }

    public Configuration getSource(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null!");
        }
        List<ConfigurationNode> nodes2 = this.fetchNodeList(key);
        if (nodes2.isEmpty()) {
            return null;
        }
        Iterator<ConfigurationNode> it = nodes2.iterator();
        Configuration source2 = this.findSourceConfiguration(it.next());
        while (it.hasNext()) {
            Configuration src = this.findSourceConfiguration(it.next());
            if (src == source2) continue;
            throw new IllegalArgumentException("The key " + key + " is defined by multiple sources!");
        }
        return source2;
    }

    @Override
    protected List<ConfigurationNode> fetchNodeList(String key) {
        if (this.isForceReloadCheck()) {
            this.performReloadCheck();
        }
        return super.fetchNodeList(key);
    }

    protected void performReloadCheck() {
        for (ConfigData cd : this.configurations) {
            try {
                cd.getConfiguration().getProperty(PROP_RELOAD_CHECK);
            }
            catch (Exception ex) {
                if (this.ignoreReloadExceptions) continue;
                throw new ConfigurationRuntimeException(ex);
            }
        }
    }

    private ConfigurationNode constructCombinedNode() {
        if (this.getNumberOfConfigurations() < 1) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("No configurations defined for " + this);
            }
            return new ViewNode();
        }
        Iterator<ConfigData> it = this.configurations.iterator();
        ConfigurationNode node4 = it.next().getTransformedRoot();
        while (it.hasNext()) {
            node4 = this.getNodeCombiner().combine(node4, it.next().getTransformedRoot());
        }
        if (this.getLogger().isDebugEnabled()) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintStream stream2 = new PrintStream(os);
            TreeUtils.printTree(stream2, node4);
            this.getLogger().debug(os.toString());
        }
        return node4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Configuration findSourceConfiguration(ConfigurationNode node4) {
        Object object = this.getReloadLock();
        synchronized (object) {
            ConfigurationNode root2 = null;
            for (ConfigurationNode current = node4; current != null; current = current.getParentNode()) {
                root2 = current;
            }
            for (ConfigData cd : this.configurations) {
                if (root2 != cd.getRootNode()) continue;
                return cd.getConfiguration();
            }
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConfigData {
        private AbstractConfiguration configuration;
        private String name;
        private Collection<String> atPath;
        private String at;
        private ConfigurationNode rootNode;

        public ConfigData(AbstractConfiguration config, String n, String at2) {
            this.configuration = config;
            this.name = n;
            this.atPath = this.parseAt(at2);
            this.at = at2;
        }

        public AbstractConfiguration getConfiguration() {
            return this.configuration;
        }

        public String getName() {
            return this.name;
        }

        public String getAt() {
            return this.at;
        }

        public ConfigurationNode getRootNode() {
            return this.rootNode;
        }

        public ConfigurationNode getTransformedRoot() {
            ViewNode result2;
            ViewNode atParent = result2 = new ViewNode();
            if (this.atPath != null) {
                for (String p : this.atPath) {
                    ViewNode node4 = new ViewNode();
                    node4.setName(p);
                    atParent.addChild(node4);
                    atParent = node4;
                }
            }
            ConfigurationNode root2 = ConfigurationUtils.convertToHierarchical(this.getConfiguration(), CombinedConfiguration.this.getConversionExpressionEngine()).getRootNode();
            atParent.appendChildren(root2);
            atParent.appendAttributes(root2);
            this.rootNode = root2;
            return result2;
        }

        private Collection<String> parseAt(String at2) {
            if (at2 == null) {
                return null;
            }
            ArrayList<String> result2 = new ArrayList<String>();
            DefaultConfigurationKey.KeyIterator it = new DefaultConfigurationKey(AT_ENGINE, at2).iterator();
            while (it.hasNext()) {
                result2.add(it.nextKey());
            }
            return result2;
        }
    }
}

