/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.activation.MimeTypeParseException;

public class MimeTypeParameterList {
    private Hashtable parameters = new Hashtable();
    private static final String TSPECIALS = "()<>@,;:/[]?=\\\"";

    public MimeTypeParameterList() {
    }

    public MimeTypeParameterList(String parameterList) throws MimeTypeParseException {
        this.parse(parameterList);
    }

    protected void parse(String parameterList) throws MimeTypeParseException {
        char c;
        if (parameterList == null) {
            return;
        }
        int length2 = parameterList.length();
        if (length2 <= 0) {
            return;
        }
        int i = MimeTypeParameterList.skipWhiteSpace(parameterList, 0);
        while (i < length2 && (c = parameterList.charAt(i)) == ';') {
            String value2;
            ++i;
            if ((i = MimeTypeParameterList.skipWhiteSpace(parameterList, i)) >= length2) {
                return;
            }
            int lastIndex = i;
            while (i < length2 && MimeTypeParameterList.isTokenChar(parameterList.charAt(i))) {
                ++i;
            }
            String name = parameterList.substring(lastIndex, i).toLowerCase(Locale.ENGLISH);
            if ((i = MimeTypeParameterList.skipWhiteSpace(parameterList, i)) >= length2 || parameterList.charAt(i) != '=') {
                throw new MimeTypeParseException("Couldn't find the '=' that separates a parameter name from its value.");
            }
            ++i;
            if ((i = MimeTypeParameterList.skipWhiteSpace(parameterList, i)) >= length2) {
                throw new MimeTypeParseException("Couldn't find a value for parameter named " + name);
            }
            c = parameterList.charAt(i);
            if (c == '\"') {
                if (++i >= length2) {
                    throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                }
                lastIndex = i;
                while (i < length2 && (c = parameterList.charAt(i)) != '\"') {
                    if (c == '\\') {
                        ++i;
                    }
                    ++i;
                }
                if (c != '\"') {
                    throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                }
                value2 = MimeTypeParameterList.unquote(parameterList.substring(lastIndex, i));
                ++i;
            } else if (MimeTypeParameterList.isTokenChar(c)) {
                lastIndex = i;
                while (i < length2 && MimeTypeParameterList.isTokenChar(parameterList.charAt(i))) {
                    ++i;
                }
                value2 = parameterList.substring(lastIndex, i);
            } else {
                throw new MimeTypeParseException("Unexpected character encountered at index " + i);
            }
            this.parameters.put(name, value2);
            i = MimeTypeParameterList.skipWhiteSpace(parameterList, i);
        }
        if (i < length2) {
            throw new MimeTypeParseException("More characters encountered in input than expected.");
        }
    }

    public int size() {
        return this.parameters.size();
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public String get(String name) {
        return (String)this.parameters.get(name.trim().toLowerCase(Locale.ENGLISH));
    }

    public void set(String name, String value2) {
        this.parameters.put(name.trim().toLowerCase(Locale.ENGLISH), value2);
    }

    public void remove(String name) {
        this.parameters.remove(name.trim().toLowerCase(Locale.ENGLISH));
    }

    public Enumeration getNames() {
        return this.parameters.keys();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.ensureCapacity(this.parameters.size() * 16);
        Enumeration keys2 = this.parameters.keys();
        while (keys2.hasMoreElements()) {
            String key = (String)keys2.nextElement();
            buffer.append("; ");
            buffer.append(key);
            buffer.append('=');
            buffer.append(MimeTypeParameterList.quote((String)this.parameters.get(key)));
        }
        return buffer.toString();
    }

    private static boolean isTokenChar(char c) {
        return c > ' ' && c < '\u007f' && TSPECIALS.indexOf(c) < 0;
    }

    private static int skipWhiteSpace(String rawdata, int i) {
        int length2 = rawdata.length();
        while (i < length2 && Character.isWhitespace(rawdata.charAt(i))) {
            ++i;
        }
        return i;
    }

    private static String quote(String value2) {
        boolean needsQuotes = false;
        int length2 = value2.length();
        for (int i = 0; i < length2 && !needsQuotes; ++i) {
            needsQuotes = !MimeTypeParameterList.isTokenChar(value2.charAt(i));
        }
        if (needsQuotes) {
            StringBuffer buffer = new StringBuffer();
            buffer.ensureCapacity((int)((double)length2 * 1.5));
            buffer.append('\"');
            for (int i = 0; i < length2; ++i) {
                char c = value2.charAt(i);
                if (c == '\\' || c == '\"') {
                    buffer.append('\\');
                }
                buffer.append(c);
            }
            buffer.append('\"');
            return buffer.toString();
        }
        return value2;
    }

    private static String unquote(String value2) {
        int valueLength = value2.length();
        StringBuffer buffer = new StringBuffer();
        buffer.ensureCapacity(valueLength);
        boolean escaped2 = false;
        for (int i = 0; i < valueLength; ++i) {
            char currentChar = value2.charAt(i);
            if (!escaped2 && currentChar != '\\') {
                buffer.append(currentChar);
                continue;
            }
            if (escaped2) {
                buffer.append(currentChar);
                escaped2 = false;
                continue;
            }
            escaped2 = true;
        }
        return buffer.toString();
    }
}

