/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.ssl.AlgorithmChecker;
import com.typesafe.sslconfig.ssl.AlgorithmConstraint;
import com.typesafe.sslconfig.ssl.AlgorithmConstraintsParser$;
import com.typesafe.sslconfig.ssl.CompositeX509KeyManager;
import com.typesafe.sslconfig.ssl.CompositeX509TrustManager;
import com.typesafe.sslconfig.ssl.ConfigSSLContextBuilder$;
import com.typesafe.sslconfig.ssl.FileBasedKeyStoreBuilder;
import com.typesafe.sslconfig.ssl.FileOnClasspathBasedKeyStoreBuilder;
import com.typesafe.sslconfig.ssl.KeyManagerConfig;
import com.typesafe.sslconfig.ssl.KeyManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.KeyStoreBuilder;
import com.typesafe.sslconfig.ssl.KeyStoreConfig;
import com.typesafe.sslconfig.ssl.SSLConfigSettings;
import com.typesafe.sslconfig.ssl.SSLContextBuilder;
import com.typesafe.sslconfig.ssl.SSLDebugConfig;
import com.typesafe.sslconfig.ssl.SSLDebugConfig$;
import com.typesafe.sslconfig.ssl.SimpleSSLContextBuilder;
import com.typesafe.sslconfig.ssl.StringBasedKeyStoreBuilder;
import com.typesafe.sslconfig.ssl.TrustManagerConfig;
import com.typesafe.sslconfig.ssl.TrustManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.TrustStoreConfig;
import com.typesafe.sslconfig.ssl.package$;
import com.typesafe.sslconfig.ssl.tracing.TracingSSLContext;
import com.typesafe.sslconfig.ssl.tracing.TracingX509ExtendedKeyManager;
import com.typesafe.sslconfig.ssl.tracing.TracingX509ExtendedTrustManager;
import com.typesafe.sslconfig.util.LoggerFactory;
import com.typesafe.sslconfig.util.NoDepsLogger;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRL;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import javax.crypto.BadPaddingException;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\t%f\u0001B\u0001\u0003\u0001-\u0011qcQ8oM&<7k\u0015'D_:$X\r\u001f;Ck&dG-\u001a:\u000b\u0005\r!\u0011aA:tY*\u0011QAB\u0001\ngNd7m\u001c8gS\u001eT!a\u0002\u0005\u0002\u0011QL\b/Z:bM\u0016T\u0011!C\u0001\u0004G>l7\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\t\t2k\u0015'D_:$X\r\u001f;Ck&dG-\u001a:\t\u0011]\u0001!\u0011!Q\u0001\na\t\u0001\"\\6M_\u001e<WM\u001d\t\u00033qi\u0011A\u0007\u0006\u00037\u0011\tA!\u001e;jY&\u0011QD\u0007\u0002\u000e\u0019><w-\u001a:GC\u000e$xN]=\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\nA!\u001b8g_B\u00111#I\u0005\u0003E\t\u0011\u0011cU*M\u0007>tg-[4TKR$\u0018N\\4t\u0011!!\u0003A!A!\u0002\u0013)\u0013!E6fs6\u000bg.Y4fe\u001a\u000b7\r^8ssB\u00111CJ\u0005\u0003O\t\u0011\u0001dS3z\u001b\u0006t\u0017mZ3s\r\u0006\u001cGo\u001c:z/J\f\u0007\u000f]3s\u0011!I\u0003A!A!\u0002\u0013Q\u0013a\u0005;skN$X*\u00198bO\u0016\u0014h)Y2u_JL\bCA\n,\u0013\ta#A\u0001\u000eUeV\u001cH/T1oC\u001e,'OR1di>\u0014\u0018p\u0016:baB,'\u000fC\u0003/\u0001\u0011\u0005q&\u0001\u0004=S:LGO\u0010\u000b\u0006aE\u00124\u0007\u000e\t\u0003'\u0001AQaF\u0017A\u0002aAQaH\u0017A\u0002\u0001BQ\u0001J\u0017A\u0002\u0015BQ!K\u0017A\u0002)BqA\u000e\u0001C\u0002\u0013Eq'\u0001\u0004m_\u001e<WM]\u000b\u0002qA\u0011\u0011$O\u0005\u0003ui\u0011ABT8EKB\u001cHj\\4hKJDa\u0001\u0010\u0001!\u0002\u0013A\u0014a\u00027pO\u001e,'\u000f\t\u0005\u0006}\u0001!\taP\u0001\u0006EVLG\u000e\u001a\u000b\u0002\u0001B\u0011\u0011iR\u0007\u0002\u0005*\u00111a\u0011\u0006\u0003\t\u0016\u000b1A\\3u\u0015\u00051\u0015!\u00026bm\u0006D\u0018B\u0001%C\u0005)\u00196\u000bT\"p]R,\u0007\u0010\u001e\u0005\u0006\u0015\u0002!\taS\u0001\u0010EVLG\u000eZ*T\u0019\u000e{g\u000e^3yiR)\u0001\tT+gY\")Q*\u0013a\u0001\u001d\u0006A\u0001O]8u_\u000e|G\u000e\u0005\u0002P%:\u0011Q\u0002U\u0005\u0003#:\ta\u0001\u0015:fI\u00164\u0017BA*U\u0005\u0019\u0019FO]5oO*\u0011\u0011K\u0004\u0005\u0006-&\u0003\raV\u0001\fW\u0016LX*\u00198bO\u0016\u00148\u000fE\u0002YA\u000et!!\u00170\u000f\u0005ikV\"A.\u000b\u0005qS\u0011A\u0002\u001fs_>$h(C\u0001\u0010\u0013\tyf\"A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0005\u0014'aA*fc*\u0011qL\u0004\t\u0003\u0003\u0012L!!\u001a\"\u0003\u0015-+\u00170T1oC\u001e,'\u000fC\u0003h\u0013\u0002\u0007\u0001.A\u0007ueV\u001cH/T1oC\u001e,'o\u001d\t\u00041\u0002L\u0007CA!k\u0013\tY'I\u0001\u0007UeV\u001cH/T1oC\u001e,'\u000fC\u0003n\u0013\u0002\u0007a.\u0001\u0007tK\u000e,(/\u001a*b]\u0012|W\u000eE\u0002\u000e_FL!\u0001\u001d\b\u0003\r=\u0003H/[8o!\t\u0011x/D\u0001t\u0015\t!X/\u0001\u0005tK\u000e,(/\u001b;z\u0015\u00051\u0018\u0001\u00026bm\u0006L!\u0001_:\u0003\u0019M+7-\u001e:f%\u0006tGm\\7\t\u000bi\u0004A\u0011A>\u00021\t,\u0018\u000e\u001c3D_6\u0004xn]5uK.+\u00170T1oC\u001e,'\u000f\u0006\u0003}\u007f\u0006%\u0001CA\n~\u0013\tq(AA\fD_6\u0004xn]5uKb+\u0004'O&fs6\u000bg.Y4fe\"9\u0011\u0011A=A\u0002\u0005\r\u0011\u0001E6fs6\u000bg.Y4fe\u000e{gNZ5h!\r\u0019\u0012QA\u0005\u0004\u0003\u000f\u0011!\u0001E&fs6\u000bg.Y4fe\u000e{gNZ5h\u0011\u001d\tY!\u001fa\u0001\u0003\u001b\t\u0001#\u00197h_JLG\u000f[7DQ\u0016\u001c7.\u001a:\u0011\u0007M\ty!C\u0002\u0002\u0012\t\u0011\u0001#\u00117h_JLG\u000f[7DQ\u0016\u001c7.\u001a:)\u000fe\f)\"a\u0007\u0002 A\u0019Q\"a\u0006\n\u0007\u0005eaB\u0001\u0006eKB\u0014XmY1uK\u0012\f#!!\b\u0002oU\u001bX\r\t8fo\u0016\u0014\bEY;jY\u0012\u001cu.\u001c9pg&$XmS3z\u001b\u0006t\u0017mZ3sA]LG\u000f\u001b\u0011eK\n,x\r\t9be\u0006lW\r^3sC\t\t\t#A\u00031]Qr\u0003\u0007\u0003\u0004{\u0001\u0011\u0005\u0011Q\u0005\u000b\by\u0006\u001d\u0012\u0011FA\u0016\u0011!\t\t!a\tA\u0002\u0005\r\u0001\u0002CA\u0006\u0003G\u0001\r!!\u0004\t\u0011\u00055\u00121\u0005a\u0001\u0003_\tQ\u0001Z3ck\u001e\u00042aEA\u0019\u0013\r\t\u0019D\u0001\u0002\u000f'NcE)\u001a2vO\u000e{gNZ5h\u0011\u001d\t9\u0004\u0001C\u0001\u0003s\t!DY;jY\u0012\u001cu.\u001c9pg&$X\r\u0016:vgRl\u0015M\\1hKJ$\"\"a\u000f\u0002B\u0005-\u0013QKA5!\r\u0019\u0012QH\u0005\u0004\u0003\u007f\u0011!!G\"p[B|7/\u001b;f1V\u0002\u0014\b\u0016:vgRl\u0015M\\1hKJD\u0001\"a\u0011\u00026\u0001\u0007\u0011QI\u0001\u0011iJ,8\u000f^'b]\u0006<WM]%oM>\u00042aEA$\u0013\r\tIE\u0001\u0002\u0013)J,8\u000f^'b]\u0006<WM]\"p]\u001aLw\r\u0003\u0005\u0002N\u0005U\u0002\u0019AA(\u0003E\u0011XM^8dCRLwN\\#oC\ndW\r\u001a\t\u0004\u001b\u0005E\u0013bAA*\u001d\t9!i\\8mK\u0006t\u0007\u0002CA,\u0003k\u0001\r!!\u0017\u0002\u001fI,go\\2bi&|g\u000eT5tiN\u0004B!D8\u0002\\A!\u0001\fYA/!\u0011\ty&!\u001a\u000e\u0005\u0005\u0005$bAA2g\u0006!1-\u001a:u\u0013\u0011\t9'!\u0019\u0003\u0007\r\u0013F\n\u0003\u0005\u0002\f\u0005U\u0002\u0019AA\u0007Q!\t)$!\u0006\u0002n\u0005}\u0011EAA8\u0003\u0011+6/\u001a\u0011oK^,'\u000f\t<feNLwN\u001c\u0011pM\u0002\u0012W/\u001b7e\u0007>l\u0007o\\:ji\u0016$&/^:u\u001b\u0006t\u0017mZ3sA]LG\u000f\u001b\u0011eK\n,x\r\t9be\u0006lW\r^3s\u0011\u001d\t9\u0004\u0001C\u0001\u0003g\"B\"a\u000f\u0002v\u0005]\u0014\u0011PA>\u0003{B\u0001\"a\u0011\u0002r\u0001\u0007\u0011Q\t\u0005\t\u0003\u001b\n\t\b1\u0001\u0002P!A\u0011qKA9\u0001\u0004\tI\u0006\u0003\u0005\u0002\f\u0005E\u0004\u0019AA\u0007\u0011!\ti#!\u001dA\u0002\u0005=\u0002bBAA\u0001\u0011\u0005\u00111Q\u0001\u0010W\u0016L8\u000b^8sK\n+\u0018\u000e\u001c3feR!\u0011QQAF!\r\u0019\u0012qQ\u0005\u0004\u0003\u0013\u0013!aD&fsN#xN]3Ck&dG-\u001a:\t\u0011\u00055\u0015q\u0010a\u0001\u0003\u001f\u000b1a[:d!\r\u0019\u0012\u0011S\u0005\u0004\u0003'\u0013!AD&fsN#xN]3D_:4\u0017n\u001a\u0005\b\u0003/\u0003A\u0011AAM\u0003E!(/^:u'R|'/\u001a\"vS2$WM\u001d\u000b\u0005\u0003\u000b\u000bY\n\u0003\u0005\u0002\u001e\u0006U\u0005\u0019AAP\u0003\r!8o\u0019\t\u0004'\u0005\u0005\u0016bAAR\u0005\t\u0001BK];tiN#xN]3D_:4\u0017n\u001a\u0005\b\u0003O\u0003A\u0011AAU\u0003-1\u0017\u000e\\3Ck&dG-\u001a:\u0015\u0011\u0005\u0015\u00151VAX\u0003gCq!!,\u0002&\u0002\u0007a*A\u0005ti>\u0014X\rV=qK\"9\u0011\u0011WAS\u0001\u0004q\u0015\u0001\u00034jY\u0016\u0004\u0016\r\u001e5\t\u0011\u0005U\u0016Q\u0015a\u0001\u0003o\u000b\u0001\u0002]1tg^|'\u000f\u001a\t\u0005\u001b=\fI\fE\u0003\u000e\u0003w\u000by,C\u0002\u0002>:\u0011Q!\u0011:sCf\u00042!DAa\u0013\r\t\u0019M\u0004\u0002\u0005\u0007\"\f'\u000fC\u0004\u0002H\u0002!\t!!3\u0002-\u0019LG.Z(o\u00072\f7o\u001d9bi\"\u0014U/\u001b7eKJ$\u0002\"!\"\u0002L\u00065\u0017q\u001a\u0005\b\u0003[\u000b)\r1\u0001O\u0011\u001d\t\t,!2A\u00029C\u0001\"!.\u0002F\u0002\u0007\u0011q\u0017\u0005\b\u0003'\u0004A\u0011AAk\u00035\u0019HO]5oO\n+\u0018\u000e\u001c3feR!\u0011QQAl\u0011\u001d\tI.!5A\u00029\u000bA\u0001Z1uC\"9\u0011Q\u001c\u0001\u0005\u0002\u0005}\u0017\u0001H<be:|e\u000eU&D'F\u0012T)\u001c9usB\u000b7o]<pe\u0012\u0014Uo\u001a\u000b\u0005\u0003\u001f\n\t\u000f\u0003\u0005\u0002\u000e\u0006m\u0007\u0019AAH\u0011\u001d\t)\u000f\u0001C\u0001\u0003O\fqBY;jY\u0012\\U-_'b]\u0006<WM\u001d\u000b\u0007\u0003S\fy/!=\u0011\u0007\u0005\u000bY/C\u0002\u0002n\n\u0013a\u0002W\u001b1s-+\u00170T1oC\u001e,'\u000f\u0003\u0005\u0002\u000e\u0006\r\b\u0019AAH\u0011!\tY!a9A\u0002\u00055\u0001\u0006CAr\u0003+\t)0a\b\"\u0005\u0005]\u0018!O+tK\u0002rWm^3sAY,'o]5p]\u0002zg\r\t2vS2$7*Z=NC:\fw-\u001a:!o&$\b\u000e\t3fEV<\u0007\u0005]1sC6,G/\u001a:\t\u000f\u0005\u0015\b\u0001\"\u0001\u0002|RA\u0011\u0011^A\u007f\u0003\u007f\u0014\t\u0001\u0003\u0005\u0002\u000e\u0006e\b\u0019AAH\u0011!\tY!!?A\u0002\u00055\u0001\u0002CA\u0017\u0003s\u0004\r!a\f\t\u000f\t\u0015\u0001\u0001\"\u0001\u0003\b\u0005I2-\u001a:uS\u001aL7-\u0019;f%\u00164xnY1uS>tG*[:u)\u0011\tIF!\u0003\t\u000f\t-!1\u0001a\u0001A\u0005I1o\u001d7D_:4\u0017n\u001a\u0005\b\u0005\u001f\u0001A\u0011\u0001B\t\u0003-9WM\\3sCR,7I\u0015'\u0015\t\u0005u#1\u0003\u0005\t\u0005+\u0011i\u00011\u0001\u0003\u0018\u0005Y\u0011N\u001c9viN#(/Z1n!\u0011\u0011IBa\b\u000e\u0005\tm!b\u0001B\u000fk\u0006\u0011\u0011n\\\u0005\u0005\u0005C\u0011YBA\u0006J]B,Ho\u0015;sK\u0006l\u0007b\u0002B\u0013\u0001\u0011\u0005!qE\u0001\u0013O\u0016tWM]1uK\u000e\u0013FJ\u0012:p[V\u0013F\n\u0006\u0003\u0002^\t%\u0002\u0002\u0003B\u0016\u0005G\u0001\rA!\f\u0002\u0007U\u0014H\u000e\u0005\u0003\u00030\tMRB\u0001B\u0019\u0015\t!U/\u0003\u0003\u00036\tE\"aA+S\u0019\"9!\u0011\b\u0001\u0005\u0002\tm\u0012aE4f]\u0016\u0014\u0018\r^3D%23%o\\7GS2,G\u0003BA/\u0005{A\u0001Ba\u0010\u00038\u0001\u0007!\u0011I\u0001\u0005M&dW\r\u0005\u0003\u0003\u001a\t\r\u0013\u0002\u0002B#\u00057\u0011AAR5mK\"9!\u0011\n\u0001\u0005\u0002\t-\u0013a\u00072vS2$GK];ti6\u000bg.Y4feB\u000b'/Y7fi\u0016\u00148\u000f\u0006\u0006\u0003N\tM#Q\fB0\u0005C\u00022!\u0011B(\u0013\r\u0011\tF\u0011\u0002\u001f\u0007\u0016\u0014H\u000fU1uQR\u0013Xo\u001d;NC:\fw-\u001a:QCJ\fW.\u001a;feND\u0001B!\u0016\u0003H\u0001\u0007!qK\u0001\u000biJ,8\u000f^*u_J,\u0007c\u0001:\u0003Z%\u0019!1L:\u0003\u0011-+\u0017p\u0015;pe\u0016D\u0001\"!\u0014\u0003H\u0001\u0007\u0011q\n\u0005\t\u0003/\u00129\u00051\u0001\u0002Z!A\u00111\u0002B$\u0001\u0004\ti\u0001C\u0004\u0003f\u0001!\tAa\u001a\u0002#\t,\u0018\u000e\u001c3UeV\u001cH/T1oC\u001e,'\u000f\u0006\u0006\u0003j\t=$\u0011\u000fB:\u0005k\u00022!\u0011B6\u0013\r\u0011iG\u0011\u0002\u00111V\u0002\u0014\b\u0016:vgRl\u0015M\\1hKJD\u0001\"!(\u0003d\u0001\u0007\u0011q\u0014\u0005\t\u0003\u001b\u0012\u0019\u00071\u0001\u0002P!A\u0011q\u000bB2\u0001\u0004\tI\u0006\u0003\u0005\u0002\f\t\r\u0004\u0019AA\u0007Q!\u0011\u0019'!\u0006\u0003z\u0005}\u0011E\u0001B>\u0003A*6/\u001a\u0011oK^,'\u000f\t<feNLwN\u001c\u0011pM\u0002jW\r\u001e5pI\u0002:\u0018\u000e\u001e5!I\u0016\u0014Wo\u001a\u0011qCJ\fW.\u001a;fe\"9!Q\r\u0001\u0005\u0002\t}D\u0003\u0004B5\u0005\u0003\u0013\u0019I!\"\u0003\b\n%\u0005\u0002CAO\u0005{\u0002\r!a(\t\u0011\u00055#Q\u0010a\u0001\u0003\u001fB\u0001\"a\u0016\u0003~\u0001\u0007\u0011\u0011\f\u0005\t\u0003\u0017\u0011i\b1\u0001\u0002\u000e!A\u0011Q\u0006B?\u0001\u0004\ty\u0003C\u0004\u0003\u000e\u0002!\tAa$\u0002AY\fG.\u001b3bi\u0016\u001cFo\u001c:f\u0007>tG/Y5ogB\u0013\u0018N^1uK.+\u0017p\u001d\u000b\u0007\u0003\u001f\u0012\tJa%\t\u0011\u00055%1\u0012a\u0001\u0003\u001fC\u0001B!&\u0003\f\u0002\u0007!qK\u0001\tW\u0016L8\u000b^8sK\"9!\u0011\u0014\u0001\u0005\u0002\tm\u0015!\u0004<bY&$\u0017\r^3Ti>\u0014X\r\u0006\u0004\u0003\u001e\n\r&q\u0015\t\u0004\u001b\t}\u0015b\u0001BQ\u001d\t!QK\\5u\u0011!\u0011)Ka&A\u0002\t]\u0013!B:u_J,\u0007\u0002CA\u0006\u0005/\u0003\r!!\u0004")
public class ConfigSSLContextBuilder
implements SSLContextBuilder {
    private final LoggerFactory mkLogger;
    private final SSLConfigSettings info;
    private final KeyManagerFactoryWrapper keyManagerFactory;
    private final TrustManagerFactoryWrapper trustManagerFactory;
    private final NoDepsLogger logger;

    public NoDepsLogger logger() {
        return this.logger;
    }

    @Override
    public SSLContext build() {
        Option<Seq<CRL>> revocationLists = this.certificateRevocationList(this.info);
        Set<AlgorithmConstraint> signatureConstraints = ((TraversableOnce)this.info.disabledSignatureAlgorithms().map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AlgorithmConstraint apply(String input2) {
                return AlgorithmConstraintsParser$.MODULE$.apply(input2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        Set<AlgorithmConstraint> keySizeConstraints = ((TraversableOnce)this.info.disabledKeyAlgorithms().map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AlgorithmConstraint apply(String input2) {
                return AlgorithmConstraintsParser$.MODULE$.apply(input2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        AlgorithmChecker algorithmChecker = new AlgorithmChecker(this.mkLogger, signatureConstraints, keySizeConstraints);
        Nil$ keyManagers = this.info.keyManagerConfig().keyStoreConfigs().nonEmpty() ? (Seq)scala.collection.Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new CompositeX509KeyManager[]{this.buildCompositeKeyManager(this.info.keyManagerConfig(), algorithmChecker, this.info.debug())})) : Nil$.MODULE$;
        Nil$ trustManagers = this.info.trustManagerConfig().trustStoreConfigs().nonEmpty() ? (Seq)scala.collection.Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new CompositeX509TrustManager[]{this.buildCompositeTrustManager(this.info.trustManagerConfig(), BoxesRunTime.unboxToBoolean(this.info.checkRevocation().getOrElse(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        })), revocationLists, algorithmChecker, this.info.debug())})) : Nil$.MODULE$;
        SSLContext context = this.buildSSLContext(this.info.protocol(), keyManagers, trustManagers, this.info.secureRandom());
        return new TracingSSLContext(context, this.info.debug(), this.mkLogger);
    }

    public SSLContext buildSSLContext(String protocol, Seq<KeyManager> keyManagers, Seq<TrustManager> trustManagers, Option<SecureRandom> secureRandom) {
        SimpleSSLContextBuilder builder = new SimpleSSLContextBuilder(protocol, keyManagers, trustManagers, secureRandom);
        return builder.build();
    }

    public CompositeX509KeyManager buildCompositeKeyManager(KeyManagerConfig keyManagerConfig, AlgorithmChecker algorithmChecker) {
        this.logger().warn("Use newer buildCompositeKeyManager with debug parameter");
        return this.buildCompositeKeyManager(keyManagerConfig, algorithmChecker, SSLDebugConfig$.MODULE$.apply());
    }

    public CompositeX509KeyManager buildCompositeKeyManager(KeyManagerConfig keyManagerConfig, AlgorithmChecker algorithmChecker, SSLDebugConfig debug2) {
        scala.collection.immutable.Seq<X509KeyManager> keyManagers = keyManagerConfig.keyStoreConfigs().map(new Serializable(this, algorithmChecker, debug2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigSSLContextBuilder $outer;
            private final AlgorithmChecker algorithmChecker$1;
            private final SSLDebugConfig debug$1;

            public final X509KeyManager apply(KeyStoreConfig ksc) {
                return this.$outer.buildKeyManager(ksc, this.algorithmChecker$1, this.debug$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.algorithmChecker$1 = algorithmChecker$1;
                this.debug$1 = debug$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new CompositeX509KeyManager(this.mkLogger, keyManagers);
    }

    public CompositeX509TrustManager buildCompositeTrustManager(TrustManagerConfig trustManagerInfo, boolean revocationEnabled, Option<Seq<CRL>> revocationLists, AlgorithmChecker algorithmChecker) {
        this.logger().warn("Use newer version of buildCompositeTrustManager with debug parameter");
        return this.buildCompositeTrustManager(trustManagerInfo, revocationEnabled, revocationLists, algorithmChecker, SSLDebugConfig$.MODULE$.apply());
    }

    public CompositeX509TrustManager buildCompositeTrustManager(TrustManagerConfig trustManagerInfo, boolean revocationEnabled, Option<Seq<CRL>> revocationLists, AlgorithmChecker algorithmChecker, SSLDebugConfig debug2) {
        scala.collection.immutable.Seq<X509TrustManager> trustManagers = trustManagerInfo.trustStoreConfigs().map(new Serializable(this, revocationEnabled, revocationLists, algorithmChecker, debug2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigSSLContextBuilder $outer;
            private final boolean revocationEnabled$1;
            private final Option revocationLists$1;
            private final AlgorithmChecker algorithmChecker$2;
            private final SSLDebugConfig debug$2;

            public final X509TrustManager apply(TrustStoreConfig tsc) {
                return this.$outer.buildTrustManager(tsc, this.revocationEnabled$1, this.revocationLists$1, this.algorithmChecker$2, this.debug$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.revocationEnabled$1 = revocationEnabled$1;
                this.revocationLists$1 = revocationLists$1;
                this.algorithmChecker$2 = algorithmChecker$2;
                this.debug$2 = debug$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new CompositeX509TrustManager(this.mkLogger, trustManagers, algorithmChecker);
    }

    public KeyStoreBuilder keyStoreBuilder(KeyStoreConfig ksc) {
        Option<char[]> password = ksc.password().map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final char[] apply(String x$1) {
                return x$1.toCharArray();
            }
        });
        return ksc.filePath().map(new Serializable(this, ksc, password){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigSSLContextBuilder $outer;
            private final KeyStoreConfig ksc$1;
            private final Option password$1;

            public final KeyStoreBuilder apply(String f2) {
                return this.ksc$1.isFileOnClasspath() ? this.$outer.fileOnClasspathBuilder(this.ksc$1.storeType(), f2, this.password$1) : this.$outer.fileBuilder(this.ksc$1.storeType(), f2, this.password$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ksc$1 = ksc$1;
                this.password$1 = password$1;
            }
        }).getOrElse(new Serializable(this, ksc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigSSLContextBuilder $outer;
            private final KeyStoreConfig ksc$1;

            public final KeyStoreBuilder apply() {
                String data = (String)((Object)this.ksc$1.data().getOrElse(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply() {
                        throw new IllegalStateException("No keystore builder found!");
                    }
                }));
                return this.$outer.stringBuilder(data);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ksc$1 = ksc$1;
            }
        });
    }

    public KeyStoreBuilder trustStoreBuilder(TrustStoreConfig tsc) {
        return tsc.filePath().map(new Serializable(this, tsc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigSSLContextBuilder $outer;
            private final TrustStoreConfig tsc$1;

            public final KeyStoreBuilder apply(String f2) {
                Option<char[]> password = this.tsc$1.password().map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final char[] apply(String x$2) {
                        return x$2.toCharArray();
                    }
                });
                return this.tsc$1.isFileOnClasspath() ? this.$outer.fileOnClasspathBuilder(this.tsc$1.storeType(), f2, password) : this.$outer.fileBuilder(this.tsc$1.storeType(), f2, password);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tsc$1 = tsc$1;
            }
        }).getOrElse(new Serializable(this, tsc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigSSLContextBuilder $outer;
            private final TrustStoreConfig tsc$1;

            public final KeyStoreBuilder apply() {
                String data = (String)((Object)this.tsc$1.data().getOrElse(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply() {
                        throw new IllegalStateException("No truststore builder found!");
                    }
                }));
                return this.$outer.stringBuilder(data);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tsc$1 = tsc$1;
            }
        });
    }

    public KeyStoreBuilder fileBuilder(String storeType, String filePath, Option<char[]> password) {
        return new FileBasedKeyStoreBuilder(storeType, filePath, password);
    }

    public KeyStoreBuilder fileOnClasspathBuilder(String storeType, String filePath, Option<char[]> password) {
        return new FileOnClasspathBasedKeyStoreBuilder(storeType, filePath, password);
    }

    public KeyStoreBuilder stringBuilder(String data) {
        return new StringBasedKeyStoreBuilder(data);
    }

    public boolean warnOnPKCS12EmptyPasswordBug(KeyStoreConfig ksc) {
        return ksc.storeType().equalsIgnoreCase("pkcs12") && !ksc.password().exists((Function1<String, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return !x$3.isEmpty();
            }
        }));
    }

    public X509KeyManager buildKeyManager(KeyStoreConfig ksc, AlgorithmChecker algorithmChecker) {
        this.logger().warn("Use newer version of buildKeyManager with debug parameter");
        return this.buildKeyManager(ksc, algorithmChecker, SSLDebugConfig$.MODULE$.apply());
    }

    public X509KeyManager buildKeyManager(KeyStoreConfig ksc, AlgorithmChecker algorithmChecker, SSLDebugConfig debug2) {
        KeyManager[] keyManagers;
        block5: {
            KeyStore keyStore;
            block4: {
                try {
                    keyStore = this.keyStoreBuilder(ksc).build();
                    if (this.validateStoreContainsPrivateKeys(ksc, keyStore)) break block4;
                }
                catch (BadPaddingException badPaddingException) {
                    throw new SecurityException("Mac verify error: invalid password?", badPaddingException);
                }
                this.logger().warn(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Client authentication is not possible as there are no private keys found in ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{ksc.filePath()})));
            }
            this.validateStore(keyStore, algorithmChecker);
            Option<char[]> password = ksc.password().map(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final char[] apply(String x$4) {
                    return x$4.toCharArray();
                }
            });
            KeyManagerFactoryWrapper factory = this.keyManagerFactory;
            try {
                factory.init(keyStore, (char[])password.orNull(Predef$.MODULE$.$conforms()));
                keyManagers = factory.getKeyManagers();
                if (keyManagers != null) break block5;
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                this.logger().error(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unrecoverable key in keystore ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{ksc})));
                throw new IllegalStateException(unrecoverableKeyException);
            }
            String msg = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot create key manager with configuration ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{ksc}));
            throw new IllegalStateException(msg);
        }
        X509ExtendedKeyManager keyManager = (X509ExtendedKeyManager)Predef$.MODULE$.refArrayOps((Object[])keyManagers).head();
        return new TracingX509ExtendedKeyManager((Function0<X509ExtendedKeyManager>)((Object)new Serializable(this, keyManager){
            public static final long serialVersionUID = 0L;
            private final X509ExtendedKeyManager keyManager$1;

            public final X509ExtendedKeyManager apply() {
                return this.keyManager$1;
            }
            {
                this.keyManager$1 = keyManager$1;
            }
        }), debug2, this.mkLogger);
    }

    public Option<Seq<CRL>> certificateRevocationList(SSLConfigSettings sslConfig) {
        return sslConfig.revocationLists().map(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigSSLContextBuilder $outer;

            public final Seq<CRL> apply(scala.collection.immutable.Seq<URL> urls) {
                return urls.map(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$certificateRevocationList$1 $outer;

                    public final CRL apply(URL url) {
                        return this.$outer.com$typesafe$sslconfig$ssl$ConfigSSLContextBuilder$$anonfun$$$outer().generateCRLFromURL(url);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ ConfigSSLContextBuilder com$typesafe$sslconfig$ssl$ConfigSSLContextBuilder$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public CRL generateCRL(InputStream inputStream) {
        void var3_3;
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        X509CRL crl = (X509CRL)cf.generateCRL(inputStream);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public CRL generateCRLFromURL(URL url) {
        CRL cRL;
        URLConnection connection = url.openConnection();
        connection.setDoInput(true);
        connection.setUseCaches(false);
        DataInputStream inStream = new DataInputStream(connection.getInputStream());
        try {
            cRL = this.generateCRL(inStream);
        }
        catch (Throwable throwable2) {
            void var3_3;
            var3_3.close();
            throw throwable2;
        }
        inStream.close();
        return cRL;
    }

    /*
     * WARNING - void declaration
     */
    public CRL generateCRLFromFile(File file) {
        CRL cRL;
        BufferedInputStream fileStream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
        DataInputStream inStream = new DataInputStream(fileStream);
        try {
            cRL = this.generateCRL(inStream);
        }
        catch (Throwable throwable2) {
            void var3_3;
            var3_3.close();
            throw throwable2;
        }
        inStream.close();
        return cRL;
    }

    public CertPathTrustManagerParameters buildTrustManagerParameters(KeyStore trustStore, boolean revocationEnabled, Option<Seq<CRL>> revocationLists, AlgorithmChecker algorithmChecker) {
        X509CertSelector certSelect = new X509CertSelector();
        PKIXBuilderParameters pkixParameters = new PKIXBuilderParameters(trustStore, (CertSelector)certSelect);
        pkixParameters.setRevocationEnabled(revocationEnabled);
        revocationLists.map(new Serializable(this, pkixParameters){
            public static final long serialVersionUID = 0L;
            private final PKIXBuilderParameters pkixParameters$1;

            public final void apply(Seq<CRL> crlList) {
                this.pkixParameters$1.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(JavaConverters$.MODULE$.asJavaCollectionConverter(crlList).asJavaCollection())));
            }
            {
                this.pkixParameters$1 = pkixParameters$1;
            }
        });
        Seq checkers = (Seq)scala.collection.Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new AlgorithmChecker[]{algorithmChecker}));
        pkixParameters.setCertPathCheckers(JavaConverters$.MODULE$.seqAsJavaListConverter(checkers).asJava());
        return new CertPathTrustManagerParameters(pkixParameters);
    }

    public X509TrustManager buildTrustManager(TrustStoreConfig tsc, boolean revocationEnabled, Option<Seq<CRL>> revocationLists, AlgorithmChecker algorithmChecker) {
        this.logger().warn("Use newer version of buildTrustManager with debug parameter");
        return this.buildTrustManager(tsc, revocationEnabled, revocationLists, algorithmChecker, SSLDebugConfig$.MODULE$.apply());
    }

    public X509TrustManager buildTrustManager(TrustStoreConfig tsc, boolean revocationEnabled, Option<Seq<CRL>> revocationLists, AlgorithmChecker algorithmChecker, SSLDebugConfig debug2) {
        TrustManagerFactoryWrapper factory = this.trustManagerFactory;
        KeyStore trustStore = this.trustStoreBuilder(tsc).build();
        this.validateStore(trustStore, algorithmChecker);
        CertPathTrustManagerParameters trustManagerParameters = this.buildTrustManagerParameters(trustStore, revocationEnabled, revocationLists, algorithmChecker);
        factory.init(trustManagerParameters);
        TrustManager[] trustManagers = factory.getTrustManagers();
        if (trustManagers == null) {
            String msg = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot create trust manager with configuration ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{tsc}));
            throw new IllegalStateException(msg);
        }
        X509ExtendedTrustManager manager = (X509ExtendedTrustManager)Predef$.MODULE$.refArrayOps((Object[])trustManagers).head();
        return new TracingX509ExtendedTrustManager((Function0<X509ExtendedTrustManager>)((Object)new Serializable(this, manager){
            public static final long serialVersionUID = 0L;
            private final X509ExtendedTrustManager manager$1;

            public final X509ExtendedTrustManager apply() {
                return this.manager$1;
            }
            {
                this.manager$1 = manager$1;
            }
        }), debug2, this.mkLogger);
    }

    public boolean validateStoreContainsPrivateKeys(KeyStoreConfig ksc, KeyStore keyStore) {
        char[] password = (char[])ksc.password().map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final char[] apply(String x$5) {
                return x$5.toCharArray();
            }
        }).orNull(Predef$.MODULE$.$conforms());
        BooleanRef containsPrivateKeys = BooleanRef.create(false);
        JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(keyStore.aliases()).asScala().foreach(new Serializable(this, keyStore, password, containsPrivateKeys){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigSSLContextBuilder $outer;
            private final KeyStore keyStore$1;
            private final char[] password$2;
            private final BooleanRef containsPrivateKeys$1;

            public final void apply(String keyAlias) {
                Key key = this.keyStore$1.getKey(keyAlias, this.password$2);
                Key key2 = key;
                if (key2 instanceof PrivateKey) {
                    this.$outer.logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"validateStoreContainsPrivateKeys: private key found for alias ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{keyAlias})));
                    this.containsPrivateKeys$1.elem = true;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String msg = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"validateStoreContainsPrivateKeys: No private key found for alias ", ", it cannot be used for client authentication"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{keyAlias}));
                    this.$outer.logger().warn(msg);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyStore$1 = keyStore$1;
                this.password$2 = password$2;
                this.containsPrivateKeys$1 = containsPrivateKeys$1;
            }
        });
        return containsPrivateKeys.elem;
    }

    public void validateStore(KeyStore store2, AlgorithmChecker algorithmChecker) {
        this.logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"validateStore: type = ", ", size = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{store2.getType(), BoxesRunTime.boxToInteger(store2.size())})));
        JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(store2.aliases()).asScala().foreach(new Serializable(this, store2, algorithmChecker){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigSSLContextBuilder $outer;
            public final KeyStore store$1;
            public final AlgorithmChecker algorithmChecker$3;

            public final Option<BoxedUnit> apply(String alias) {
                return Option$.MODULE$.apply(this.store$1.getCertificate(alias)).map(new Serializable(this, alias){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$validateStore$1 $outer;
                    private final String alias$1;

                    public final void apply(Certificate c) {
                        try {
                            this.$outer.algorithmChecker$3.checkKeyAlgorithms(package$.MODULE$.certificate2X509Certificate(c));
                        }
                        catch (Exception exception) {
                            this.$outer.com$typesafe$sslconfig$ssl$ConfigSSLContextBuilder$$anonfun$$$outer().logger().warn(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"validateStore: Skipping unknown exception ", ": "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.alias$1}))).append((Object)exception.getMessage()).toString());
                            this.$outer.store$1.deleteEntry(this.alias$1);
                        }
                        catch (CertPathValidatorException certPathValidatorException) {
                            this.$outer.com$typesafe$sslconfig$ssl$ConfigSSLContextBuilder$$anonfun$$$outer().logger().warn(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"validateStore: Skipping certificate with weak key size in ", ": "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.alias$1}))).append((Object)certPathValidatorException.getMessage()).toString());
                            this.$outer.store$1.deleteEntry(this.alias$1);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.alias$1 = alias$1;
                    }
                });
            }

            public /* synthetic */ ConfigSSLContextBuilder com$typesafe$sslconfig$ssl$ConfigSSLContextBuilder$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.store$1 = store$1;
                this.algorithmChecker$3 = algorithmChecker$3;
            }
        });
    }

    public ConfigSSLContextBuilder(LoggerFactory mkLogger, SSLConfigSettings info2, KeyManagerFactoryWrapper keyManagerFactory, TrustManagerFactoryWrapper trustManagerFactory) {
        this.mkLogger = mkLogger;
        this.info = info2;
        this.keyManagerFactory = keyManagerFactory;
        this.trustManagerFactory = trustManagerFactory;
        this.logger = mkLogger.apply(this.getClass());
    }
}

