/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.ssl.AlgorithmChecker$;
import com.typesafe.sslconfig.ssl.AlgorithmConstraint;
import com.typesafe.sslconfig.ssl.Algorithms$;
import com.typesafe.sslconfig.util.LoggerFactory;
import com.typesafe.sslconfig.util.NoDepsLogger;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\u0001\u0003\u0001-\u0011\u0001#\u00117h_JLG\u000f[7DQ\u0016\u001c7.\u001a:\u000b\u0005\r!\u0011aA:tY*\u0011QAB\u0001\ngNd7m\u001c8gS\u001eT!a\u0002\u0005\u0002\u0011QL\b/Z:bM\u0016T\u0011!C\u0001\u0004G>l7\u0001A\n\u0003\u00011\u0001\"!\u0004\u000b\u000e\u00039Q!a\u0004\t\u0002\t\r,'\u000f\u001e\u0006\u0003#I\t\u0001b]3dkJLG/\u001f\u0006\u0002'\u0005!!.\u0019<b\u0013\t)bBA\nQ\u0017&C6)\u001a:u!\u0006$\bn\u00115fG.,'\u000f\u0003\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u0019\u0003!i7\u000eT8hO\u0016\u0014\bCA\r\u001d\u001b\u0005Q\"BA\u000e\u0005\u0003\u0011)H/\u001b7\n\u0005uQ\"!\u0004'pO\u001e,'OR1di>\u0014\u0018\u0010\u0003\u0005 \u0001\t\u0015\r\u0011\"\u0001!\u0003Q\u0019\u0018n\u001a8biV\u0014XmQ8ogR\u0014\u0018-\u001b8ugV\t\u0011\u0005E\u0002#Q-r!a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\na\u0001\u0015:fI\u00164\u0017BA\u0015+\u0005\r\u0019V\r\u001e\u0006\u0003O\u0011\u0002\"\u0001L\u0017\u000e\u0003\tI!A\f\u0002\u0003'\u0005cwm\u001c:ji\"l7i\u001c8tiJ\f\u0017N\u001c;\t\u0011A\u0002!\u0011!Q\u0001\n\u0005\nQc]5h]\u0006$XO]3D_:\u001cHO]1j]R\u001c\b\u0005\u0003\u00053\u0001\t\u0015\r\u0011\"\u0001!\u00039YW-_\"p]N$(/Y5oiND\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!I\u0001\u0010W\u0016L8i\u001c8tiJ\f\u0017N\u001c;tA!)a\u0007\u0001C\u0001o\u00051A(\u001b8jiz\"B\u0001O\u001d;wA\u0011A\u0006\u0001\u0005\u0006/U\u0002\r\u0001\u0007\u0005\u0006?U\u0002\r!\t\u0005\u0006eU\u0002\r!\t\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0003\u0019awnZ4feV\tq\b\u0005\u0002\u001a\u0001&\u0011\u0011I\u0007\u0002\r\u001d>$U\r]:M_\u001e<WM\u001d\u0005\u0007\u0007\u0002\u0001\u000b\u0011B \u0002\u000f1|wmZ3sA!9Q\t\u0001b\u0001\n\u00131\u0015aF:jO:\fG/\u001e:f\u0007>t7\u000f\u001e:bS:$8/T1q+\u00059\u0005\u0003\u0002\u0012I\u0015.J!!\u0013\u0016\u0003\u00075\u000b\u0007\u000f\u0005\u0002#\u0017&\u0011AJ\u000b\u0002\u0007'R\u0014\u0018N\\4\t\r9\u0003\u0001\u0015!\u0003H\u0003a\u0019\u0018n\u001a8biV\u0014XmQ8ogR\u0014\u0018-\u001b8ug6\u000b\u0007\u000f\t\u0005\b!\u0002\u0011\r\u0011\"\u0003G\u0003EYW-_\"p]N$(/Y5oiNl\u0015\r\u001d\u0005\u0007%\u0002\u0001\u000b\u0011B$\u0002%-,\u0017pQ8ogR\u0014\u0018-\u001b8ug6\u000b\u0007\u000f\t\u0005\u0006)\u0002!\t!V\u0001\u001bSN4uN]<be\u0012\u001c\u0005.Z2lS:<7+\u001e9q_J$X\r\u001a\u000b\u0002-B\u00111eV\u0005\u00031\u0012\u0012qAQ8pY\u0016\fg\u000eC\u0003[\u0001\u0011\u00051,\u0001\fhKR\u001cV\u000f\u001d9peR,G-\u0012=uK:\u001c\u0018n\u001c8t)\u0005a\u0006cA/`\u00156\taL\u0003\u0002\u001c%%\u0011\u0011F\u0018\u0005\u0006C\u0002!\tAY\u0001\u0005S:LG\u000f\u0006\u0002dMB\u00111\u0005Z\u0005\u0003K\u0012\u0012A!\u00168ji\")q\r\u0019a\u0001-\u00069am\u001c:xCJ$\u0007\"B5\u0001\t\u0003Q\u0017a\u00064j]\u0012\u001c\u0016n\u001a8biV\u0014XmQ8ogR\u0014\u0018-\u001b8u)\tYg\u000eE\u0002$Y.J!!\u001c\u0013\u0003\r=\u0003H/[8o\u0011\u0015y\u0007\u000e1\u0001K\u0003%\tGnZ8sSRDW\u000eC\u0003r\u0001\u0011\u0005!/A\tgS:$7*Z=D_:\u001cHO]1j]R$\"a[:\t\u000b=\u0004\b\u0019\u0001&\t\u000bU\u0004A\u0011\u0001<\u00021\rDWmY6TS\u001et\u0017\r^;sK\u0006cwm\u001c:ji\"l7\u000f\u0006\u0002do\")\u0001\u0010\u001ea\u0001s\u0006A\u00010\u000e\u0019:\u0007\u0016\u0014H\u000f\u0005\u0002\u000eu&\u00111P\u0004\u0002\u00101V\u0002\u0014hQ3si&4\u0017nY1uK\")Q\u0010\u0001C\u0001}\u0006\u00112\r[3dW.+\u00170\u00117h_JLG\u000f[7t)\t\u0019w\u0010C\u0003yy\u0002\u0007\u0011\u0010C\u0004\u0002\u0004\u0001!\t!!\u0002\u0002\u000b\rDWmY6\u0015\u000b\r\f9!a\u0004\t\u000f=\t\t\u00011\u0001\u0002\nA\u0019Q\"a\u0003\n\u0007\u00055aBA\u0006DKJ$\u0018NZ5dCR,\u0007\u0002CA\t\u0003\u0003\u0001\r!a\u0005\u0002%Ut'/Z:pYZ,Gm\u0011:ji\u0016CHo\u001d\t\u0005;\u0006U!*C\u0002\u0002\u0018y\u0013!bQ8mY\u0016\u001cG/[8o\u0011\u001d\tY\u0002\u0001C\u0001\u0003;\tAd];og\u0016$8\u000bS!2'&<g.\u0019;ve\u0016\fEnZ8sSRDW\u000eF\u0002d\u0003?Aa\u0001_A\r\u0001\u0004I\bbBA\u0012\u0001\u0011\u0005\u0011QE\u0001\rS:4wn\u00148Tk:\u001cX\r\u001e\u000b\u0006G\u0006\u001d\u0012\u0011\u0006\u0005\u0007q\u0006\u0005\u0002\u0019A=\t\u0011\u0005-\u0012\u0011\u0005a\u0001\u0003[\ta\"\u001a=qSJ\fG/[8o\t\u0006$X\rE\u0002^\u0003_I1!!\r_\u0005E9%/Z4pe&\fgnQ1mK:$\u0017M\u001d\u0005\b\u0003k\u0001A\u0011AA\u001c\u000319\u0018M\u001d8P]N+hn]3u)\u0015\u0019\u0017\u0011HA\u001e\u0011\u0019A\u00181\u0007a\u0001s\"A\u00111FA\u001a\u0001\u0004\ti\u0003C\u0004\u0002@\u0001!\t!!\u0011\u0002\u001b\u001d,GoQ8n[>tg*Y7f)\rQ\u00151\t\u0005\u0007\u001f\u0005u\u0002\u0019A=")
public class AlgorithmChecker
extends PKIXCertPathChecker {
    private final scala.collection.immutable.Set<AlgorithmConstraint> signatureConstraints;
    private final scala.collection.immutable.Set<AlgorithmConstraint> keyConstraints;
    private final NoDepsLogger com$typesafe$sslconfig$ssl$AlgorithmChecker$$logger;
    private final Map<String, AlgorithmConstraint> signatureConstraintsMap;
    private final Map<String, AlgorithmConstraint> keyConstraintsMap;

    public scala.collection.immutable.Set<AlgorithmConstraint> signatureConstraints() {
        return this.signatureConstraints;
    }

    public scala.collection.immutable.Set<AlgorithmConstraint> keyConstraints() {
        return this.keyConstraints;
    }

    public NoDepsLogger com$typesafe$sslconfig$ssl$AlgorithmChecker$$logger() {
        return this.com$typesafe$sslconfig$ssl$AlgorithmChecker$$logger;
    }

    private Map<String, AlgorithmConstraint> signatureConstraintsMap() {
        return this.signatureConstraintsMap;
    }

    private Map<String, AlgorithmConstraint> keyConstraintsMap() {
        return this.keyConstraintsMap;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return Collections.emptySet();
    }

    @Override
    public void init(boolean forward) {
        this.com$typesafe$sslconfig$ssl$AlgorithmChecker$$logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"init: forward = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToBoolean(forward)})));
        if (forward) {
            throw new CertPathValidatorException("Forward checking not supported");
        }
    }

    public Option<AlgorithmConstraint> findSignatureConstraint(String algorithm2) {
        return this.signatureConstraintsMap().get(algorithm2);
    }

    public Option<AlgorithmConstraint> findKeyConstraint(String algorithm2) {
        return this.keyConstraintsMap().get(algorithm2);
    }

    public void checkSignatureAlgorithms(X509Certificate x509Cert) {
        String sigAlgName = x509Cert.getSigAlgName();
        scala.collection.immutable.Set<String> sigAlgorithms = Algorithms$.MODULE$.decomposes(sigAlgName);
        this.com$typesafe$sslconfig$ssl$AlgorithmChecker$$logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checkSignatureAlgorithms: sigAlgName = ", ", sigAlgName = ", ", sigAlgorithms = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{sigAlgName, sigAlgName, sigAlgorithms})));
        sigAlgorithms.foreach(new Serializable(this, x509Cert){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AlgorithmChecker $outer;
            public final X509Certificate x509Cert$1;

            public final void apply(String a2) {
                this.$outer.findSignatureConstraint(a2).foreach(new Serializable(this, a2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkSignatureAlgorithms$1 $outer;
                    private final String a$1;

                    public final void apply(AlgorithmConstraint constraint) {
                        if (constraint.matches(this.a$1)) {
                            this.$outer.com$typesafe$sslconfig$ssl$AlgorithmChecker$$anonfun$$$outer().com$typesafe$sslconfig$ssl$AlgorithmChecker$$logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checkSignatureAlgorithms: x509Cert = ", " failed on constraint ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.x509Cert$1, constraint})));
                            String msg = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Certificate failed: ", " matched constraint ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.a$1, constraint}));
                            throw new CertPathValidatorException(msg);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.a$1 = a$1;
                    }
                });
            }

            public /* synthetic */ AlgorithmChecker com$typesafe$sslconfig$ssl$AlgorithmChecker$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.x509Cert$1 = x509Cert$1;
            }
        });
    }

    public void checkKeyAlgorithms(X509Certificate x509Cert) {
        PublicKey key = x509Cert.getPublicKey();
        String keyAlgorithmName = key.getAlgorithm();
        int keySize = BoxesRunTime.unboxToInt(Algorithms$.MODULE$.keySize(key).getOrElse(new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final PublicKey key$1;

            public final Nothing$ apply() {
                throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No keySize found for ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.key$1})));
            }
            {
                this.key$1 = key$1;
            }
        }));
        scala.collection.immutable.Set<String> keyAlgorithms = Algorithms$.MODULE$.decomposes(keyAlgorithmName);
        this.com$typesafe$sslconfig$ssl$AlgorithmChecker$$logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checkKeyAlgorithms: keyAlgorithmName = ", ", keySize = ", ", keyAlgorithms = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{keyAlgorithmName, BoxesRunTime.boxToInteger(keySize), keyAlgorithms})));
        keyAlgorithms.foreach(new Serializable(this, x509Cert, keySize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AlgorithmChecker $outer;
            public final X509Certificate x509Cert$2;
            public final int keySize$1;

            public final void apply(String a2) {
                this.$outer.findKeyConstraint(a2).foreach(new Serializable(this, a2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkKeyAlgorithms$1 $outer;
                    private final String a$2;

                    public final void apply(AlgorithmConstraint constraint) {
                        if (constraint.matches(this.a$2, this.$outer.keySize$1)) {
                            String certName = this.$outer.x509Cert$2.getSubjectX500Principal().getName();
                            this.$outer.com$typesafe$sslconfig$ssl$AlgorithmChecker$$anonfun$$$outer().com$typesafe$sslconfig$ssl$AlgorithmChecker$$logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checkKeyAlgorithms: cert = \"", "\" failed on constraint ", ", algorithm = ", ", keySize = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{certName, constraint, this.a$2, BoxesRunTime.boxToInteger(this.$outer.keySize$1)})));
                            String msg = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Certificate failed: cert = \"", "\" failed on constraint ", ", algorithm = ", ", keySize = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{certName, constraint, this.a$2, BoxesRunTime.boxToInteger(this.$outer.keySize$1)}));
                            throw new CertPathValidatorException(msg);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.a$2 = a$2;
                    }
                });
            }

            public /* synthetic */ AlgorithmChecker com$typesafe$sslconfig$ssl$AlgorithmChecker$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.x509Cert$2 = x509Cert$2;
                this.keySize$1 = keySize$1;
            }
        });
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) {
        Certificate certificate = cert;
        if (certificate instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            String commonName = this.getCommonName(x509Certificate);
            Collection<List<?>> subAltNames = x509Certificate.getSubjectAlternativeNames();
            String certName = x509Certificate.getSubjectX500Principal().getName();
            if (this.com$typesafe$sslconfig$ssl$AlgorithmChecker$$logger().isDebugEnabled()) {
                long expirationDate = x509Certificate.getNotAfter().getTime();
                SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                this.com$typesafe$sslconfig$ssl$AlgorithmChecker$$logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"check: checking certificate commonName = ", ", subjAltName = ", ", certName = ", ", expirationDate = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{commonName, subAltNames, certName, isoFormat.format(BoxesRunTime.boxToLong(expirationDate))})));
            }
            this.sunsetSHA1SignatureAlgorithm(x509Certificate);
            this.checkSignatureAlgorithms(x509Certificate);
            this.checkKeyAlgorithms(x509Certificate);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new UnsupportedOperationException("check only works with x509 certificates!");
    }

    public void sunsetSHA1SignatureAlgorithm(X509Certificate x509Cert) {
        String sigAlgName = x509Cert.getSigAlgName();
        scala.collection.immutable.Set<String> sigAlgorithms = Algorithms$.MODULE$.decomposes(sigAlgName);
        if (sigAlgorithms.contains("SHA1") || sigAlgorithms.contains("SHA-1")) {
            GregorianCalendar january2017;
            GregorianCalendar june2016 = new GregorianCalendar(2016, 6, 1, 0, 0, 0);
            GregorianCalendar december2016 = new GregorianCalendar(2016, 12, 31, 0, 0, 0);
            GregorianCalendar expirationDate = new GregorianCalendar();
            expirationDate.setTime(new Date(x509Cert.getNotAfter().getTime()));
            if (expirationDate.after(june2016) && expirationDate.before(december2016)) {
                this.infoOnSunset(x509Cert, expirationDate);
            }
            if ((january2017 = new GregorianCalendar(2017, 1, 1, 0, 0, 0)).equals(expirationDate) || january2017.before(expirationDate)) {
                this.warnOnSunset(x509Cert, expirationDate);
            }
        }
    }

    public void infoOnSunset(X509Certificate x509Cert, GregorianCalendar expirationDate) {
        String certName = x509Cert.getSubjectX500Principal().getName();
        this.com$typesafe$sslconfig$ssl$AlgorithmChecker$$logger().info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Certificate ", " uses SHA-1 and expires ", ": this certificate expires soon, but SHA-1 is being sunsetted."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{certName, expirationDate})));
    }

    public void warnOnSunset(X509Certificate x509Cert, GregorianCalendar expirationDate) {
        String certName = x509Cert.getSubjectX500Principal().getName();
        this.com$typesafe$sslconfig$ssl$AlgorithmChecker$$logger().warn(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Certificate ", " uses SHA-1 and expires ", ": SHA-1 cannot be considered secure and this certificate should be replaced."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{certName, expirationDate})));
    }

    public String getCommonName(X509Certificate cert) {
        String string2;
        try {
            LdapName ldapName = new LdapName(cert.getSubjectX500Principal().getName());
            ObjectRef<Object> cn = ObjectRef.create(null);
            ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ldapName.getRdns()).asScala()).withFilter(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Rdn check$ifrefutable$1) {
                    Rdn rdn = check$ifrefutable$1;
                    boolean bl = rdn != null;
                    return bl;
                }
            }).foreach(new Serializable(this, cn){
                public static final long serialVersionUID = 0L;
                private final ObjectRef cn$1;

                public final void apply(Rdn rdn) {
                    if ("CN".equalsIgnoreCase(rdn.getType())) {
                        this.cn$1.elem = rdn.getValue().toString();
                    }
                }
                {
                    this.cn$1 = cn$1;
                }
            });
            string2 = (String)cn.elem;
        }
        catch (InvalidNameException invalidNameException) {
            string2 = null;
        }
        return string2;
    }

    public AlgorithmChecker(LoggerFactory mkLogger, scala.collection.immutable.Set<AlgorithmConstraint> signatureConstraints, scala.collection.immutable.Set<AlgorithmConstraint> keyConstraints) {
        this.signatureConstraints = signatureConstraints;
        this.keyConstraints = keyConstraints;
        this.com$typesafe$sslconfig$ssl$AlgorithmChecker$$logger = mkLogger.apply(this.getClass());
        this.signatureConstraintsMap = signatureConstraints.iterator().map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, AlgorithmConstraint> apply(AlgorithmConstraint c) {
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(c.algorithm()), c);
            }
        }).toMap(Predef$.MODULE$.$conforms());
        this.keyConstraintsMap = keyConstraints.iterator().map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, AlgorithmConstraint> apply(AlgorithmConstraint c) {
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(c.algorithm()), c);
            }
        }).toMap(Predef$.MODULE$.$conforms());
    }
}

