/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.play.cachecontrol;

import com.typesafe.play.cachecontrol.Cache;
import com.typesafe.play.cachecontrol.CacheDirectives;
import com.typesafe.play.cachecontrol.CacheDirectives$;
import com.typesafe.play.cachecontrol.CacheDirectives$MustRevalidate$;
import com.typesafe.play.cachecontrol.CacheDirectives$NoStore$;
import com.typesafe.play.cachecontrol.CacheDirectives$Public$;
import com.typesafe.play.cachecontrol.CacheRequest;
import com.typesafe.play.cachecontrol.HeaderNames$;
import com.typesafe.play.cachecontrol.OriginResponse;
import com.typesafe.play.cachecontrol.ResponseCachingAction;
import com.typesafe.play.cachecontrol.ResponseCachingActions;
import com.typesafe.play.cachecontrol.ResponseCachingCalculator$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\u0001\u0003\u0001-\u0011\u0011DU3ta>t7/Z\"bG\"LgnZ\"bY\u000e,H.\u0019;pe*\u00111\u0001B\u0001\rG\u0006\u001c\u0007.Z2p]R\u0014x\u000e\u001c\u0006\u0003\u000b\u0019\tA\u0001\u001d7bs*\u0011q\u0001C\u0001\tif\u0004Xm]1gK*\t\u0011\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aD\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u0006G\u0006\u001c\u0007.\u001a\t\u0003+Yi\u0011AA\u0005\u0003/\t\u0011QaQ1dQ\u0016DQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtDCA\u000e\u001d!\t)\u0002\u0001C\u0003\u00141\u0001\u0007A\u0003C\u0003\u001f\u0001\u0011\u0005q$A\u0006jg\u000e\u000b7\r[3bE2,Gc\u0001\u0011$QA\u0011Q#I\u0005\u0003E\t\u0011QCU3ta>t7/Z\"bG\"LgnZ!di&|g\u000eC\u0003%;\u0001\u0007Q%A\u0004sKF,Xm\u001d;\u0011\u0005U1\u0013BA\u0014\u0003\u00051\u0019\u0015m\u00195f%\u0016\fX/Z:u\u0011\u0015IS\u00041\u0001+\u0003!\u0011Xm\u001d9p]N,\u0007CA\u000b,\u0013\ta#A\u0001\bPe&<\u0017N\u001c*fgB|gn]3\t\u000b9\u0002A\u0011C\u0018\u0002'I,7\u000f]8og\u0016L5oQ1dQ\u0016\f'\r\\3\u0015\u0007\u0001\u0002\u0014\u0007C\u0003%[\u0001\u0007Q\u0005C\u0003*[\u0001\u0007!\u0006C\u00034\u0001\u0011EA'\u0001\no_R\u001c\u0015m\u00195fC\ndW-T3uQ>$GcA\u001b@\u0001B\u0019QB\u000e\u001d\n\u0005]r!AB(qi&|g\u000e\u0005\u0002:y9\u0011QCO\u0005\u0003w\t\taCU3ta>t7/Z\"bG\"LgnZ!di&|gn]\u0005\u0003{y\u0012!\u0003R8O_R\u001c\u0015m\u00195f%\u0016\u001c\bo\u001c8tK*\u00111H\u0001\u0005\u0006II\u0002\r!\n\u0005\u0006SI\u0002\rA\u000b\u0005\u0006\u0005\u0002!\tbQ\u0001\u0017S:,G.[4jE2,'+Z:q_:\u001cXmQ8eKR\u0019Q\u0007R#\t\u000b\u0011\n\u0005\u0019A\u0013\t\u000b%\n\u0005\u0019\u0001\u0016\t\u000b\u001d\u0003A\u0011\u0003%\u00021\r|g\u000e^1j]Ntun\u0015;pe\u0016$\u0015N]3di&4X\rF\u00026\u0013*CQ\u0001\n$A\u0002\u0015BQ!\u000b$A\u0002)BQ\u0001\u0014\u0001\u0005\u00125\u000bQfY8oi\u0006Lgn\u001d)sSZ\fG/\u001a*fgB|gn]3ESJ,7\r^5wK&s7\u000b[1sK\u0012\u001c\u0015m\u00195f)\r)dj\u0014\u0005\u0006I-\u0003\r!\n\u0005\u0006S-\u0003\rA\u000b\u0005\u0006#\u0002!\tBU\u0001/G>tG/Y5og&s7m\\7qCRL'\r\\3BkRDwN]5{CRLwN\\%o'\"\f'/\u001a3DC\u000eDW\rF\u00026'RCQ\u0001\n)A\u0002\u0015BQ!\u000b)A\u0002)BQA\u0016\u0001\u0005\u0012]\u000bA#[:DC\u000eDW-\u00192mK\u0016CH/\u001a8tS>tGC\u0001-\\!\ti\u0011,\u0003\u0002[\u001d\t9!i\\8mK\u0006t\u0007\"\u0002/V\u0001\u0004i\u0016!C3yi\u0016t7/[8o!\tq\u0016M\u0004\u0002\u0016?&\u0011\u0001MA\u0001\u0010\u0007\u0006\u001c\u0007.\u001a#je\u0016\u001cG/\u001b<fg&\u0011!m\u0019\u0002\u0018\u0007\u0006\u001c\u0007.\u001a#je\u0016\u001cG/\u001b<f\u000bb$XM\\:j_:T!\u0001\u0019\u0002\t\u000b\u0015\u0004A\u0011\u00034\u00029\u0011L'/Z2uSZ,\u0017\t\u001c7poN\fU\u000f\u001e5pe&T\u0018\r^5p]R\u0011\u0001l\u001a\u0005\u0006S\u0011\u0004\rA\u000b\u0005\u0006S\u0002!\tB[\u0001\u001cG>tG/Y5og\u0006+H\u000f[8sSj\fG/[8o\u0011\u0016\fG-\u001a:\u0015\u0005a[\u0007\"\u0002\u0013i\u0001\u0004)\u0003\"B7\u0001\t#q\u0017!F2p]R\f\u0017N\\:FqBL'/Z:IK\u0006$WM\u001d\u000b\u00031>DQ!\u000b7A\u0002)BQ!\u001d\u0001\u0005\u0012I\fqcY8oi\u0006Lgn\u001d)vE2L7\rR5sK\u000e$\u0018N^3\u0015\u0005a\u001b\b\"B\u0015q\u0001\u0004Q\u0003\"B;\u0001\t#1\u0018aF2p]R\f\u0017N\\:NCb\fu-\u001a#je\u0016\u001cG/\u001b<f)\tAv\u000fC\u0003*i\u0002\u0007!\u0006C\u0003z\u0001\u0011E!0\u0001\rd_:$\u0018-\u001b8t'6\u000b\u00070Q4f\t&\u0014Xm\u0019;jm\u0016$\"\u0001W>\t\u000b%B\b\u0019\u0001\u0016\t\u000bu\u0004A\u0011\u0003@\u0002?\r|g\u000e^1j]NlUo\u001d;SKZ\fG.\u001b3bi\u0016$\u0015N]3di&4X\r\u0006\u0002Y\u007f\")\u0011\u0006 a\u0001U!9\u00111\u0001\u0001\u0005\u0012\u0005\u0015\u0011!G2p]R\f\u0017N\\:DC\u000eD\u0017M\u00197f\u000bb$XM\\:j_:$2\u0001WA\u0004\u0011\u0019I\u0013\u0011\u0001a\u0001U\u001d9\u00111\u0002\u0002\t\u0002\u00055\u0011!\u0007*fgB|gn]3DC\u000eD\u0017N\\4DC2\u001cW\u000f\\1u_J\u00042!FA\b\r\u0019\t!\u0001#\u0001\u0002\u0012M\u0019\u0011q\u0002\u0007\t\u000fe\ty\u0001\"\u0001\u0002\u0016Q\u0011\u0011Q\u0002\u0005\u000b\u00033\tyA1A\u0005\n\u0005m\u0011A\u00027pO\u001e,'/\u0006\u0002\u0002\u001eA!\u0011qDA\u0015\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012!B:mMRR'BAA\u0014\u0003\ry'oZ\u0005\u0005\u0003W\t\tC\u0001\u0004M_\u001e<WM\u001d\u0005\n\u0003_\ty\u0001)A\u0005\u0003;\tq\u0001\\8hO\u0016\u0014\b\u0005")
public class ResponseCachingCalculator {
    private final Cache cache;

    /*
     * WARNING - void declaration
     */
    public ResponseCachingAction isCacheable(CacheRequest request2, OriginResponse response) {
        void var3_3;
        if (ResponseCachingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseCachingCalculator$$logger().isTraceEnabled()) {
            ResponseCachingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseCachingCalculator$$logger().trace(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"isCacheable: request: ", ", response = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{request2, response})));
        }
        ResponseCachingAction result2 = this.notCacheableMethod(request2, response).orElse(new Serializable(this, request2, response){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResponseCachingCalculator $outer;
            private final CacheRequest request$1;
            private final OriginResponse response$1;

            public final Option<ResponseCachingActions.DoNotCacheResponse> apply() {
                return this.$outer.ineligibleResponseCode(this.request$1, this.response$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$1 = request$1;
                this.response$1 = response$1;
            }
        }).orElse(new Serializable(this, request2, response){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResponseCachingCalculator $outer;
            private final CacheRequest request$1;
            private final OriginResponse response$1;

            public final Option<ResponseCachingActions.DoNotCacheResponse> apply() {
                return this.$outer.containsNoStoreDirective(this.request$1, this.response$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$1 = request$1;
                this.response$1 = response$1;
            }
        }).orElse(new Serializable(this, request2, response){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResponseCachingCalculator $outer;
            private final CacheRequest request$1;
            private final OriginResponse response$1;

            public final Option<ResponseCachingActions.DoNotCacheResponse> apply() {
                return this.$outer.containsPrivateResponseDirectiveInSharedCache(this.request$1, this.response$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$1 = request$1;
                this.response$1 = response$1;
            }
        }).orElse(new Serializable(this, request2, response){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResponseCachingCalculator $outer;
            private final CacheRequest request$1;
            private final OriginResponse response$1;

            public final Option<ResponseCachingActions.DoNotCacheResponse> apply() {
                return this.$outer.containsIncompatibleAuthorizationInSharedCache(this.request$1, this.response$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$1 = request$1;
                this.response$1 = response$1;
            }
        }).getOrElse(new Serializable(this, request2, response){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResponseCachingCalculator $outer;
            private final CacheRequest request$1;
            private final OriginResponse response$1;

            public final ResponseCachingAction apply() {
                return this.$outer.responseIsCacheable(this.request$1, this.response$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$1 = request$1;
                this.response$1 = response$1;
            }
        });
        ResponseCachingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseCachingCalculator$$logger().trace(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"isCacheable: result = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{result2})));
        return var3_3;
    }

    public ResponseCachingAction responseIsCacheable(CacheRequest request2, OriginResponse response) {
        if (ResponseCachingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseCachingCalculator$$logger().isTraceEnabled()) {
            ResponseCachingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseCachingCalculator$$logger().trace(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"responseIsCacheable: response = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{response})));
        }
        return this.containsExpiresHeader(response) ? new ResponseCachingActions.DoCacheResponse("Response contains expires header") : (this.containsMaxAgeDirective(response) ? new ResponseCachingActions.DoCacheResponse("Response contains max-age response directive") : (this.cache.isShared() && this.containsSMaxAgeDirective(response) ? new ResponseCachingActions.DoCacheResponse("Response contains s-maxage and the cache is shared") : (this.containsCachableExtension(response) ? new ResponseCachingActions.DoCacheResponse("Response contains a cache control extension that allows it to be cached") : (this.cache.isDefaultCacheable(response.status()) ? new ResponseCachingActions.DoCacheResponse(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Response status code ", " is cacheable by default"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(response.status())}))) : (this.containsPublicDirective(response) ? new ResponseCachingActions.DoCacheResponse("Response contains public response directive") : new ResponseCachingActions.DoNotCacheResponse("Response is not cacheable by default, and there are no explicit overrides"))))));
    }

    public Option<ResponseCachingActions.DoNotCacheResponse> notCacheableMethod(CacheRequest request2, OriginResponse response) {
        return this.cache.isCacheableMethod(request2.method()) ? None$.MODULE$ : new Some<ResponseCachingActions.DoNotCacheResponse>(new ResponseCachingActions.DoNotCacheResponse(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request method ", " is not cacheable"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{request2.method()}))));
    }

    public Option<ResponseCachingActions.DoNotCacheResponse> ineligibleResponseCode(CacheRequest request2, OriginResponse response) {
        int statusCode = response.status();
        return this.cache.isUnderstoodStatusCode(statusCode) ? None$.MODULE$ : new Some<ResponseCachingActions.DoNotCacheResponse>(new ResponseCachingActions.DoNotCacheResponse(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Response code ", " is not understood by the cache"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(statusCode)}))));
    }

    public Option<ResponseCachingActions.DoNotCacheResponse> containsNoStoreDirective(CacheRequest request2, OriginResponse response) {
        return request2.directives().contains(CacheDirectives$NoStore$.MODULE$) ? new Some<ResponseCachingActions.DoNotCacheResponse>(new ResponseCachingActions.DoNotCacheResponse("Request Cache-Control header contains no-store cache directive")) : (response.directives().contains(CacheDirectives$NoStore$.MODULE$) ? new Some<ResponseCachingActions.DoNotCacheResponse>(new ResponseCachingActions.DoNotCacheResponse("Response Cache-Control header contains no-store cache directive")) : None$.MODULE$);
    }

    public Option<ResponseCachingActions.DoNotCacheResponse> containsPrivateResponseDirectiveInSharedCache(CacheRequest request2, OriginResponse response) {
        return this.cache.isShared() ? CacheDirectives$.MODULE$.private(response.directives()).flatMap(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<ResponseCachingActions.DoNotCacheResponse> apply(CacheDirectives.Private privateDirective) {
                Option option2;
                if (privateDirective.headerNames().isDefined()) {
                    ResponseCachingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseCachingCalculator$$logger().debug("qualified private response directive found, returning None");
                    option2 = None$.MODULE$;
                } else {
                    option2 = new Some<ResponseCachingActions.DoNotCacheResponse>(new ResponseCachingActions.DoNotCacheResponse("Cache is shared, and private directive found in response"));
                }
                return option2;
            }
        }) : None$.MODULE$;
    }

    public Option<ResponseCachingActions.DoNotCacheResponse> containsIncompatibleAuthorizationInSharedCache(CacheRequest request2, OriginResponse response) {
        Option option2;
        if (this.cache.isShared()) {
            if (this.containsAuthorizationHeader(request2) && !this.directiveAllowsAuthorization(response)) {
                String msg = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cache is shared, authorization header found, no cache directives allow authorization"})).s(Nil$.MODULE$);
                option2 = new Some<ResponseCachingActions.DoNotCacheResponse>(new ResponseCachingActions.DoNotCacheResponse(msg));
            } else {
                option2 = None$.MODULE$;
            }
        } else {
            option2 = None$.MODULE$;
        }
        return option2;
    }

    public boolean isCacheableExtension(CacheDirectives.CacheDirectiveExtension extension2) {
        return this.cache.isCacheableExtension(extension2);
    }

    public boolean directiveAllowsAuthorization(OriginResponse response) {
        return this.containsMustRevalidateDirective(response) || this.containsPublicDirective(response) || this.containsSMaxAgeDirective(response);
    }

    public boolean containsAuthorizationHeader(CacheRequest request2) {
        return request2.headers().contains(HeaderNames$.MODULE$.Authorization());
    }

    public boolean containsExpiresHeader(OriginResponse response) {
        return response.headers().contains(HeaderNames$.MODULE$.Expires());
    }

    public boolean containsPublicDirective(OriginResponse response) {
        return response.directives().contains(CacheDirectives$Public$.MODULE$);
    }

    public boolean containsMaxAgeDirective(OriginResponse response) {
        return CacheDirectives$.MODULE$.maxAge(response.directives()).isDefined();
    }

    public boolean containsSMaxAgeDirective(OriginResponse response) {
        return CacheDirectives$.MODULE$.sMaxAge(response.directives()).isDefined();
    }

    public boolean containsMustRevalidateDirective(OriginResponse response) {
        return response.directives().contains(CacheDirectives$MustRevalidate$.MODULE$);
    }

    public boolean containsCachableExtension(OriginResponse response) {
        return CacheDirectives$.MODULE$.extensions(response.directives()).exists((Function1<CacheDirectives.CacheDirectiveExtension, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResponseCachingCalculator $outer;

            public final boolean apply(CacheDirectives.CacheDirectiveExtension extension2) {
                return this.$outer.isCacheableExtension(extension2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    public ResponseCachingCalculator(Cache cache) {
        this.cache = cache;
    }
}

