/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.play.cachecontrol;

import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Seconds;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import scala.Function1;
import scala.Serializable;
import scala.util.Try$;

public final class HttpDate$ {
    public static final HttpDate$ MODULE$;
    private final DateTimeZone zone;
    private final DateTimeFormatter imfFixDateFormat;
    private final DateTimeFormatter rfc850Format;
    private final DateTimeFormatter asctimeFormat;

    static {
        new HttpDate$();
    }

    public DateTimeZone zone() {
        return this.zone;
    }

    private DateTimeFormatter imfFixDateFormat() {
        return this.imfFixDateFormat;
    }

    private DateTimeFormatter rfc850Format() {
        return this.rfc850Format;
    }

    private DateTimeFormatter asctimeFormat() {
        return this.asctimeFormat;
    }

    public String format(DateTime dateTime) {
        return this.imfFixDateFormat().print(dateTime);
    }

    public Seconds diff(DateTime start2, DateTime end) {
        return Seconds.secondsBetween(start2, end);
    }

    public DateTime now() {
        return DateTime.now(this.zone());
    }

    public DateTime parse(String dateString) {
        return Try$.MODULE$.apply(new Serializable(dateString){
            public static final long serialVersionUID = 0L;
            private final String dateString$1;

            public final DateTime apply() {
                return HttpDate$.MODULE$.com$typesafe$play$cachecontrol$HttpDate$$parseIMF(this.dateString$1);
            }
            {
                this.dateString$1 = dateString$1;
            }
        }).recover(new Serializable(dateString){
            public static final long serialVersionUID = 0L;
            private final String dateString$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                DateTime dateTime = HttpDate$.MODULE$.com$typesafe$play$cachecontrol$HttpDate$$parseRFC850(this.dateString$1);
                return (B1)dateTime;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable2 = x1;
                boolean bl = true;
                return bl;
            }
            {
                this.dateString$1 = dateString$1;
            }
        }).recover(new Serializable(dateString){
            public static final long serialVersionUID = 0L;
            private final String dateString$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                DateTime dateTime = HttpDate$.MODULE$.com$typesafe$play$cachecontrol$HttpDate$$parseAscTime(this.dateString$1);
                return (B1)dateTime;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable2 = x2;
                boolean bl = true;
                return bl;
            }
            {
                this.dateString$1 = dateString$1;
            }
        }).get();
    }

    public DateTime fromEpochSeconds(int timeSinceEpochInSeconds) {
        return new DateTime((long)timeSinceEpochInSeconds * 1000L).withZone(this.zone());
    }

    public DateTime com$typesafe$play$cachecontrol$HttpDate$$parseIMF(String dateString) {
        return this.imfFixDateFormat().parseDateTime(dateString);
    }

    public DateTime com$typesafe$play$cachecontrol$HttpDate$$parseAscTime(String dateString) {
        return this.asctimeFormat().parseDateTime(dateString);
    }

    public DateTime com$typesafe$play$cachecontrol$HttpDate$$parseRFC850(String dateString) {
        return this.rfc850Format().parseDateTime(dateString);
    }

    private HttpDate$() {
        MODULE$ = this;
        this.zone = DateTimeZone.forID("GMT");
        this.imfFixDateFormat = DateTimeFormat.forPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'").withLocale(Locale.ENGLISH).withZone(DateTimeZone.forID("GMT"));
        this.rfc850Format = DateTimeFormat.forPattern("EEEE, dd-MMM-yy HH:mm:ss 'GMT'").withLocale(Locale.ENGLISH).withZone(DateTimeZone.forID("GMT"));
        this.asctimeFormat = DateTimeFormat.forPattern("EEE MMM d HH:mm:ss yyyy").withLocale(Locale.ENGLISH).withZone(DateTimeZone.forID("GMT"));
    }
}

