/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.play.cachecontrol;

import com.typesafe.play.cachecontrol.Cache;
import com.typesafe.play.cachecontrol.CacheDirective;
import com.typesafe.play.cachecontrol.CacheDirectives;
import com.typesafe.play.cachecontrol.CacheDirectives$;
import com.typesafe.play.cachecontrol.CacheRequest;
import com.typesafe.play.cachecontrol.CacheResponse;
import com.typesafe.play.cachecontrol.HeaderName;
import com.typesafe.play.cachecontrol.HeaderNames$;
import com.typesafe.play.cachecontrol.HttpDate$;
import org.joda.time.DateTime;
import org.joda.time.Seconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0001\u0003\u0001-\u00111C\u0012:fg\"tWm]:DC2\u001cW\u000f\\1u_JT!a\u0001\u0003\u0002\u0019\r\f7\r[3d_:$(o\u001c7\u000b\u0005\u00151\u0011\u0001\u00029mCfT!a\u0002\u0005\u0002\u0011QL\b/Z:bM\u0016T\u0011!C\u0001\u0004G>l7\u0001A\n\u0003\u00011\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\u0002C\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0002\u000b\r\f7\r[3\u0011\u0005U1R\"\u0001\u0002\n\u0005]\u0011!!B\"bG\",\u0007\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\b\u0006\u0002\u001c9A\u0011Q\u0003\u0001\u0005\u0006'a\u0001\r\u0001\u0006\u0005\b=\u0001\u0011\r\u0011\"\u0003 \u0003\u0019awnZ4feV\t\u0001\u0005\u0005\u0002\"M5\t!E\u0003\u0002$I\u0005)1\u000f\u001c45U*\tQ%A\u0002pe\u001eL!a\n\u0012\u0003\r1{wmZ3s\u0011\u0019I\u0003\u0001)A\u0005A\u00059An\\4hKJ\u0004\u0003\"B\u0016\u0001\t\u0003a\u0013AG2bY\u000e,H.\u0019;f\rJ,7\u000f\u001b8fgNd\u0015NZ3uS6,GcA\u00176uA\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0005i&lWM\u0003\u00023I\u0005!!n\u001c3b\u0013\t!tFA\u0004TK\u000e|g\u000eZ:\t\u000bYR\u0003\u0019A\u001c\u0002\u000fI,\u0017/^3tiB\u0011Q\u0003O\u0005\u0003s\t\u0011AbQ1dQ\u0016\u0014V-];fgRDQa\u000f\u0016A\u0002q\n\u0001B]3ta>t7/\u001a\t\u0003+uJ!A\u0010\u0002\u0003\u001b\r\u000b7\r[3SKN\u0004xN\\:f\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0003uI7O\u0012:fg\"tWm]:J]\u001a|'/\\1uS>t\u0017J\u001c<bY&$Gc\u0001\"F\rB\u0011QbQ\u0005\u0003\t:\u0011qAQ8pY\u0016\fg\u000eC\u00037\u007f\u0001\u0007q\u0007C\u0003<\u007f\u0001\u0007A\bC\u0003I\u0001\u0011%\u0011*\u0001\nd_:$\u0018-\u001b8t\tV\u0004H.[2bi\u0016\u001cHc\u0001\"K7\")1j\u0012a\u0001\u0019\u0006QA-\u001b:fGRLg/Z:\u0011\u00075+\u0006L\u0004\u0002O':\u0011qJU\u0007\u0002!*\u0011\u0011KC\u0001\u0007yI|w\u000e\u001e \n\u0003=I!\u0001\u0016\b\u0002\u000fA\f7m[1hK&\u0011ak\u0016\u0002\u0004'\u0016\f(B\u0001+\u000f!\t)\u0012,\u0003\u0002[\u0005\tq1)Y2iK\u0012K'/Z2uSZ,\u0007b\u0002/H!\u0003\u0005\r!X\u0001\u0005g\u0016,g\u000eE\u0002_C\u0012t!!D0\n\u0005\u0001t\u0011A\u0002)sK\u0012,g-\u0003\u0002cG\n\u00191+\u001a;\u000b\u0005\u0001t\u0001GA3k!\rqf\r[\u0005\u0003O\u000e\u0014Qa\u00117bgN\u0004\"!\u001b6\r\u0001\u0011I1nWA\u0001\u0002\u0003\u0015\t\u0001\u001c\u0002\u0004?\u0012\n\u0014CA7q!\tia.\u0003\u0002p\u001d\t9aj\u001c;iS:<\u0007CA\u0007r\u0013\t\u0011hBA\u0002B]fD#a\u0012;\u0011\u0005UDX\"\u0001<\u000b\u0005]t\u0011AC1o]>$\u0018\r^5p]&\u0011\u0011P\u001e\u0002\bi\u0006LGN]3d\u0011\u0015Y\b\u0001\"\u0001}\u0003u\u0019\u0017\r\\2vY\u0006$XM\u0012:fg\"tWm]:Ge>l7+T1y\u0003\u001e,G#B?\u0002\u0002\u0005\r\u0001cA\u0007\u007f[%\u0011qP\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u000bYR\b\u0019A\u001c\t\u000bmR\b\u0019\u0001\u001f\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n\u0005a2-\u00197dk2\fG/\u001a$sKNDg.Z:t\rJ|W.T1y\u0003\u001e,G#B?\u0002\f\u00055\u0001B\u0002\u001c\u0002\u0006\u0001\u0007q\u0007\u0003\u0004<\u0003\u000b\u0001\r\u0001\u0010\u0005\b\u0003#\u0001A\u0011AA\n\u0003u\u0019\u0017\r\\2vY\u0006$XM\u0012:fg\"tWm]:Ge>lW\t\u001f9je\u0016\u001cH#B?\u0002\u0016\u0005]\u0001B\u0002\u001c\u0002\u0010\u0001\u0007q\u0007\u0003\u0004<\u0003\u001f\u0001\r\u0001\u0010\u0005\b\u00037\u0001A\u0011AA\u000f\u0003}\u0019\u0017\r\\2vY\u0006$XM\u0012:fg\"tWm]:Ge>l\u0007*Z;sSN$\u0018n\u0019\u000b\u0006{\u0006}\u0011\u0011\u0005\u0005\u0007m\u0005e\u0001\u0019A\u001c\t\rm\nI\u00021\u0001=\u0011\u001d\t)\u0003\u0001C\u0001\u0003O\t!\"\u001e8baBd\u0017pU3r)\ri\u0018\u0011\u0006\u0005\u0007\u0017\u0006\r\u0002\u0019\u0001'\t\u0013\u00055\u0002!%A\u0005\n\u0005=\u0012\u0001H2p]R\f\u0017N\\:EkBd\u0017nY1uKN$C-\u001a4bk2$HEM\u000b\u0003\u0003cQC!a\r\u0002>A!a,YA\u001ba\u0011\t9$a\u000f\u0011\ty3\u0017\u0011\b\t\u0004S\u0006mBAC6\u0002,\u0005\u0005\t\u0011!B\u0001Y.\u0012\u0011q\b\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011Q\t<\u0002\u0013Ut7\r[3dW\u0016$\u0017\u0002BA%\u0003\u0007\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class FreshnessCalculator {
    private final Cache cache;
    private final Logger com$typesafe$play$cachecontrol$FreshnessCalculator$$logger;

    public Logger com$typesafe$play$cachecontrol$FreshnessCalculator$$logger() {
        return this.com$typesafe$play$cachecontrol$FreshnessCalculator$$logger;
    }

    public Seconds calculateFreshnessLifetime(CacheRequest request2, CacheResponse response) {
        Option option2;
        if (this.com$typesafe$play$cachecontrol$FreshnessCalculator$$logger().isTraceEnabled()) {
            this.com$typesafe$play$cachecontrol$FreshnessCalculator$$logger().trace(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"calculateFreshnessLifetime: "})).s(Nil$.MODULE$));
        }
        if (this.isFreshnessInformationInvalid(request2, response)) {
            option2 = None$.MODULE$;
        } else {
            Option<Seconds> freshnessLifetime = this.calculateFreshnessFromSMaxAge(request2, response).orElse(new Serializable(this, request2, response){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FreshnessCalculator $outer;
                private final CacheRequest request$1;
                private final CacheResponse response$1;

                public final Option<Seconds> apply() {
                    return this.$outer.calculateFreshnessFromMaxAge(this.request$1, this.response$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.request$1 = request$1;
                    this.response$1 = response$1;
                }
            }).orElse(new Serializable(this, request2, response){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FreshnessCalculator $outer;
                private final CacheRequest request$1;
                private final CacheResponse response$1;

                public final Option<Seconds> apply() {
                    return this.$outer.calculateFreshnessFromExpires(this.request$1, this.response$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.request$1 = request$1;
                    this.response$1 = response$1;
                }
            }).orElse(new Serializable(this, request2, response){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FreshnessCalculator $outer;
                private final CacheRequest request$1;
                private final CacheResponse response$1;

                public final Option<Seconds> apply() {
                    return this.$outer.calculateFreshnessFromHeuristic(this.request$1, this.response$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.request$1 = request$1;
                    this.response$1 = response$1;
                }
            });
            this.com$typesafe$play$cachecontrol$FreshnessCalculator$$logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"calculateFreshnessLifetime: freshnessLifetime = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{freshnessLifetime})));
            option2 = freshnessLifetime;
        }
        None$ maybeResult = option2;
        Seconds result2 = maybeResult.getOrElse(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seconds apply() {
                return Seconds.seconds(0);
            }
        });
        this.com$typesafe$play$cachecontrol$FreshnessCalculator$$logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"calculateFreshnessLifetime: result = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{result2})));
        return result2;
    }

    public boolean isFreshnessInformationInvalid(CacheRequest request2, CacheResponse response) {
        boolean bl;
        Map<HeaderName, Seq<String>> responseHeaders = response.headers();
        scala.collection.immutable.Seq<CacheDirective> directives2 = response.directives();
        if (responseHeaders.get(HeaderNames$.MODULE$.Expires()).exists(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<String> x$1) {
                return x$1.size() > 1;
            }
        })) {
            this.com$typesafe$play$cachecontrol$FreshnessCalculator$$logger().debug("isFreshnessInformationInvalid: duplicate Expires headers found, returning true");
            bl = true;
        } else if (this.containsDuplicates(directives2, this.containsDuplicates$default$2())) {
            this.com$typesafe$play$cachecontrol$FreshnessCalculator$$logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"isFreshnessInformationInvalid: duplicate directives found in ", ", returning true"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{directives2})));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean containsDuplicates(Seq<CacheDirective> directives2, Set<Class<?>> seen) {
        boolean bl;
        block2: {
            Seq<CacheDirective> seq2;
            while ((seq2 = directives2) instanceof $colon$colon) {
                $colon$colon $colon$colon = ($colon$colon)seq2;
                CacheDirective x = (CacheDirective)$colon$colon.head();
                List xs = $colon$colon.tl$1();
                if (seen.contains(x.getClass())) {
                    bl = true;
                    break block2;
                }
                seen = (Set)seen.$plus(x.getClass());
                directives2 = xs;
            }
            bl = false;
        }
        return bl;
    }

    private Set<Class<?>> containsDuplicates$default$2() {
        return (Set)Predef$.MODULE$.Set().apply(Nil$.MODULE$);
    }

    public Option<Seconds> calculateFreshnessFromSMaxAge(CacheRequest request2, CacheResponse response) {
        return this.cache.isShared() ? CacheDirectives$.MODULE$.sMaxAge(response.directives()).map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seconds apply(CacheDirectives.SMaxAge x$2) {
                return x$2.delta();
            }
        }) : None$.MODULE$;
    }

    public Option<Seconds> calculateFreshnessFromMaxAge(CacheRequest request2, CacheResponse response) {
        return CacheDirectives$.MODULE$.maxAge(response.directives()).map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seconds apply(CacheDirectives.MaxAge x$3) {
                return x$3.delta();
            }
        });
    }

    public Option<Seconds> calculateFreshnessFromExpires(CacheRequest request2, CacheResponse response) {
        Map<HeaderName, Seq<String>> headers = response.headers();
        return headers.get(HeaderNames$.MODULE$.Expires()).flatMap(new Serializable(this, headers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FreshnessCalculator $outer;
            private final Map headers$1;

            public final Option<Seconds> apply(Seq<String> expiresList) {
                Option option2;
                String dateString = (String)((IterableLike)((Object)this.headers$1.getOrElse(HeaderNames$.MODULE$.Date(), new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply() {
                        throw new RuntimeException("No Date header found!");
                    }
                }))).head();
                try {
                    DateTime expires = HttpDate$.MODULE$.parse((String)expiresList.head());
                    DateTime date = HttpDate$.MODULE$.parse(dateString);
                    Seconds expiresDuration = HttpDate$.MODULE$.diff(date, expires);
                    this.$outer.com$typesafe$play$cachecontrol$FreshnessCalculator$$logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"calculateFreshnessFromExpires: expiresDuration = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{expiresDuration})));
                    option2 = new Some<Seconds>(expiresDuration);
                }
                catch (Exception exception) {
                    this.$outer.com$typesafe$play$cachecontrol$FreshnessCalculator$$logger().error("calculateFreshnessFromExpires: HTTP date parsing failed", exception);
                    option2 = None$.MODULE$;
                }
                return option2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.headers$1 = headers$1;
            }
        });
    }

    public Option<Seconds> calculateFreshnessFromHeuristic(CacheRequest request2, CacheResponse response) {
        return this.cache.calculateFreshnessFromHeuristic(request2, response);
    }

    public Option<Seconds> unapplySeq(Seq<CacheDirective> directives2) {
        Option option2;
        $colon$colon $colon$colon;
        CacheDirective cacheDirective;
        Seq<CacheDirective> seq2 = directives2;
        if (seq2 instanceof $colon$colon && (cacheDirective = (CacheDirective)($colon$colon = ($colon$colon)seq2).head()) instanceof CacheDirectives.SMaxAge) {
            CacheDirectives.SMaxAge sMaxAge2 = (CacheDirectives.SMaxAge)cacheDirective;
            Seconds delta2 = sMaxAge2.delta();
            option2 = new Some<Seconds>(delta2);
        } else {
            option2 = None$.MODULE$;
        }
        return option2;
    }

    public FreshnessCalculator(Cache cache) {
        this.cache = cache;
        this.com$typesafe$play$cachecontrol$FreshnessCalculator$$logger = LoggerFactory.getLogger("com.typesafe.cachecontrol.FreshnessCalculator");
    }
}

