/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.play.cachecontrol;

import com.typesafe.play.cachecontrol.CacheControlException;
import com.typesafe.play.cachecontrol.CacheRequest;
import com.typesafe.play.cachecontrol.CurrentAgeCalculator$;
import com.typesafe.play.cachecontrol.HeaderName;
import com.typesafe.play.cachecontrol.HeaderNames$;
import com.typesafe.play.cachecontrol.HttpDate$;
import com.typesafe.play.cachecontrol.StoredResponse;
import org.joda.time.DateTime;
import org.joda.time.Seconds;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001A4A!\u0001\u0002\u0001\u0017\t!2)\u001e:sK:$\u0018iZ3DC2\u001cW\u000f\\1u_JT!a\u0001\u0003\u0002\u0019\r\f7\r[3d_:$(o\u001c7\u000b\u0005\u00151\u0011\u0001\u00029mCfT!a\u0002\u0005\u0002\u0011QL\b/Z:bM\u0016T\u0011!C\u0001\u0004G>l7\u0001A\n\u0003\u00011\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0003\u0011\u0015A\u0002\u0001\"\u0001\u001a\u0003M\u0019\u0017\r\\2vY\u0006$XmQ;se\u0016tG/Q4f)\u0015QB%\u000b\u00184!\tY\"%D\u0001\u001d\u0015\tib$\u0001\u0003uS6,'BA\u0010!\u0003\u0011Qw\u000eZ1\u000b\u0003\u0005\n1a\u001c:h\u0013\t\u0019CDA\u0004TK\u000e|g\u000eZ:\t\u000b\u0015:\u0002\u0019\u0001\u0014\u0002\u000fI,\u0017/^3tiB\u0011acJ\u0005\u0003Q\t\u0011AbQ1dQ\u0016\u0014V-];fgRDQAK\fA\u0002-\n\u0001B]3ta>t7/\u001a\t\u0003-1J!!\f\u0002\u0003\u001dM#xN]3e%\u0016\u001c\bo\u001c8tK\")qf\u0006a\u0001a\u0005Y!/Z9vKN$H+[7f!\tY\u0012'\u0003\u000239\tAA)\u0019;f)&lW\rC\u00035/\u0001\u0007\u0001'\u0001\u0007sKN\u0004xN\\:f)&lW\rC\u0003\u0019\u0001\u0011\u0005a\u0007F\u0003\u001boI#V\u000bC\u00039k\u0001\u0007\u0011(A\u0004iK\u0006$WM]:\u0011\tij\u0004i\u0011\b\u0003\u001bmJ!\u0001\u0010\b\u0002\rA\u0013X\rZ3g\u0013\tqtHA\u0002NCBT!\u0001\u0010\b\u0011\u0005Y\t\u0015B\u0001\"\u0003\u0005)AU-\u00193fe:\u000bW.\u001a\t\u0004\t2{eBA#K\u001d\t1\u0015*D\u0001H\u0015\tA%\"\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u00111JD\u0001\ba\u0006\u001c7.Y4f\u0013\tieJA\u0002TKFT!a\u0013\b\u0011\u0005i\u0002\u0016BA)@\u0005\u0019\u0019FO]5oO\")1+\u000ea\u0001a\u0005\u0019an\\<\t\u000b=*\u0004\u0019\u0001\u0019\t\u000bQ*\u0004\u0019\u0001\u0019\t\u000b]\u0003A\u0011\u0001-\u0002#\r\fGnY;mCR,\u0017iZ3WC2,X\r\u0006\u0002\u001b3\")\u0001H\u0016a\u0001s!)1\f\u0001C\u00019\u0006\u00112-\u00197dk2\fG/\u001a#bi\u00164\u0016\r\\;f)\t\u0001T\fC\u000395\u0002\u0007\u0011hB\u0003`\u0005!\u0005\u0001-\u0001\u000bDkJ\u0014XM\u001c;BO\u0016\u001c\u0015\r\\2vY\u0006$xN\u001d\t\u0003-\u00054Q!\u0001\u0002\t\u0002\t\u001c\"!\u0019\u0007\t\u000bM\tG\u0011\u00013\u0015\u0003\u0001DqAZ1C\u0002\u0013%q-\u0001\u0004m_\u001e<WM]\u000b\u0002QB\u0011\u0011\u000e\\\u0007\u0002U*\u00111\u000eI\u0001\u0006g24GG[\u0005\u0003[*\u0014a\u0001T8hO\u0016\u0014\bBB8bA\u0003%\u0001.A\u0004m_\u001e<WM\u001d\u0011")
public class CurrentAgeCalculator {
    public Seconds calculateCurrentAge(CacheRequest request2, StoredResponse response, DateTime requestTime, DateTime responseTime) {
        return this.calculateCurrentAge(response.headers(), HttpDate$.MODULE$.now(), requestTime, responseTime);
    }

    public Seconds calculateCurrentAge(Map<HeaderName, Seq<String>> headers, DateTime now, DateTime requestTime, DateTime responseTime) {
        if (CurrentAgeCalculator$.MODULE$.com$typesafe$play$cachecontrol$CurrentAgeCalculator$$logger().isTraceEnabled()) {
            CurrentAgeCalculator$.MODULE$.com$typesafe$play$cachecontrol$CurrentAgeCalculator$$logger().trace(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"calculateCurrentAge(headers: ", ", now: ", ", requestTime: ", ", responseTime: ", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{headers, now, requestTime, responseTime})));
        }
        Seconds ageValue = this.calculateAgeValue(headers);
        DateTime dateValue = this.calculateDateValue(headers);
        Seconds apparentAge = responseTime.isAfter(dateValue) ? Seconds.secondsBetween(dateValue, responseTime) : Seconds.seconds(0);
        Seconds responseDelay = Seconds.secondsBetween(requestTime, responseTime);
        Seconds correctedAgeValue = ageValue.plus(responseDelay);
        int a2 = Math.max(apparentAge.getSeconds(), correctedAgeValue.getSeconds());
        Seconds correctedInitialAge = Seconds.seconds(a2);
        Seconds residentTime = Seconds.secondsBetween(responseTime, now);
        Seconds currentAge = correctedInitialAge.plus(residentTime);
        if (CurrentAgeCalculator$.MODULE$.com$typesafe$play$cachecontrol$CurrentAgeCalculator$$logger().isTraceEnabled()) {
            CurrentAgeCalculator$.MODULE$.com$typesafe$play$cachecontrol$CurrentAgeCalculator$$logger().trace(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"calculateCurrentAge: currentAge = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{currentAge})));
        }
        return currentAge;
    }

    public Seconds calculateAgeValue(Map<HeaderName, Seq<String>> headers) {
        return headers.get(HeaderNames$.MODULE$.Age()).flatMap(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(Seq<String> x$1) {
                return x$1.headOption();
            }
        }).map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seconds apply(String age) {
                return Seconds.seconds(new StringOps(Predef$.MODULE$.augmentString(age)).toInt());
            }
        }).getOrElse(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seconds apply() {
                return Seconds.seconds(0);
            }
        });
    }

    public DateTime calculateDateValue(Map<HeaderName, Seq<String>> headers) {
        Option<DateTime> result2 = headers.get(HeaderNames$.MODULE$.Date()).flatMap(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<DateTime> apply(Seq<String> dateValues) {
                return dateValues.headOption().map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DateTime apply(String firstDateValue) {
                        return HttpDate$.MODULE$.parse(firstDateValue);
                    }
                });
            }
        });
        return (DateTime)((Object)result2.getOrElse(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                String msg = "Date header is required for age calculation! (see RFC7231, 7.1.1.2)";
                throw new CacheControlException(msg);
            }
        }));
    }
}

