/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.Container;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveContext;
import com.typesafe.config.impl.ResolveResult;
import com.typesafe.config.impl.SimpleConfigObject;
import com.typesafe.config.impl.SubstitutionExpression;

final class ResolveSource {
    final AbstractConfigObject root;
    final Node<Container> pathFromRoot;

    ResolveSource(AbstractConfigObject root2, Node<Container> pathFromRoot) {
        this.root = root2;
        this.pathFromRoot = pathFromRoot;
    }

    ResolveSource(AbstractConfigObject root2) {
        this.root = root2;
        this.pathFromRoot = null;
    }

    private AbstractConfigObject rootMustBeObj(Container value2) {
        if (value2 instanceof AbstractConfigObject) {
            return (AbstractConfigObject)value2;
        }
        return SimpleConfigObject.empty();
    }

    private static ResultWithPath findInObject(AbstractConfigObject obj, ResolveContext context, Path path2) throws AbstractConfigValue.NotPossibleToResolve {
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace("*** finding '" + path2 + "' in " + obj);
        }
        Path restriction = context.restrictToChild();
        ResolveResult<? extends AbstractConfigValue> partiallyResolved = context.restrict(path2).resolve(obj, new ResolveSource(obj));
        ResolveContext newContext = partiallyResolved.context.restrict(restriction);
        if (partiallyResolved.value instanceof AbstractConfigObject) {
            ValueWithPath pair2 = ResolveSource.findInObject((AbstractConfigObject)partiallyResolved.value, path2);
            return new ResultWithPath(ResolveResult.make(newContext, pair2.value), pair2.pathFromRoot);
        }
        throw new ConfigException.BugOrBroken("resolved object to non-object " + obj + " to " + partiallyResolved);
    }

    private static ValueWithPath findInObject(AbstractConfigObject obj, Path path2) {
        try {
            return ResolveSource.findInObject(obj, path2, null);
        }
        catch (ConfigException.NotResolved e) {
            throw ConfigImpl.improveNotResolved(path2, e);
        }
    }

    private static ValueWithPath findInObject(AbstractConfigObject obj, Path path2, Node<Container> parents2) {
        Node<Container> newParents;
        String key = path2.first();
        Path next2 = path2.remainder();
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace("*** looking up '" + key + "' in " + obj);
        }
        AbstractConfigValue v = obj.attemptPeekWithPartialResolve(key);
        Node<Container> node4 = newParents = parents2 == null ? new Node<Container>(obj) : parents2.prepend(obj);
        if (next2 == null) {
            return new ValueWithPath(v, newParents);
        }
        if (v instanceof AbstractConfigObject) {
            return ResolveSource.findInObject((AbstractConfigObject)v, next2, newParents);
        }
        return new ValueWithPath(null, newParents);
    }

    ResultWithPath lookupSubst(ResolveContext context, SubstitutionExpression subst2, int prefixLength) throws AbstractConfigValue.NotPossibleToResolve {
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(context.depth(), "searching for " + subst2);
        }
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(context.depth(), subst2 + " - looking up relative to file it occurred in");
        }
        ResultWithPath result2 = ResolveSource.findInObject(this.root, context, subst2.path());
        if (result2.result.value == null) {
            Path unprefixed = subst2.path().subPath(prefixLength);
            if (prefixLength > 0) {
                if (ConfigImpl.traceSubstitutionsEnabled()) {
                    ConfigImpl.trace(result2.result.context.depth(), unprefixed + " - looking up relative to parent file");
                }
                result2 = ResolveSource.findInObject(this.root, result2.result.context, unprefixed);
            }
            if (result2.result.value == null && result2.result.context.options().getUseSystemEnvironment()) {
                if (ConfigImpl.traceSubstitutionsEnabled()) {
                    ConfigImpl.trace(result2.result.context.depth(), unprefixed + " - looking up in system environment");
                }
                result2 = ResolveSource.findInObject(ConfigImpl.envVariablesAsConfigObject(), context, unprefixed);
            }
        }
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(result2.result.context.depth(), "resolved to " + result2);
        }
        return result2;
    }

    ResolveSource pushParent(Container parent2) {
        if (parent2 == null) {
            throw new ConfigException.BugOrBroken("can't push null parent");
        }
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace("pushing parent " + parent2 + " ==root " + (parent2 == this.root) + " onto " + this);
        }
        if (this.pathFromRoot == null) {
            if (parent2 == this.root) {
                return new ResolveSource(this.root, new Node<Container>(parent2));
            }
            if (ConfigImpl.traceSubstitutionsEnabled() && this.root.hasDescendant((AbstractConfigValue)((Object)parent2))) {
                ConfigImpl.trace("***** BUG ***** tried to push parent " + parent2 + " without having a path to it in " + this);
            }
            return this;
        }
        Container parentParent = this.pathFromRoot.head();
        if (ConfigImpl.traceSubstitutionsEnabled() && parentParent != null && !parentParent.hasDescendant((AbstractConfigValue)((Object)parent2))) {
            ConfigImpl.trace("***** BUG ***** trying to push non-child of " + parentParent + ", non-child was " + parent2);
        }
        return new ResolveSource(this.root, this.pathFromRoot.prepend(parent2));
    }

    ResolveSource resetParents() {
        if (this.pathFromRoot == null) {
            return this;
        }
        return new ResolveSource(this.root);
    }

    private static Node<Container> replace(Node<Container> list2, Container old, AbstractConfigValue replacement) {
        Container parent2;
        Container child = list2.head();
        if (child != old) {
            throw new ConfigException.BugOrBroken("Can only replace() the top node we're resolving; had " + child + " on top and tried to replace " + old + " overall list was " + list2);
        }
        Container container = parent2 = list2.tail() == null ? null : list2.tail().head();
        if (replacement == null || !(replacement instanceof Container)) {
            if (parent2 == null) {
                return null;
            }
            AbstractConfigValue newParent = parent2.replaceChild((AbstractConfigValue)((Object)old), null);
            return ResolveSource.replace(list2.tail(), parent2, newParent);
        }
        if (parent2 == null) {
            return new Node<Container>((Container)((Object)replacement));
        }
        AbstractConfigValue newParent = parent2.replaceChild((AbstractConfigValue)((Object)old), replacement);
        Node<Container> newTail = ResolveSource.replace(list2.tail(), parent2, newParent);
        if (newTail != null) {
            return newTail.prepend((Container)((Object)replacement));
        }
        return new Node<Container>((Container)((Object)replacement));
    }

    ResolveSource replaceCurrentParent(Container old, Container replacement) {
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace("replaceCurrentParent old " + old + "@" + System.identityHashCode(old) + " replacement " + replacement + "@" + System.identityHashCode(old) + " in " + this);
        }
        if (old == replacement) {
            return this;
        }
        if (this.pathFromRoot != null) {
            Node<Container> newPath = ResolveSource.replace(this.pathFromRoot, old, (AbstractConfigValue)((Object)replacement));
            if (ConfigImpl.traceSubstitutionsEnabled()) {
                ConfigImpl.trace("replaced " + old + " with " + replacement + " in " + this);
                ConfigImpl.trace("path was: " + this.pathFromRoot + " is now " + newPath);
            }
            if (newPath != null) {
                return new ResolveSource((AbstractConfigObject)newPath.last(), newPath);
            }
            return new ResolveSource(SimpleConfigObject.empty());
        }
        if (old == this.root) {
            return new ResolveSource(this.rootMustBeObj(replacement));
        }
        throw new ConfigException.BugOrBroken("attempt to replace root " + this.root + " with " + replacement);
    }

    ResolveSource replaceWithinCurrentParent(AbstractConfigValue old, AbstractConfigValue replacement) {
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace("replaceWithinCurrentParent old " + old + "@" + System.identityHashCode(old) + " replacement " + replacement + "@" + System.identityHashCode(old) + " in " + this);
        }
        if (old == replacement) {
            return this;
        }
        if (this.pathFromRoot != null) {
            Container parent2;
            AbstractConfigValue newParent = (parent2 = this.pathFromRoot.head()).replaceChild(old, replacement);
            return this.replaceCurrentParent(parent2, newParent instanceof Container ? (Container)((Object)newParent) : null);
        }
        if (old == this.root && replacement instanceof Container) {
            return new ResolveSource(this.rootMustBeObj((Container)((Object)replacement)));
        }
        throw new ConfigException.BugOrBroken("replace in parent not possible " + old + " with " + replacement + " in " + this);
    }

    public String toString() {
        return "ResolveSource(root=" + this.root + ", pathFromRoot=" + this.pathFromRoot + ")";
    }

    static final class ResultWithPath {
        final ResolveResult<? extends AbstractConfigValue> result;
        final Node<Container> pathFromRoot;

        ResultWithPath(ResolveResult<? extends AbstractConfigValue> result2, Node<Container> pathFromRoot) {
            this.result = result2;
            this.pathFromRoot = pathFromRoot;
        }

        public String toString() {
            return "ResultWithPath(result=" + this.result + ", pathFromRoot=" + this.pathFromRoot + ")";
        }
    }

    static final class ValueWithPath {
        final AbstractConfigValue value;
        final Node<Container> pathFromRoot;

        ValueWithPath(AbstractConfigValue value2, Node<Container> pathFromRoot) {
            this.value = value2;
            this.pathFromRoot = pathFromRoot;
        }

        public String toString() {
            return "ValueWithPath(value=" + this.value + ", pathFromRoot=" + this.pathFromRoot + ")";
        }
    }

    static final class Node<T> {
        final T value;
        final Node<T> next;

        Node(T value2, Node<T> next2) {
            this.value = value2;
            this.next = next2;
        }

        Node(T value2) {
            this(value2, null);
        }

        Node<T> prepend(T value2) {
            return new Node<T>(value2, this);
        }

        T head() {
            return this.value;
        }

        Node<T> tail() {
            return this.next;
        }

        T last() {
            Node<T> i = this;
            while (i.next != null) {
                i = i.next;
            }
            return i.value;
        }

        Node<T> reverse() {
            if (this.next == null) {
                return this;
            }
            Node<T> reversed2 = new Node<T>(this.value);
            Node<T> i = this.next;
            while (i != null) {
                reversed2 = reversed2.prepend(i.value);
                i = i.next;
            }
            return reversed2;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            Node<T> toAppendValue = this.reverse();
            while (toAppendValue != null) {
                sb.append(toAppendValue.value.toString());
                if (toAppendValue.next != null) {
                    sb.append(" <= ");
                }
                toAppendValue = toAppendValue.next;
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

