/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.impl.AbstractConfigNode;
import com.typesafe.config.impl.AbstractConfigNodeValue;
import com.typesafe.config.impl.ConfigNodeComplexValue;
import com.typesafe.config.impl.ConfigNodeField;
import com.typesafe.config.impl.ConfigNodeInclude;
import com.typesafe.config.impl.ConfigNodePath;
import com.typesafe.config.impl.ConfigNodeSingleToken;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.PathParser;
import com.typesafe.config.impl.Token;
import com.typesafe.config.impl.Tokens;
import java.util.ArrayList;
import java.util.Collection;

final class ConfigNodeObject
extends ConfigNodeComplexValue {
    ConfigNodeObject(Collection<AbstractConfigNode> children2) {
        super(children2);
    }

    @Override
    protected ConfigNodeObject newNode(Collection<AbstractConfigNode> nodes2) {
        return new ConfigNodeObject(nodes2);
    }

    public boolean hasValue(Path desiredPath) {
        for (AbstractConfigNode node4 : this.children) {
            Path remainingPath;
            ConfigNodeObject obj;
            if (!(node4 instanceof ConfigNodeField)) continue;
            ConfigNodeField field2 = (ConfigNodeField)node4;
            Path key = field2.path().value();
            if (key.equals(desiredPath) || key.startsWith(desiredPath)) {
                return true;
            }
            if (!desiredPath.startsWith(key) || !(field2.value() instanceof ConfigNodeObject) || !(obj = (ConfigNodeObject)field2.value()).hasValue(remainingPath = desiredPath.subPath(key.length()))) continue;
            return true;
        }
        return false;
    }

    protected ConfigNodeObject changeValueOnPath(Path desiredPath, AbstractConfigNodeValue value2, ConfigSyntax flavor) {
        ArrayList<AbstractConfigNode> childrenCopy = new ArrayList<AbstractConfigNode>(this.children);
        boolean seenNonMatching = false;
        AbstractConfigNodeValue valueCopy = value2;
        for (int i = childrenCopy.size() - 1; i >= 0; --i) {
            if (childrenCopy.get(i) instanceof ConfigNodeSingleToken) {
                Token t = ((ConfigNodeSingleToken)childrenCopy.get(i)).token();
                if (flavor != ConfigSyntax.JSON || seenNonMatching || t != Tokens.COMMA) continue;
                childrenCopy.remove(i);
                continue;
            }
            if (!(childrenCopy.get(i) instanceof ConfigNodeField)) continue;
            ConfigNodeField node4 = (ConfigNodeField)childrenCopy.get(i);
            Path key = node4.path().value();
            if (valueCopy == null && key.equals(desiredPath) || key.startsWith(desiredPath) && !key.equals(desiredPath)) {
                Token t;
                childrenCopy.remove(i);
                for (int j = i; j < childrenCopy.size() && childrenCopy.get(j) instanceof ConfigNodeSingleToken && (Tokens.isIgnoredWhitespace(t = ((ConfigNodeSingleToken)childrenCopy.get(j)).token()) || t == Tokens.COMMA); ++j) {
                    childrenCopy.remove(j);
                    --j;
                }
                continue;
            }
            if (key.equals(desiredPath)) {
                seenNonMatching = true;
                AbstractConfigNode before = i - 1 > 0 ? childrenCopy.get(i - 1) : null;
                AbstractConfigNodeValue indentedValue = value2 instanceof ConfigNodeComplexValue && before instanceof ConfigNodeSingleToken && Tokens.isIgnoredWhitespace(((ConfigNodeSingleToken)before).token()) ? ((ConfigNodeComplexValue)value2).indentText(before) : value2;
                childrenCopy.set(i, node4.replaceValue(indentedValue));
                valueCopy = null;
                continue;
            }
            if (desiredPath.startsWith(key)) {
                seenNonMatching = true;
                if (!(node4.value() instanceof ConfigNodeObject)) continue;
                Path remainingPath = desiredPath.subPath(key.length());
                childrenCopy.set(i, node4.replaceValue(((ConfigNodeObject)node4.value()).changeValueOnPath(remainingPath, valueCopy, flavor)));
                if (valueCopy == null || node4.equals(this.children.get(i))) continue;
                valueCopy = null;
                continue;
            }
            seenNonMatching = true;
        }
        return new ConfigNodeObject(childrenCopy);
    }

    public ConfigNodeObject setValueOnPath(String desiredPath, AbstractConfigNodeValue value2) {
        return this.setValueOnPath(desiredPath, value2, ConfigSyntax.CONF);
    }

    public ConfigNodeObject setValueOnPath(String desiredPath, AbstractConfigNodeValue value2, ConfigSyntax flavor) {
        ConfigNodePath path2 = PathParser.parsePathNode(desiredPath, flavor);
        return this.setValueOnPath(path2, value2, flavor);
    }

    private ConfigNodeObject setValueOnPath(ConfigNodePath desiredPath, AbstractConfigNodeValue value2, ConfigSyntax flavor) {
        ConfigNodeObject node4 = this.changeValueOnPath(desiredPath.value(), value2, flavor);
        if (!node4.hasValue(desiredPath.value())) {
            return node4.addValueOnPath(desiredPath, value2, flavor);
        }
        return node4;
    }

    private Collection<AbstractConfigNode> indentation() {
        boolean seenNewLine = false;
        ArrayList<AbstractConfigNode> indentation2 = new ArrayList<AbstractConfigNode>();
        if (this.children.isEmpty()) {
            return indentation2;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (!seenNewLine) {
                if (!(this.children.get(i) instanceof ConfigNodeSingleToken) || !Tokens.isNewline(((ConfigNodeSingleToken)this.children.get(i)).token())) continue;
                seenNewLine = true;
                indentation2.add(new ConfigNodeSingleToken(Tokens.newLine(null)));
                continue;
            }
            if (!(this.children.get(i) instanceof ConfigNodeSingleToken) || !Tokens.isIgnoredWhitespace(((ConfigNodeSingleToken)this.children.get(i)).token()) || i + 1 >= this.children.size() || !(this.children.get(i + 1) instanceof ConfigNodeField) && !(this.children.get(i + 1) instanceof ConfigNodeInclude)) continue;
            indentation2.add((AbstractConfigNode)this.children.get(i));
            return indentation2;
        }
        if (indentation2.isEmpty()) {
            indentation2.add(new ConfigNodeSingleToken(Tokens.newIgnoredWhitespace(null, " ")));
        } else {
            AbstractConfigNode last2 = (AbstractConfigNode)this.children.get(this.children.size() - 1);
            if (last2 instanceof ConfigNodeSingleToken && ((ConfigNodeSingleToken)last2).token() == Tokens.CLOSE_CURLY) {
                AbstractConfigNode beforeLast = (AbstractConfigNode)this.children.get(this.children.size() - 2);
                String indent2 = "";
                if (beforeLast instanceof ConfigNodeSingleToken && Tokens.isIgnoredWhitespace(((ConfigNodeSingleToken)beforeLast).token())) {
                    indent2 = ((ConfigNodeSingleToken)beforeLast).token().tokenText();
                }
                indent2 = indent2 + "  ";
                indentation2.add(new ConfigNodeSingleToken(Tokens.newIgnoredWhitespace(null, indent2)));
                return indentation2;
            }
        }
        return indentation2;
    }

    protected ConfigNodeObject addValueOnPath(ConfigNodePath desiredPath, AbstractConfigNodeValue value2, ConfigSyntax flavor) {
        boolean sameLine;
        Path path2 = desiredPath.value();
        ArrayList<AbstractConfigNode> childrenCopy = new ArrayList<AbstractConfigNode>(this.children);
        ArrayList<AbstractConfigNode> indentation2 = new ArrayList<AbstractConfigNode>(this.indentation());
        AbstractConfigNodeValue indentedValue = value2 instanceof ConfigNodeComplexValue && !indentation2.isEmpty() ? ((ConfigNodeComplexValue)value2).indentText(indentation2.get(indentation2.size() - 1)) : value2;
        boolean bl = sameLine = indentation2.size() <= 0 || !(indentation2.get(0) instanceof ConfigNodeSingleToken) || !Tokens.isNewline(((ConfigNodeSingleToken)indentation2.get(0)).token());
        if (path2.length() > 1) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                ConfigNodeField node4;
                Path key;
                if (!(this.children.get(i) instanceof ConfigNodeField) || !path2.startsWith(key = (node4 = (ConfigNodeField)this.children.get(i)).path().value()) || !(node4.value() instanceof ConfigNodeObject)) continue;
                ConfigNodePath remainingPath = desiredPath.subPath(key.length());
                ConfigNodeObject newValue = (ConfigNodeObject)node4.value();
                childrenCopy.set(i, node4.replaceValue(newValue.addValueOnPath(remainingPath, value2, flavor)));
                return new ConfigNodeObject(childrenCopy);
            }
        }
        boolean startsWithBrace = !this.children.isEmpty() && this.children.get(0) instanceof ConfigNodeSingleToken && ((ConfigNodeSingleToken)this.children.get(0)).token() == Tokens.OPEN_CURLY;
        ArrayList<AbstractConfigNode> newNodes = new ArrayList<AbstractConfigNode>();
        newNodes.addAll(indentation2);
        newNodes.add(desiredPath.first());
        newNodes.add(new ConfigNodeSingleToken(Tokens.newIgnoredWhitespace(null, " ")));
        newNodes.add(new ConfigNodeSingleToken(Tokens.COLON));
        newNodes.add(new ConfigNodeSingleToken(Tokens.newIgnoredWhitespace(null, " ")));
        if (path2.length() == 1) {
            newNodes.add(indentedValue);
        } else {
            ArrayList<AbstractConfigNode> newObjectNodes = new ArrayList<AbstractConfigNode>();
            newObjectNodes.add(new ConfigNodeSingleToken(Tokens.OPEN_CURLY));
            if (indentation2.isEmpty()) {
                newObjectNodes.add(new ConfigNodeSingleToken(Tokens.newLine(null)));
            }
            newObjectNodes.addAll(indentation2);
            newObjectNodes.add(new ConfigNodeSingleToken(Tokens.CLOSE_CURLY));
            ConfigNodeObject newObject = new ConfigNodeObject(newObjectNodes);
            newNodes.add(newObject.addValueOnPath(desiredPath.subPath(1), indentedValue, flavor));
        }
        if (flavor == ConfigSyntax.JSON || startsWithBrace || sameLine) {
            for (int i = childrenCopy.size() - 1; i >= 0; --i) {
                if ((flavor == ConfigSyntax.JSON || sameLine) && childrenCopy.get(i) instanceof ConfigNodeField) {
                    if (i + 1 < childrenCopy.size() && childrenCopy.get(i + 1) instanceof ConfigNodeSingleToken && ((ConfigNodeSingleToken)childrenCopy.get(i + 1)).token() == Tokens.COMMA) break;
                    childrenCopy.add(i + 1, new ConfigNodeSingleToken(Tokens.COMMA));
                    break;
                }
                if (!startsWithBrace || !(childrenCopy.get(i) instanceof ConfigNodeSingleToken) || ((ConfigNodeSingleToken)childrenCopy.get((int)i)).token != Tokens.CLOSE_CURLY) continue;
                AbstractConfigNode previous2 = childrenCopy.get(i - 1);
                if (previous2 instanceof ConfigNodeSingleToken && Tokens.isNewline(((ConfigNodeSingleToken)previous2).token())) {
                    childrenCopy.add(i - 1, new ConfigNodeField(newNodes));
                    --i;
                    continue;
                }
                if (previous2 instanceof ConfigNodeSingleToken && Tokens.isIgnoredWhitespace(((ConfigNodeSingleToken)previous2).token())) {
                    AbstractConfigNode beforePrevious = childrenCopy.get(i - 2);
                    if (sameLine) {
                        childrenCopy.add(i - 1, new ConfigNodeField(newNodes));
                        --i;
                        continue;
                    }
                    if (beforePrevious instanceof ConfigNodeSingleToken && Tokens.isNewline(((ConfigNodeSingleToken)beforePrevious).token())) {
                        childrenCopy.add(i - 2, new ConfigNodeField(newNodes));
                        i -= 2;
                        continue;
                    }
                    childrenCopy.add(i, new ConfigNodeField(newNodes));
                    continue;
                }
                childrenCopy.add(i, new ConfigNodeField(newNodes));
            }
        }
        if (!startsWithBrace) {
            if (!childrenCopy.isEmpty() && childrenCopy.get(childrenCopy.size() - 1) instanceof ConfigNodeSingleToken && Tokens.isNewline(((ConfigNodeSingleToken)childrenCopy.get(childrenCopy.size() - 1)).token())) {
                childrenCopy.add(childrenCopy.size() - 1, new ConfigNodeField(newNodes));
            } else {
                childrenCopy.add(new ConfigNodeField(newNodes));
            }
        }
        return new ConfigNodeObject(childrenCopy);
    }

    public ConfigNodeObject removeValueOnPath(String desiredPath, ConfigSyntax flavor) {
        Path path2 = PathParser.parsePathNode(desiredPath, flavor).value();
        return this.changeValueOnPath(path2, null, flavor);
    }
}

