/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonValue;

final class DocumentHelper {
    private DocumentHelper() {
    }

    static void putIfTrue(BsonDocument command, String key, boolean condition) {
        if (condition) {
            command.put(key, BsonBoolean.TRUE);
        }
    }

    static void putIfFalse(BsonDocument command, String key, boolean condition) {
        if (!condition) {
            command.put(key, BsonBoolean.FALSE);
        }
    }

    static void putIfNotNullOrEmpty(BsonDocument command, String key, BsonDocument documentValue) {
        if (documentValue != null && !documentValue.isEmpty()) {
            command.put(key, documentValue);
        }
    }

    static void putIfNotNull(BsonDocument command, String key, BsonValue value2) {
        if (value2 != null) {
            command.put(key, value2);
        }
    }

    static void putIfNotZero(BsonDocument command, String key, int value2) {
        if (value2 != 0) {
            command.put(key, new BsonInt32(value2));
        }
    }

    static void putIfNotZero(BsonDocument command, String key, long value2) {
        if (value2 != 0L) {
            command.put(key, new BsonInt64(value2));
        }
    }
}

