/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.DuplicateKeyException;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.bulk.IndexRequest;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.Connection;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.operation.IndexHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.DocumentHelper;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.WriteOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;

@Deprecated
public class CreateIndexesOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final MongoNamespace namespace;
    private final List<IndexRequest> requests;
    private final WriteConcern writeConcern;
    private long maxTimeMS;

    @Deprecated
    public CreateIndexesOperation(MongoNamespace namespace, List<IndexRequest> requests) {
        this(namespace, requests, null);
    }

    public CreateIndexesOperation(MongoNamespace namespace, List<IndexRequest> requests, WriteConcern writeConcern) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.requests = Assertions.notNull("indexRequests", requests);
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public List<IndexRequest> getRequests() {
        return this.requests;
    }

    public List<String> getIndexNames() {
        ArrayList<String> indexNames = new ArrayList<String>(this.requests.size());
        for (IndexRequest request2 : this.requests) {
            if (request2.getName() != null) {
                indexNames.add(request2.getName());
                continue;
            }
            indexNames.add(IndexHelper.generateIndexName(request2.getKeys()));
        }
        return indexNames;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public CreateIndexesOperation maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Assertions.isTrueArgument("maxTime >= 0", maxTime >= 0L);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public Void execute(final WriteBinding binding) {
        return OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnection<Void>(){

            @Override
            public Void call(Connection connection) {
                try {
                    OperationHelper.validateIndexRequestCollations(connection, CreateIndexesOperation.this.requests);
                    CommandOperationHelper.executeWrappedCommandProtocol(binding, CreateIndexesOperation.this.namespace.getDatabaseName(), CreateIndexesOperation.this.getCommand(connection.getDescription()), connection, CommandOperationHelper.writeConcernErrorTransformer());
                }
                catch (MongoCommandException e) {
                    throw CreateIndexesOperation.this.checkForDuplicateKeyError(e);
                }
                return null;
            }
        });
    }

    @Override
    public void executeAsync(final AsyncWriteBinding binding, final SingleResultCallback<Void> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    final SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(errHandlingCallback, connection);
                    OperationHelper.validateIndexRequestCollations(connection, CreateIndexesOperation.this.requests, new OperationHelper.AsyncCallableWithConnection(){

                        @Override
                        public void call(AsyncConnection connection, Throwable t) {
                            if (t != null) {
                                wrappedCallback.onResult(null, t);
                            } else {
                                CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, CreateIndexesOperation.this.namespace.getDatabaseName(), CreateIndexesOperation.this.getCommand(connection.getDescription()), connection, CommandOperationHelper.writeConcernErrorTransformer(), new SingleResultCallback<Void>(){

                                    @Override
                                    public void onResult(Void result2, Throwable t) {
                                        wrappedCallback.onResult(null, CreateIndexesOperation.this.translateException(t));
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
    }

    private BsonDocument getIndex(IndexRequest request2) {
        BsonDocument index2 = new BsonDocument();
        index2.append("key", request2.getKeys());
        index2.append("name", new BsonString(request2.getName() != null ? request2.getName() : IndexHelper.generateIndexName(request2.getKeys())));
        index2.append("ns", new BsonString(this.namespace.getFullName()));
        if (request2.isBackground()) {
            index2.append("background", BsonBoolean.TRUE);
        }
        if (request2.isUnique()) {
            index2.append("unique", BsonBoolean.TRUE);
        }
        if (request2.isSparse()) {
            index2.append("sparse", BsonBoolean.TRUE);
        }
        if (request2.getExpireAfter(TimeUnit.SECONDS) != null) {
            index2.append("expireAfterSeconds", new BsonInt64(request2.getExpireAfter(TimeUnit.SECONDS)));
        }
        if (request2.getVersion() != null) {
            index2.append("v", new BsonInt32(request2.getVersion()));
        }
        if (request2.getWeights() != null) {
            index2.append("weights", request2.getWeights());
        }
        if (request2.getDefaultLanguage() != null) {
            index2.append("default_language", new BsonString(request2.getDefaultLanguage()));
        }
        if (request2.getLanguageOverride() != null) {
            index2.append("language_override", new BsonString(request2.getLanguageOverride()));
        }
        if (request2.getTextVersion() != null) {
            index2.append("textIndexVersion", new BsonInt32(request2.getTextVersion()));
        }
        if (request2.getSphereVersion() != null) {
            index2.append("2dsphereIndexVersion", new BsonInt32(request2.getSphereVersion()));
        }
        if (request2.getBits() != null) {
            index2.append("bits", new BsonInt32(request2.getBits()));
        }
        if (request2.getMin() != null) {
            index2.append("min", new BsonDouble(request2.getMin()));
        }
        if (request2.getMax() != null) {
            index2.append("max", new BsonDouble(request2.getMax()));
        }
        if (request2.getBucketSize() != null) {
            index2.append("bucketSize", new BsonDouble(request2.getBucketSize()));
        }
        if (request2.getDropDups()) {
            index2.append("dropDups", BsonBoolean.TRUE);
        }
        if (request2.getStorageEngine() != null) {
            index2.append("storageEngine", request2.getStorageEngine());
        }
        if (request2.getPartialFilterExpression() != null) {
            index2.append("partialFilterExpression", request2.getPartialFilterExpression());
        }
        if (request2.getCollation() != null) {
            index2.append("collation", request2.getCollation().asDocument());
        }
        return index2;
    }

    private BsonDocument getCommand(ConnectionDescription description) {
        BsonDocument command = new BsonDocument("createIndexes", new BsonString(this.namespace.getCollectionName()));
        ArrayList<BsonDocument> values2 = new ArrayList<BsonDocument>();
        for (IndexRequest request2 : this.requests) {
            values2.add(this.getIndex(request2));
        }
        command.put("indexes", new BsonArray(values2));
        DocumentHelper.putIfNotZero(command, "maxTimeMS", this.maxTimeMS);
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, command, description);
        return command;
    }

    private MongoException translateException(Throwable t) {
        return t instanceof MongoCommandException ? this.checkForDuplicateKeyError((MongoCommandException)t) : MongoException.fromThrowable(t);
    }

    private MongoException checkForDuplicateKeyError(MongoCommandException e) {
        if (ErrorCategory.fromErrorCode(e.getCode()) == ErrorCategory.DUPLICATE_KEY) {
            return new DuplicateKeyException(e.getResponse(), e.getServerAddress(), WriteConcernResult.acknowledged(0, false, null));
        }
        return e;
    }
}

