/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.validator;

import java.util.Arrays;
import java.util.List;
import org.bson.FieldNameValidator;

public class CollectibleDocumentFieldNameValidator
implements FieldNameValidator {
    private static final List<String> EXCEPTIONS = Arrays.asList("$db", "$ref", "$id");

    @Override
    public boolean validate(String fieldName2) {
        if (fieldName2 == null) {
            throw new IllegalArgumentException("Field name can not be null");
        }
        if (fieldName2.contains(".")) {
            return false;
        }
        return !fieldName2.startsWith("$") || EXCEPTIONS.contains(fieldName2);
    }

    @Override
    public FieldNameValidator getValidatorForField(String fieldName2) {
        return this;
    }
}

