/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.bulk.IndexRequest;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.client.model.AggregationLevel;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.FindOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.MapReduceAction;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.internal.client.model.CountStrategy;
import com.mongodb.operation.AggregateOperation;
import com.mongodb.operation.AggregateToCollectionOperation;
import com.mongodb.operation.CountOperation;
import com.mongodb.operation.CreateIndexesOperation;
import com.mongodb.operation.DistinctOperation;
import com.mongodb.operation.DropCollectionOperation;
import com.mongodb.operation.DropIndexOperation;
import com.mongodb.operation.FindAndDeleteOperation;
import com.mongodb.operation.FindAndReplaceOperation;
import com.mongodb.operation.FindAndUpdateOperation;
import com.mongodb.operation.FindOperation;
import com.mongodb.operation.ListCollectionsOperation;
import com.mongodb.operation.ListDatabasesOperation;
import com.mongodb.operation.ListIndexesOperation;
import com.mongodb.operation.MapReduceToCollectionOperation;
import com.mongodb.operation.MapReduceWithInlineResultsOperation;
import com.mongodb.operation.MixedBulkWriteOperation;
import com.mongodb.operation.RenameCollectionOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonJavaScript;
import org.bson.BsonString;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

final class Operations<TDocument> {
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;

    Operations(MongoNamespace namespace, Class<TDocument> documentClass, ReadPreference readPreference, CodecRegistry codecRegistry, WriteConcern writeConcern, boolean retryWrites) {
        this.namespace = namespace;
        this.documentClass = documentClass;
        this.readPreference = readPreference;
        this.codecRegistry = codecRegistry;
        this.writeConcern = writeConcern;
        this.retryWrites = retryWrites;
    }

    CountOperation count(Bson filter2, CountOptions options2, CountStrategy countStrategy) {
        CountOperation operation = new CountOperation(this.namespace, countStrategy).filter(this.toBsonDocument(filter2)).skip(options2.getSkip()).limit(options2.getLimit()).maxTime(options2.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).collation(options2.getCollation());
        if (options2.getHint() != null) {
            operation.hint(this.toBsonDocument(options2.getHint()));
        } else if (options2.getHintString() != null) {
            operation.hint(new BsonString(options2.getHintString()));
        }
        return operation;
    }

    <TResult> FindOperation<TResult> findFirst(Bson filter2, Class<TResult> resultClass, FindOptions options2) {
        return this.createFindOperation(this.namespace, filter2, resultClass, options2).batchSize(0).limit(-1);
    }

    <TResult> FindOperation<TResult> find(Bson filter2, Class<TResult> resultClass, FindOptions options2) {
        return this.createFindOperation(this.namespace, filter2, resultClass, options2);
    }

    <TResult> FindOperation<TResult> find(MongoNamespace findNamespace, Bson filter2, Class<TResult> resultClass, FindOptions options2) {
        return this.createFindOperation(findNamespace, filter2, resultClass, options2);
    }

    private <TResult> FindOperation<TResult> createFindOperation(MongoNamespace findNamespace, Bson filter2, Class<TResult> resultClass, FindOptions options2) {
        return new FindOperation<TResult>(findNamespace, this.codecRegistry.get(resultClass)).filter(filter2 == null ? new BsonDocument() : filter2.toBsonDocument(this.documentClass, this.codecRegistry)).batchSize(options2.getBatchSize()).skip(options2.getSkip()).limit(options2.getLimit()).maxTime(options2.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).maxAwaitTime(options2.getMaxAwaitTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).modifiers(this.toBsonDocumentOrNull(options2.getModifiers())).projection(this.toBsonDocumentOrNull(options2.getProjection())).sort(this.toBsonDocumentOrNull(options2.getSort())).cursorType(options2.getCursorType()).noCursorTimeout(options2.isNoCursorTimeout()).oplogReplay(options2.isOplogReplay()).partial(options2.isPartial()).slaveOk(this.readPreference.isSlaveOk()).collation(options2.getCollation()).comment(options2.getComment()).hint(this.toBsonDocumentOrNull(options2.getHint())).min(this.toBsonDocumentOrNull(options2.getMin())).max(this.toBsonDocumentOrNull(options2.getMax())).maxScan(options2.getMaxScan()).returnKey(options2.isReturnKey()).showRecordId(options2.isShowRecordId()).snapshot(options2.isSnapshot());
    }

    <TResult> DistinctOperation<TResult> distinct(String fieldName2, Bson filter2, Class<TResult> resultClass, long maxTimeMS, Collation collation) {
        return new DistinctOperation<TResult>(this.namespace, fieldName2, this.codecRegistry.get(resultClass)).filter(filter2 == null ? null : filter2.toBsonDocument(this.documentClass, this.codecRegistry)).maxTime(maxTimeMS, TimeUnit.MILLISECONDS).collation(collation);
    }

    <TResult> AggregateOperation<TResult> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass, long maxTimeMS, long maxAwaitTimeMS, Integer batchSize, Collation collation, Bson hint, String comment2, Boolean allowDiskUse, Boolean useCursor, AggregationLevel aggregationLevel) {
        return new AggregateOperation<TResult>(this.namespace, this.toBsonDocumentList(pipeline), this.codecRegistry.get(resultClass), aggregationLevel).maxTime(maxTimeMS, TimeUnit.MILLISECONDS).maxAwaitTime(maxAwaitTimeMS, TimeUnit.MILLISECONDS).allowDiskUse(allowDiskUse).batchSize(batchSize).useCursor(useCursor).collation(collation).hint(hint == null ? null : hint.toBsonDocument(this.documentClass, this.codecRegistry)).comment(comment2);
    }

    AggregateToCollectionOperation aggregateToCollection(List<? extends Bson> pipeline, long maxTimeMS, Boolean allowDiskUse, Boolean bypassDocumentValidation, Collation collation, Bson hint, String comment2, AggregationLevel aggregationLevel) {
        return new AggregateToCollectionOperation(this.namespace, this.toBsonDocumentList(pipeline), this.writeConcern, aggregationLevel).maxTime(maxTimeMS, TimeUnit.MILLISECONDS).allowDiskUse(allowDiskUse).bypassDocumentValidation(bypassDocumentValidation).collation(collation).hint(hint == null ? null : hint.toBsonDocument(this.documentClass, this.codecRegistry)).comment(comment2);
    }

    MapReduceToCollectionOperation mapReduceToCollection(String databaseName, String collectionName, String mapFunction, String reduceFunction, String finalizeFunction, Bson filter2, int limit2, long maxTimeMS, boolean jsMode, Bson scope2, Bson sort2, boolean verbose, MapReduceAction action2, boolean nonAtomic, boolean sharded, Boolean bypassDocumentValidation, Collation collation) {
        MapReduceToCollectionOperation operation = new MapReduceToCollectionOperation(this.namespace, new BsonJavaScript(mapFunction), new BsonJavaScript(reduceFunction), collectionName, this.writeConcern).filter(this.toBsonDocumentOrNull(filter2)).limit(limit2).maxTime(maxTimeMS, TimeUnit.MILLISECONDS).jsMode(jsMode).scope(this.toBsonDocumentOrNull(scope2)).sort(this.toBsonDocumentOrNull(sort2)).verbose(verbose).action(action2.getValue()).nonAtomic(nonAtomic).sharded(sharded).databaseName(databaseName).bypassDocumentValidation(bypassDocumentValidation).collation(collation);
        if (finalizeFunction != null) {
            operation.finalizeFunction(new BsonJavaScript(finalizeFunction));
        }
        return operation;
    }

    <TResult> MapReduceWithInlineResultsOperation<TResult> mapReduce(String mapFunction, String reduceFunction, String finalizeFunction, Class<TResult> resultClass, Bson filter2, int limit2, long maxTimeMS, boolean jsMode, Bson scope2, Bson sort2, boolean verbose, Collation collation) {
        MapReduceWithInlineResultsOperation<TResult> operation = new MapReduceWithInlineResultsOperation<TResult>(this.namespace, new BsonJavaScript(mapFunction), new BsonJavaScript(reduceFunction), this.codecRegistry.get(resultClass)).filter(this.toBsonDocumentOrNull(filter2)).limit(limit2).maxTime(maxTimeMS, TimeUnit.MILLISECONDS).jsMode(jsMode).scope(this.toBsonDocumentOrNull(scope2)).sort(this.toBsonDocumentOrNull(sort2)).verbose(verbose).collation(collation);
        if (finalizeFunction != null) {
            operation.finalizeFunction(new BsonJavaScript(finalizeFunction));
        }
        return operation;
    }

    FindAndDeleteOperation<TDocument> findOneAndDelete(Bson filter2, FindOneAndDeleteOptions options2) {
        return new FindAndDeleteOperation<TDocument>(this.namespace, this.writeConcern, this.retryWrites, this.getCodec()).filter(this.toBsonDocument(filter2)).projection(this.toBsonDocument(options2.getProjection())).sort(this.toBsonDocument(options2.getSort())).maxTime(options2.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).collation(options2.getCollation());
    }

    FindAndReplaceOperation<TDocument> findOneAndReplace(Bson filter2, TDocument replacement, FindOneAndReplaceOptions options2) {
        return new FindAndReplaceOperation<TDocument>(this.namespace, this.writeConcern, this.retryWrites, this.getCodec(), this.documentToBsonDocument(replacement)).filter(this.toBsonDocument(filter2)).projection(this.toBsonDocument(options2.getProjection())).sort(this.toBsonDocument(options2.getSort())).returnOriginal(options2.getReturnDocument() == ReturnDocument.BEFORE).upsert(options2.isUpsert()).maxTime(options2.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).bypassDocumentValidation(options2.getBypassDocumentValidation()).collation(options2.getCollation());
    }

    FindAndUpdateOperation<TDocument> findOneAndUpdate(Bson filter2, Bson update2, FindOneAndUpdateOptions options2) {
        return new FindAndUpdateOperation<TDocument>(this.namespace, this.writeConcern, this.retryWrites, this.getCodec(), this.toBsonDocument(update2)).filter(this.toBsonDocument(filter2)).projection(this.toBsonDocument(options2.getProjection())).sort(this.toBsonDocument(options2.getSort())).returnOriginal(options2.getReturnDocument() == ReturnDocument.BEFORE).upsert(options2.isUpsert()).maxTime(options2.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).bypassDocumentValidation(options2.getBypassDocumentValidation()).collation(options2.getCollation()).arrayFilters(this.toBsonDocumentList(options2.getArrayFilters()));
    }

    MixedBulkWriteOperation insertOne(TDocument document2, InsertOneOptions options2) {
        return this.bulkWrite(Collections.singletonList(new InsertOneModel<TDocument>(document2)), new BulkWriteOptions().bypassDocumentValidation(options2.getBypassDocumentValidation()));
    }

    MixedBulkWriteOperation replaceOne(Bson filter2, TDocument replacement, ReplaceOptions options2) {
        return this.bulkWrite(Collections.singletonList(new ReplaceOneModel<TDocument>(filter2, replacement, options2)), new BulkWriteOptions().bypassDocumentValidation(options2.getBypassDocumentValidation()));
    }

    MixedBulkWriteOperation deleteOne(Bson filter2, DeleteOptions options2) {
        return this.bulkWrite(Collections.singletonList(new DeleteOneModel(filter2, options2)), new BulkWriteOptions());
    }

    MixedBulkWriteOperation deleteMany(Bson filter2, DeleteOptions options2) {
        return this.bulkWrite(Collections.singletonList(new DeleteManyModel(filter2, options2)), new BulkWriteOptions());
    }

    MixedBulkWriteOperation updateOne(Bson filter2, Bson update2, UpdateOptions updateOptions) {
        return this.bulkWrite(Collections.singletonList(new UpdateOneModel(filter2, update2, updateOptions)), new BulkWriteOptions().bypassDocumentValidation(updateOptions.getBypassDocumentValidation()));
    }

    MixedBulkWriteOperation updateMany(Bson filter2, Bson update2, UpdateOptions updateOptions) {
        return this.bulkWrite(Collections.singletonList(new UpdateManyModel(filter2, update2, updateOptions)), new BulkWriteOptions().bypassDocumentValidation(updateOptions.getBypassDocumentValidation()));
    }

    MixedBulkWriteOperation insertMany(List<? extends TDocument> documents, InsertManyOptions options2) {
        Assertions.notNull("documents", documents);
        ArrayList<InsertRequest> requests = new ArrayList<InsertRequest>(documents.size());
        for (TDocument document2 : documents) {
            if (document2 == null) {
                throw new IllegalArgumentException("documents can not contain a null value");
            }
            if (this.getCodec() instanceof CollectibleCodec) {
                document2 = ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(document2);
            }
            requests.add(new InsertRequest(this.documentToBsonDocument(document2)));
        }
        return new MixedBulkWriteOperation(this.namespace, requests, options2.isOrdered(), this.writeConcern, this.retryWrites).bypassDocumentValidation(options2.getBypassDocumentValidation());
    }

    MixedBulkWriteOperation bulkWrite(List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options2) {
        Assertions.notNull("requests", requests);
        ArrayList<InsertRequest> writeRequests = new ArrayList<InsertRequest>(requests.size());
        for (WriteModel<TDocument> writeModel : requests) {
            WriteRequest writeRequest;
            if (writeModel == null) {
                throw new IllegalArgumentException("requests can not contain a null value");
            }
            if (writeModel instanceof InsertOneModel) {
                Object document2 = ((InsertOneModel)writeModel).getDocument();
                if (this.getCodec() instanceof CollectibleCodec) {
                    document2 = ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(document2);
                }
                writeRequest = new InsertRequest(this.documentToBsonDocument(document2));
            } else if (writeModel instanceof ReplaceOneModel) {
                ReplaceOneModel replaceOneModel = (ReplaceOneModel)writeModel;
                writeRequest = new UpdateRequest(this.toBsonDocument(replaceOneModel.getFilter()), this.documentToBsonDocument(replaceOneModel.getReplacement()), WriteRequest.Type.REPLACE).upsert(replaceOneModel.getReplaceOptions().isUpsert()).collation(replaceOneModel.getReplaceOptions().getCollation());
            } else if (writeModel instanceof UpdateOneModel) {
                UpdateOneModel updateOneModel = (UpdateOneModel)writeModel;
                writeRequest = new UpdateRequest(this.toBsonDocument(updateOneModel.getFilter()), this.toBsonDocument(updateOneModel.getUpdate()), WriteRequest.Type.UPDATE).multi(false).upsert(updateOneModel.getOptions().isUpsert()).collation(updateOneModel.getOptions().getCollation()).arrayFilters(this.toBsonDocumentList(updateOneModel.getOptions().getArrayFilters()));
            } else if (writeModel instanceof UpdateManyModel) {
                UpdateManyModel updateManyModel = (UpdateManyModel)writeModel;
                writeRequest = new UpdateRequest(this.toBsonDocument(updateManyModel.getFilter()), this.toBsonDocument(updateManyModel.getUpdate()), WriteRequest.Type.UPDATE).multi(true).upsert(updateManyModel.getOptions().isUpsert()).collation(updateManyModel.getOptions().getCollation()).arrayFilters(this.toBsonDocumentList(updateManyModel.getOptions().getArrayFilters()));
            } else if (writeModel instanceof DeleteOneModel) {
                DeleteOneModel deleteOneModel = (DeleteOneModel)writeModel;
                writeRequest = new DeleteRequest(this.toBsonDocument(deleteOneModel.getFilter())).multi(false).collation(deleteOneModel.getOptions().getCollation());
            } else if (writeModel instanceof DeleteManyModel) {
                DeleteManyModel deleteManyModel = (DeleteManyModel)writeModel;
                writeRequest = new DeleteRequest(this.toBsonDocument(deleteManyModel.getFilter())).multi(true).collation(deleteManyModel.getOptions().getCollation());
            } else {
                throw new UnsupportedOperationException(String.format("WriteModel of type %s is not supported", writeModel.getClass()));
            }
            writeRequests.add((InsertRequest)writeRequest);
        }
        return new MixedBulkWriteOperation(this.namespace, writeRequests, options2.isOrdered(), this.writeConcern, this.retryWrites).bypassDocumentValidation(options2.getBypassDocumentValidation());
    }

    DropCollectionOperation dropCollection() {
        return new DropCollectionOperation(this.namespace, this.writeConcern);
    }

    RenameCollectionOperation renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions renameCollectionOptions) {
        return new RenameCollectionOperation(this.namespace, newCollectionNamespace, this.writeConcern).dropTarget(renameCollectionOptions.isDropTarget());
    }

    CreateIndexesOperation createIndexes(List<IndexModel> indexes, CreateIndexOptions createIndexOptions) {
        Assertions.notNull("indexes", indexes);
        Assertions.notNull("createIndexOptions", createIndexOptions);
        ArrayList<IndexRequest> indexRequests = new ArrayList<IndexRequest>(indexes.size());
        for (IndexModel model : indexes) {
            if (model == null) {
                throw new IllegalArgumentException("indexes can not contain a null value");
            }
            indexRequests.add(new IndexRequest(this.toBsonDocument(model.getKeys())).name(model.getOptions().getName()).background(model.getOptions().isBackground()).unique(model.getOptions().isUnique()).sparse(model.getOptions().isSparse()).expireAfter(model.getOptions().getExpireAfter(TimeUnit.SECONDS), TimeUnit.SECONDS).version(model.getOptions().getVersion()).weights(this.toBsonDocument(model.getOptions().getWeights())).defaultLanguage(model.getOptions().getDefaultLanguage()).languageOverride(model.getOptions().getLanguageOverride()).textVersion(model.getOptions().getTextVersion()).sphereVersion(model.getOptions().getSphereVersion()).bits(model.getOptions().getBits()).min(model.getOptions().getMin()).max(model.getOptions().getMax()).bucketSize(model.getOptions().getBucketSize()).storageEngine(this.toBsonDocument(model.getOptions().getStorageEngine())).partialFilterExpression(this.toBsonDocument(model.getOptions().getPartialFilterExpression())).collation(model.getOptions().getCollation()));
        }
        return new CreateIndexesOperation(this.namespace, indexRequests, this.writeConcern).maxTime(createIndexOptions.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    DropIndexOperation dropIndex(String indexName, DropIndexOptions dropIndexOptions) {
        return new DropIndexOperation(this.namespace, indexName, this.writeConcern).maxTime(dropIndexOptions.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    DropIndexOperation dropIndex(Bson keys2, DropIndexOptions dropIndexOptions) {
        return new DropIndexOperation(this.namespace, keys2.toBsonDocument(BsonDocument.class, this.codecRegistry), this.writeConcern).maxTime(dropIndexOptions.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    <TResult> ListCollectionsOperation<TResult> listCollections(String databaseName, Class<TResult> resultClass, Bson filter2, boolean collectionNamesOnly, Integer batchSize, long maxTimeMS) {
        return new ListCollectionsOperation<TResult>(databaseName, this.codecRegistry.get(resultClass)).filter(this.toBsonDocumentOrNull(filter2)).nameOnly(collectionNamesOnly).batchSize(batchSize == null ? 0 : batchSize).maxTime(maxTimeMS, TimeUnit.MILLISECONDS);
    }

    <TResult> ListDatabasesOperation<TResult> listDatabases(Class<TResult> resultClass, Bson filter2, Boolean nameOnly, long maxTimeMS) {
        return new ListDatabasesOperation<TResult>(this.codecRegistry.get(resultClass)).maxTime(maxTimeMS, TimeUnit.MILLISECONDS).filter(this.toBsonDocumentOrNull(filter2)).nameOnly(nameOnly);
    }

    <TResult> ListIndexesOperation<TResult> listIndexes(Class<TResult> resultClass, Integer batchSize, long maxTimeMS) {
        return new ListIndexesOperation<TResult>(this.namespace, this.codecRegistry.get(resultClass)).batchSize(batchSize == null ? 0 : batchSize).maxTime(maxTimeMS, TimeUnit.MILLISECONDS);
    }

    private Codec<TDocument> getCodec() {
        return this.codecRegistry.get(this.documentClass);
    }

    private BsonDocument documentToBsonDocument(TDocument document2) {
        return BsonDocumentWrapper.asBsonDocument(document2, this.codecRegistry);
    }

    private BsonDocument toBsonDocument(Bson bson) {
        return bson == null ? null : bson.toBsonDocument(this.documentClass, this.codecRegistry);
    }

    private List<BsonDocument> toBsonDocumentList(List<? extends Bson> bsonList) {
        if (bsonList == null) {
            return null;
        }
        ArrayList<BsonDocument> bsonDocumentList = new ArrayList<BsonDocument>(bsonList.size());
        for (Bson bson : bsonList) {
            bsonDocumentList.add(this.toBsonDocument(bson));
        }
        return bsonDocumentList;
    }

    BsonDocument toBsonDocumentOrNull(Bson document2) {
        return document2 == null ? null : document2.toBsonDocument(this.documentClass, this.codecRegistry);
    }
}

