/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.model.AggregationLevel;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.FindOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.MapReduceAction;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.internal.client.model.CountStrategy;
import com.mongodb.internal.operation.Operations;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.MapReduceAsyncBatchCursor;
import com.mongodb.operation.MapReduceStatistics;
import java.util.List;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class AsyncOperations<TDocument> {
    private final Operations<TDocument> operations;

    public AsyncOperations(Class<TDocument> documentClass, ReadPreference readPreference, CodecRegistry codecRegistry) {
        this(null, documentClass, readPreference, codecRegistry, WriteConcern.ACKNOWLEDGED, false);
    }

    public AsyncOperations(MongoNamespace namespace, Class<TDocument> documentClass, ReadPreference readPreference, CodecRegistry codecRegistry) {
        this(namespace, documentClass, readPreference, codecRegistry, WriteConcern.ACKNOWLEDGED, false);
    }

    public AsyncOperations(MongoNamespace namespace, Class<TDocument> documentClass, ReadPreference readPreference, CodecRegistry codecRegistry, WriteConcern writeConcern, boolean retryWrites) {
        this.operations = new Operations<TDocument>(namespace, documentClass, readPreference, codecRegistry, writeConcern, retryWrites);
    }

    public AsyncReadOperation<Long> count(Bson filter2, CountOptions options2, CountStrategy countStrategy) {
        return this.operations.count(filter2, options2, countStrategy);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> findFirst(Bson filter2, Class<TResult> resultClass, FindOptions options2) {
        return this.operations.findFirst(filter2, resultClass, options2);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> find(Bson filter2, Class<TResult> resultClass, FindOptions options2) {
        return this.operations.find(filter2, resultClass, options2);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> find(MongoNamespace findNamespace, Bson filter2, Class<TResult> resultClass, FindOptions options2) {
        return this.operations.find(findNamespace, filter2, resultClass, options2);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> distinct(String fieldName2, Bson filter2, Class<TResult> resultClass, long maxTimeMS, Collation collation) {
        return this.operations.distinct(fieldName2, filter2, resultClass, maxTimeMS, collation);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass, long maxTimeMS, long maxAwaitTimeMS, Integer batchSize, Collation collation, Bson hint, String comment2, Boolean allowDiskUse, Boolean useCursor, AggregationLevel aggregationLevel) {
        return this.operations.aggregate(pipeline, resultClass, maxTimeMS, maxAwaitTimeMS, batchSize, collation, hint, comment2, allowDiskUse, useCursor, aggregationLevel);
    }

    public AsyncWriteOperation<Void> aggregateToCollection(List<? extends Bson> pipeline, long maxTimeMS, Boolean allowDiskUse, Boolean bypassDocumentValidation, Collation collation, Bson hint, String comment2, AggregationLevel aggregationLevel) {
        return this.operations.aggregateToCollection(pipeline, maxTimeMS, allowDiskUse, bypassDocumentValidation, collation, hint, comment2, aggregationLevel);
    }

    public AsyncWriteOperation<MapReduceStatistics> mapReduceToCollection(String databaseName, String collectionName, String mapFunction, String reduceFunction, String finalizeFunction, Bson filter2, int limit2, long maxTimeMS, boolean jsMode, Bson scope2, Bson sort2, boolean verbose, MapReduceAction action2, boolean nonAtomic, boolean sharded, Boolean bypassDocumentValidation, Collation collation) {
        return this.operations.mapReduceToCollection(databaseName, collectionName, mapFunction, reduceFunction, finalizeFunction, filter2, limit2, maxTimeMS, jsMode, scope2, sort2, verbose, action2, nonAtomic, sharded, bypassDocumentValidation, collation);
    }

    public <TResult> AsyncReadOperation<MapReduceAsyncBatchCursor<TResult>> mapReduce(String mapFunction, String reduceFunction, String finalizeFunction, Class<TResult> resultClass, Bson filter2, int limit2, long maxTimeMS, boolean jsMode, Bson scope2, Bson sort2, boolean verbose, Collation collation) {
        return this.operations.mapReduce(mapFunction, reduceFunction, finalizeFunction, resultClass, filter2, limit2, maxTimeMS, jsMode, scope2, sort2, verbose, collation);
    }

    public AsyncWriteOperation<TDocument> findOneAndDelete(Bson filter2, FindOneAndDeleteOptions options2) {
        return this.operations.findOneAndDelete(filter2, options2);
    }

    public AsyncWriteOperation<TDocument> findOneAndReplace(Bson filter2, TDocument replacement, FindOneAndReplaceOptions options2) {
        return this.operations.findOneAndReplace(filter2, replacement, options2);
    }

    public AsyncWriteOperation<TDocument> findOneAndUpdate(Bson filter2, Bson update2, FindOneAndUpdateOptions options2) {
        return this.operations.findOneAndUpdate(filter2, update2, options2);
    }

    public AsyncWriteOperation<BulkWriteResult> insertOne(TDocument document2, InsertOneOptions options2) {
        return this.operations.insertOne(document2, options2);
    }

    public AsyncWriteOperation<BulkWriteResult> replaceOne(Bson filter2, TDocument replacement, ReplaceOptions options2) {
        return this.operations.replaceOne(filter2, replacement, options2);
    }

    public AsyncWriteOperation<BulkWriteResult> deleteOne(Bson filter2, DeleteOptions options2) {
        return this.operations.deleteOne(filter2, options2);
    }

    public AsyncWriteOperation<BulkWriteResult> deleteMany(Bson filter2, DeleteOptions options2) {
        return this.operations.deleteMany(filter2, options2);
    }

    public AsyncWriteOperation<BulkWriteResult> updateOne(Bson filter2, Bson update2, UpdateOptions updateOptions) {
        return this.operations.updateOne(filter2, update2, updateOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> updateMany(Bson filter2, Bson update2, UpdateOptions updateOptions) {
        return this.operations.updateMany(filter2, update2, updateOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> insertMany(List<? extends TDocument> documents, InsertManyOptions options2) {
        return this.operations.insertMany(documents, options2);
    }

    public AsyncWriteOperation<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options2) {
        return this.operations.bulkWrite(requests, options2);
    }

    public AsyncWriteOperation<Void> dropCollection() {
        return this.operations.dropCollection();
    }

    public AsyncWriteOperation<Void> renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions options2) {
        return this.operations.renameCollection(newCollectionNamespace, options2);
    }

    public AsyncWriteOperation<Void> createIndexes(List<IndexModel> indexes, CreateIndexOptions options2) {
        return this.operations.createIndexes(indexes, options2);
    }

    public AsyncWriteOperation<Void> dropIndex(String indexName, DropIndexOptions options2) {
        return this.operations.dropIndex(indexName, options2);
    }

    public AsyncWriteOperation<Void> dropIndex(Bson keys2, DropIndexOptions options2) {
        return this.operations.dropIndex(keys2, options2);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> listCollections(String databaseName, Class<TResult> resultClass, Bson filter2, boolean collectionNamesOnly, Integer batchSize, long maxTimeMS) {
        return this.operations.listCollections(databaseName, resultClass, filter2, collectionNamesOnly, batchSize, maxTimeMS);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> listDatabases(Class<TResult> resultClass, Bson filter2, Boolean nameOnly, long maxTimeMS) {
        return this.operations.listDatabases(resultClass, filter2, nameOnly, maxTimeMS);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> listIndexes(Class<TResult> resultClass, Integer batchSize, long maxTimeMS) {
        return this.operations.listIndexes(resultClass, batchSize, maxTimeMS);
    }
}

