/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection.tlschannel.impl;

import com.mongodb.internal.connection.tlschannel.impl.ByteBufferUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ByteBufferSet {
    public final ByteBuffer[] array;
    public final int offset;
    public final int length;

    public ByteBufferSet(ByteBuffer[] array2, int offset, int length2) {
        if (array2 == null) {
            throw new NullPointerException();
        }
        if (array2.length < offset) {
            throw new IndexOutOfBoundsException();
        }
        if (array2.length < offset + length2) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = offset; i < offset + length2; ++i) {
            if (array2[i] != null) continue;
            throw new NullPointerException();
        }
        this.array = array2;
        this.offset = offset;
        this.length = length2;
    }

    public ByteBufferSet(ByteBuffer[] array2) {
        this(array2, 0, array2.length);
    }

    public ByteBufferSet(ByteBuffer buffer) {
        this(new ByteBuffer[]{buffer});
    }

    public long remaining() {
        long ret = 0L;
        for (int i = this.offset; i < this.offset + this.length; ++i) {
            ret += (long)this.array[i].remaining();
        }
        return ret;
    }

    public int putRemaining(ByteBuffer from2) {
        int totalBytes = 0;
        for (int i = this.offset; i < this.offset + this.length && from2.hasRemaining(); ++i) {
            ByteBuffer dstBuffer = this.array[i];
            int bytes2 = Math.min(from2.remaining(), dstBuffer.remaining());
            ByteBufferUtil.copy(from2, dstBuffer, bytes2);
            totalBytes += bytes2;
        }
        return totalBytes;
    }

    public ByteBufferSet put(ByteBuffer from2, int length2) {
        int pending;
        if (from2.remaining() < length2) {
            throw new IllegalArgumentException();
        }
        if (this.remaining() < (long)length2) {
            throw new IllegalArgumentException();
        }
        int totalBytes = 0;
        for (int i = this.offset; i < this.offset + this.length && (pending = length2 - totalBytes) != 0; ++i) {
            int bytes2 = Math.min(pending, (int)this.remaining());
            ByteBuffer dstBuffer = this.array[i];
            ByteBufferUtil.copy(from2, dstBuffer, bytes2);
            totalBytes += bytes2;
        }
        return this;
    }

    public int getRemaining(ByteBuffer dst) {
        int totalBytes = 0;
        for (int i = this.offset; i < this.offset + this.length && dst.hasRemaining(); ++i) {
            ByteBuffer srcBuffer = this.array[i];
            int bytes2 = Math.min(dst.remaining(), srcBuffer.remaining());
            ByteBufferUtil.copy(srcBuffer, dst, bytes2);
            totalBytes += bytes2;
        }
        return totalBytes;
    }

    public ByteBufferSet get(ByteBuffer dst, int length2) {
        int pending;
        if (this.remaining() < (long)length2) {
            throw new IllegalArgumentException();
        }
        if (dst.remaining() < length2) {
            throw new IllegalArgumentException();
        }
        int totalBytes = 0;
        for (int i = this.offset; i < this.offset + this.length && (pending = length2 - totalBytes) != 0; ++i) {
            ByteBuffer srcBuffer = this.array[i];
            int bytes2 = Math.min(pending, srcBuffer.remaining());
            ByteBufferUtil.copy(srcBuffer, dst, bytes2);
            totalBytes += bytes2;
        }
        return this;
    }

    public boolean hasRemaining() {
        return this.remaining() > 0L;
    }

    public boolean isReadOnly() {
        for (int i = this.offset; i < this.offset + this.length; ++i) {
            if (!this.array[i].isReadOnly()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "ByteBufferSet[array=" + Arrays.toString(this.array) + ", offset=" + this.offset + ", length=" + this.length + "]";
    }
}

