/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.connection.SplittablePayload;
import com.mongodb.internal.connection.BsonWriterHelper;
import com.mongodb.internal.connection.LevelCountingBsonWriter;
import com.mongodb.internal.connection.MessageSettings;
import org.bson.BsonBinaryWriter;
import org.bson.BsonWriter;
import org.bson.io.BsonOutput;

class SplittablePayloadBsonWriter
extends LevelCountingBsonWriter {
    private final BsonWriter writer;
    private final BsonOutput bsonOutput;
    private final SplittablePayload payload;
    private final MessageSettings settings;
    private final int messageStartPosition;

    SplittablePayloadBsonWriter(BsonBinaryWriter writer2, BsonOutput bsonOutput, int messageStartPosition, MessageSettings settings2, SplittablePayload payload) {
        super(writer2);
        this.writer = writer2;
        this.bsonOutput = bsonOutput;
        this.messageStartPosition = messageStartPosition;
        this.settings = settings2;
        this.payload = payload;
    }

    @Override
    public void writeStartDocument() {
        super.writeStartDocument();
    }

    @Override
    public void writeEndDocument() {
        if (this.getCurrentLevel() == 0 && this.payload.getPayload().size() > 0) {
            BsonWriterHelper.writePayloadArray(this.writer, this.bsonOutput, this.settings, this.messageStartPosition, this.payload);
        }
        super.writeEndDocument();
    }
}

