/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoSocketException;
import com.mongodb.MongoSocketOpenException;
import com.mongodb.MongoSocketReadException;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.AsyncCompletionHandler;
import com.mongodb.connection.BufferProvider;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.connection.Stream;
import com.mongodb.internal.connection.SocketStreamHelper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.List;
import org.bson.ByteBuf;

public class SocketChannelStream
implements Stream {
    private final ServerAddress address;
    private final SocketSettings settings;
    private final SslSettings sslSettings;
    private final BufferProvider bufferProvider;
    private volatile SocketChannel socketChannel;
    private volatile boolean isClosed;

    public SocketChannelStream(ServerAddress address, SocketSettings settings2, SslSettings sslSettings, BufferProvider bufferProvider) {
        this.address = Assertions.notNull("address", address);
        this.settings = Assertions.notNull("settings", settings2);
        this.sslSettings = Assertions.notNull("sslSettings", sslSettings);
        this.bufferProvider = Assertions.notNull("bufferProvider", bufferProvider);
    }

    @Override
    public void open() {
        try {
            this.socketChannel = this.initializeSocketChannel();
        }
        catch (IOException e) {
            this.close();
            throw new MongoSocketOpenException("Exception opening socket", this.getAddress(), (Throwable)e);
        }
    }

    private SocketChannel initializeSocketChannel() throws IOException {
        Iterator<InetSocketAddress> inetSocketAddresses = this.address.getSocketAddresses().iterator();
        while (inetSocketAddresses.hasNext()) {
            SocketChannel socketChannel = SocketChannel.open();
            try {
                SocketStreamHelper.initialize(socketChannel.socket(), inetSocketAddresses.next(), this.settings, this.sslSettings);
                return socketChannel;
            }
            catch (SocketTimeoutException e) {
                if (inetSocketAddresses.hasNext()) continue;
                throw e;
            }
        }
        throw new MongoSocketException("Exception opening socket", this.getAddress());
    }

    @Override
    public ByteBuf getBuffer(int size2) {
        return this.bufferProvider.getBuffer(size2);
    }

    @Override
    public void write(List<ByteBuf> buffers) throws IOException {
        Assertions.isTrue("open", !this.isClosed());
        int totalSize = 0;
        ByteBuffer[] byteBufferArray = new ByteBuffer[buffers.size()];
        for (int i = 0; i < buffers.size(); ++i) {
            byteBufferArray[i] = buffers.get(i).asNIO();
            totalSize += byteBufferArray[i].limit();
        }
        for (long bytesRead = 0L; bytesRead < (long)totalSize; bytesRead += this.socketChannel.write(byteBufferArray)) {
        }
    }

    @Override
    public ByteBuf read(int numBytes) throws IOException {
        int bytesRead;
        ByteBuf buffer = this.bufferProvider.getBuffer(numBytes);
        Assertions.isTrue("open", !this.isClosed());
        for (int totalBytesRead = 0; totalBytesRead < buffer.limit(); totalBytesRead += bytesRead) {
            bytesRead = this.socketChannel.read(buffer.asNIO());
            if (bytesRead != -1) continue;
            buffer.release();
            throw new MongoSocketReadException("Prematurely reached end of stream", this.getAddress());
        }
        return buffer.flip();
    }

    @Override
    public void openAsync(AsyncCompletionHandler<Void> handler) {
        throw new UnsupportedOperationException(this.getClass() + " does not support asynchronous operations.");
    }

    @Override
    public void writeAsync(List<ByteBuf> buffers, AsyncCompletionHandler<Void> handler) {
        throw new UnsupportedOperationException(this.getClass() + " does not support asynchronous operations.");
    }

    @Override
    public void readAsync(int numBytes, AsyncCompletionHandler<ByteBuf> handler) {
        throw new UnsupportedOperationException(this.getClass() + " does not support asynchronous operations.");
    }

    @Override
    public ServerAddress getAddress() {
        return this.address;
    }

    SocketSettings getSettings() {
        return this.settings;
    }

    void setSocketChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    @Override
    public void close() {
        try {
            this.isClosed = true;
            if (this.socketChannel != null) {
                this.socketChannel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }
}

