/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoInternalException;
import com.mongodb.internal.connection.Compressor;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.bson.ByteBuf;
import org.bson.io.BsonOutput;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyInputStream;

class SnappyCompressor
extends Compressor {
    SnappyCompressor() {
    }

    @Override
    public String getName() {
        return "snappy";
    }

    @Override
    public byte getId() {
        return 1;
    }

    @Override
    public void compress(List<ByteBuf> source2, BsonOutput target) {
        int uncompressedSize = this.getUncompressedSize(source2);
        byte[] singleByteArraySource = new byte[uncompressedSize];
        this.copy(source2, singleByteArraySource);
        try {
            byte[] out = new byte[Snappy.maxCompressedLength((int)uncompressedSize)];
            int compressedSize = Snappy.compress((byte[])singleByteArraySource, (int)0, (int)singleByteArraySource.length, (byte[])out, (int)0);
            target.writeBytes(out, 0, compressedSize);
        }
        catch (IOException e) {
            throw new MongoInternalException("Unexpected IOException", e);
        }
    }

    private int getUncompressedSize(List<ByteBuf> source2) {
        int uncompressedSize = 0;
        for (ByteBuf cur : source2) {
            uncompressedSize += cur.remaining();
        }
        return uncompressedSize;
    }

    private void copy(List<ByteBuf> source2, byte[] in2) {
        int offset = 0;
        for (ByteBuf cur : source2) {
            int remaining = cur.remaining();
            cur.get(in2, offset, remaining);
            offset += remaining;
        }
    }

    @Override
    InputStream getInputStream(InputStream source2) throws IOException {
        return new SnappyInputStream(source2);
    }
}

