/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.internal.authentication.NativeAuthenticationHelper;
import com.mongodb.internal.authentication.SaslPrep;
import com.mongodb.internal.connection.MongoCredentialWithCache;
import com.mongodb.internal.connection.SaslAuthenticator;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.bson.internal.Base64;

class ScramShaAuthenticator
extends SaslAuthenticator {
    private final RandomStringGenerator randomStringGenerator;
    private final AuthenticationHashGenerator authenticationHashGenerator;
    private static final int MINIMUM_ITERATION_COUNT = 4096;
    private static final String GS2_HEADER = "n,,";
    private static final int RANDOM_LENGTH = 24;
    private static final byte[] INT_1 = new byte[]{0, 0, 0, 1};
    private static final AuthenticationHashGenerator DEFAULT_AUTHENTICATION_HASH_GENERATOR = new AuthenticationHashGenerator(){

        @Override
        public String generate(MongoCredential credential) {
            char[] password = credential.getPassword();
            if (password == null) {
                throw new IllegalArgumentException("Password must not be null");
            }
            return new String(password);
        }
    };
    private static final AuthenticationHashGenerator LEGACY_AUTHENTICATION_HASH_GENERATOR = new AuthenticationHashGenerator(){

        @Override
        public String generate(MongoCredential credential) {
            String username = credential.getUserName();
            char[] password = credential.getPassword();
            if (username == null || password == null) {
                throw new IllegalArgumentException("Username and password must not be null");
            }
            return NativeAuthenticationHelper.createAuthenticationHash(username, password);
        }
    };

    ScramShaAuthenticator(MongoCredentialWithCache credential) {
        this(credential, new DefaultRandomStringGenerator(), ScramShaAuthenticator.getAuthenicationHashGenerator(credential.getAuthenticationMechanism()));
    }

    ScramShaAuthenticator(MongoCredentialWithCache credential, RandomStringGenerator randomStringGenerator) {
        this(credential, randomStringGenerator, ScramShaAuthenticator.getAuthenicationHashGenerator(credential.getAuthenticationMechanism()));
    }

    ScramShaAuthenticator(MongoCredentialWithCache credential, RandomStringGenerator randomStringGenerator, AuthenticationHashGenerator authenticationHashGenerator) {
        super(credential);
        this.randomStringGenerator = randomStringGenerator;
        this.authenticationHashGenerator = authenticationHashGenerator;
    }

    @Override
    public String getMechanismName() {
        AuthenticationMechanism authMechanism = this.getMongoCredential().getAuthenticationMechanism();
        if (authMechanism == null) {
            throw new IllegalArgumentException("Authentication mechanism cannot be null");
        }
        return authMechanism.getMechanismName();
    }

    @Override
    protected SaslClient createSaslClient(ServerAddress serverAddress) {
        return new ScramShaSaslClient(this.getMongoCredentialWithCache(), this.randomStringGenerator, this.authenticationHashGenerator);
    }

    private static AuthenticationHashGenerator getAuthenicationHashGenerator(AuthenticationMechanism authenticationMechanism) {
        return authenticationMechanism == AuthenticationMechanism.SCRAM_SHA_1 ? LEGACY_AUTHENTICATION_HASH_GENERATOR : DEFAULT_AUTHENTICATION_HASH_GENERATOR;
    }

    private static class CacheValue {
        private byte[] clientKey;
        private byte[] serverKey;

        CacheValue(byte[] clientKey, byte[] serverKey) {
            this.clientKey = clientKey;
            this.serverKey = serverKey;
        }
    }

    private static class CacheKey {
        private final String hashedPasswordAndSalt;
        private final String salt;
        private final int iterationCount;

        CacheKey(String hashedPasswordAndSalt, String salt, int iterationCount) {
            this.hashedPasswordAndSalt = hashedPasswordAndSalt;
            this.salt = salt;
            this.iterationCount = iterationCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey that2 = (CacheKey)o;
            if (this.iterationCount != that2.iterationCount) {
                return false;
            }
            if (!this.hashedPasswordAndSalt.equals(that2.hashedPasswordAndSalt)) {
                return false;
            }
            return this.salt.equals(that2.salt);
        }

        public int hashCode() {
            int result2 = this.hashedPasswordAndSalt.hashCode();
            result2 = 31 * result2 + this.salt.hashCode();
            result2 = 31 * result2 + this.iterationCount;
            return result2;
        }
    }

    private static class DefaultRandomStringGenerator
    implements RandomStringGenerator {
        private DefaultRandomStringGenerator() {
        }

        @Override
        public String generate(int length2) {
            SecureRandom random = new SecureRandom();
            int comma = 44;
            int low = 33;
            int high = 126;
            int range2 = high - low;
            char[] text2 = new char[length2];
            for (int i = 0; i < length2; ++i) {
                int next2 = random.nextInt(range2) + low;
                while (next2 == comma) {
                    next2 = random.nextInt(range2) + low;
                }
                text2[i] = (char)next2;
            }
            return new String(text2);
        }
    }

    public static interface AuthenticationHashGenerator {
        public String generate(MongoCredential var1);
    }

    public static interface RandomStringGenerator {
        public String generate(int var1);
    }

    class ScramShaSaslClient
    implements SaslClient {
        private final MongoCredentialWithCache credential;
        private final RandomStringGenerator randomStringGenerator;
        private final AuthenticationHashGenerator authenticationHashGenerator;
        private final String hAlgorithm;
        private final String hmacAlgorithm;
        private String clientFirstMessageBare;
        private String clientNonce;
        private byte[] serverSignature;
        private int step = -1;

        ScramShaSaslClient(MongoCredentialWithCache credential, RandomStringGenerator randomStringGenerator, AuthenticationHashGenerator authenticationHashGenerator) {
            this.credential = credential;
            this.randomStringGenerator = randomStringGenerator;
            this.authenticationHashGenerator = authenticationHashGenerator;
            if (credential.getAuthenticationMechanism().equals((Object)AuthenticationMechanism.SCRAM_SHA_1)) {
                this.hAlgorithm = "SHA-1";
                this.hmacAlgorithm = "HmacSHA1";
            } else {
                this.hAlgorithm = "SHA-256";
                this.hmacAlgorithm = "HmacSHA256";
            }
        }

        @Override
        public String getMechanismName() {
            return this.credential.getAuthenticationMechanism().getMechanismName();
        }

        @Override
        public boolean hasInitialResponse() {
            return true;
        }

        @Override
        public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
            ++this.step;
            if (this.step == 0) {
                return this.computeClientFirstMessage();
            }
            if (this.step == 1) {
                return this.computeClientFinalMessage(challenge);
            }
            if (this.step == 2) {
                return this.validateServerSignature(challenge);
            }
            throw new SaslException(String.format("Too many steps involved in the %s negotiation.", this.getMechanismName()));
        }

        private byte[] validateServerSignature(byte[] challenge) throws SaslException {
            String serverResponse = this.encodeUTF8(challenge);
            HashMap<String, String> map2 = this.parseServerResponse(serverResponse);
            if (!MessageDigest.isEqual(this.decodeBase64(map2.get("v")), this.serverSignature)) {
                throw new SaslException("Server signature was invalid.");
            }
            return challenge;
        }

        @Override
        public boolean isComplete() {
            return this.step == 2;
        }

        @Override
        public byte[] unwrap(byte[] incoming, int offset, int len2) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }

        @Override
        public byte[] wrap(byte[] outgoing, int offset, int len2) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }

        @Override
        public Object getNegotiatedProperty(String propName) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }

        @Override
        public void dispose() {
        }

        private byte[] computeClientFirstMessage() throws SaslException {
            String clientFirstMessage;
            this.clientNonce = this.randomStringGenerator.generate(24);
            this.clientFirstMessageBare = clientFirstMessage = "n=" + this.getUserName() + ",r=" + this.clientNonce;
            return this.decodeUTF8(ScramShaAuthenticator.GS2_HEADER + clientFirstMessage);
        }

        private byte[] computeClientFinalMessage(byte[] challenge) throws SaslException {
            String serverFirstMessage = this.encodeUTF8(challenge);
            HashMap<String, String> map2 = this.parseServerResponse(serverFirstMessage);
            String serverNonce = map2.get("r");
            if (!serverNonce.startsWith(this.clientNonce)) {
                throw new SaslException("Server sent an invalid nonce.");
            }
            String salt = map2.get("s");
            int iterationCount = Integer.parseInt(map2.get("i"));
            if (iterationCount < 4096) {
                throw new SaslException("Invalid iteration count.");
            }
            String clientFinalMessageWithoutProof = "c=" + this.encodeBase64(ScramShaAuthenticator.GS2_HEADER) + ",r=" + serverNonce;
            String authMessage = this.clientFirstMessageBare + "," + serverFirstMessage + "," + clientFinalMessageWithoutProof;
            String clientFinalMessage = clientFinalMessageWithoutProof + ",p=" + this.getClientProof(this.getAuthenicationHash(), salt, iterationCount, authMessage);
            return this.decodeUTF8(clientFinalMessage);
        }

        String getClientProof(String password, String salt, int iterationCount, String authMessage) throws SaslException {
            String hashedPasswordAndSalt = this.encodeUTF8(this.h(this.decodeUTF8(password + salt)));
            CacheKey cacheKey = new CacheKey(hashedPasswordAndSalt, salt, iterationCount);
            CacheValue cachedKeys = ScramShaAuthenticator.this.getMongoCredentialWithCache().getFromCache(cacheKey, CacheValue.class);
            if (cachedKeys == null) {
                byte[] saltedPassword = this.hi(this.decodeUTF8(password), this.decodeBase64(salt), iterationCount);
                byte[] clientKey = this.hmac(saltedPassword, "Client Key");
                byte[] serverKey = this.hmac(saltedPassword, "Server Key");
                cachedKeys = new CacheValue(clientKey, serverKey);
                ScramShaAuthenticator.this.getMongoCredentialWithCache().putInCache(cacheKey, new CacheValue(clientKey, serverKey));
            }
            this.serverSignature = this.hmac(cachedKeys.serverKey, authMessage);
            byte[] storedKey = this.h(cachedKeys.clientKey);
            byte[] clientSignature = this.hmac(storedKey, authMessage);
            byte[] clientProof = this.xor(cachedKeys.clientKey, clientSignature);
            return this.encodeBase64(clientProof);
        }

        private byte[] decodeBase64(String str) {
            return Base64.decode(str);
        }

        private byte[] decodeUTF8(String str) throws SaslException {
            try {
                return str.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new SaslException("UTF-8 is not a supported encoding.", e);
            }
        }

        private String encodeBase64(String str) throws SaslException {
            return Base64.encode(this.decodeUTF8(str));
        }

        private String encodeBase64(byte[] bytes2) {
            return Base64.encode(bytes2);
        }

        private String encodeUTF8(byte[] bytes2) throws SaslException {
            try {
                return new String(bytes2, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new SaslException("UTF-8 is not a supported encoding.", e);
            }
        }

        private byte[] h(byte[] data) throws SaslException {
            try {
                return MessageDigest.getInstance(this.hAlgorithm).digest(data);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException(String.format("Algorithm for '%s' could not be found.", this.hAlgorithm), e);
            }
        }

        private byte[] hi(byte[] password, byte[] salt, int iterations) throws SaslException {
            try {
                SecretKeySpec key = new SecretKeySpec(password, this.hmacAlgorithm);
                Mac mac = Mac.getInstance(this.hmacAlgorithm);
                mac.init(key);
                mac.update(salt);
                mac.update(INT_1);
                byte[] result2 = mac.doFinal();
                byte[] previous2 = null;
                for (int i = 1; i < iterations; ++i) {
                    mac.update(previous2 != null ? previous2 : result2);
                    previous2 = mac.doFinal();
                    this.xorInPlace(result2, previous2);
                }
                return result2;
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException(String.format("Algorithm for '%s' could not be found.", this.hmacAlgorithm), e);
            }
            catch (InvalidKeyException e) {
                throw new SaslException(String.format("Invalid key for %s", this.hmacAlgorithm), e);
            }
        }

        private byte[] hmac(byte[] bytes2, String key) throws SaslException {
            try {
                Mac mac = Mac.getInstance(this.hmacAlgorithm);
                mac.init(new SecretKeySpec(bytes2, this.hmacAlgorithm));
                return mac.doFinal(this.decodeUTF8(key));
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException(String.format("Algorithm for '%s' could not be found.", this.hmacAlgorithm), e);
            }
            catch (InvalidKeyException e) {
                throw new SaslException("Could not initialize mac.", e);
            }
        }

        private HashMap<String, String> parseServerResponse(String response) {
            String[] pairs2;
            HashMap<String, String> map2 = new HashMap<String, String>();
            for (String pair2 : pairs2 = response.split(",")) {
                String[] parts = pair2.split("=", 2);
                map2.put(parts[0], parts[1]);
            }
            return map2;
        }

        private String getUserName() {
            String userName = this.credential.getCredential().getUserName();
            if (userName == null) {
                throw new IllegalArgumentException("Username can not be null");
            }
            return userName.replace("=", "=3D").replace(",", "=2C");
        }

        private String getAuthenicationHash() {
            String password = this.authenticationHashGenerator.generate(this.credential.getCredential());
            if (this.credential.getAuthenticationMechanism() == AuthenticationMechanism.SCRAM_SHA_256) {
                password = SaslPrep.saslPrepStored(password);
            }
            return password;
        }

        private byte[] xorInPlace(byte[] a2, byte[] b2) {
            for (int i = 0; i < a2.length; ++i) {
                int n = i;
                a2[n] = (byte)(a2[n] ^ b2[i]);
            }
            return a2;
        }

        private byte[] xor(byte[] a2, byte[] b2) {
            byte[] result2 = new byte[a2.length];
            System.arraycopy(a2, 0, result2, 0, a2.length);
            return this.xorInPlace(result2, b2);
        }
    }
}

