/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import org.bson.BsonBinary;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDbPointer;
import org.bson.BsonReader;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.BsonWriter;
import org.bson.assertions.Assertions;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

abstract class LevelCountingBsonWriter
implements BsonWriter {
    private final BsonBinaryWriter bsonBinaryWriter;
    private int level = -1;

    LevelCountingBsonWriter(BsonBinaryWriter bsonBinaryWriter) {
        this.bsonBinaryWriter = Assertions.notNull("bsonBinaryWriter", bsonBinaryWriter);
    }

    public int getCurrentLevel() {
        return this.level;
    }

    public BsonBinaryWriter getBsonBinaryWriter() {
        return this.bsonBinaryWriter;
    }

    @Override
    public void writeStartDocument(String name) {
        ++this.level;
        this.bsonBinaryWriter.writeStartDocument(name);
    }

    @Override
    public void writeStartDocument() {
        ++this.level;
        this.bsonBinaryWriter.writeStartDocument();
    }

    @Override
    public void writeEndDocument() {
        --this.level;
        this.bsonBinaryWriter.writeEndDocument();
    }

    @Override
    public void writeStartArray(String name) {
        this.bsonBinaryWriter.writeStartArray(name);
    }

    @Override
    public void writeStartArray() {
        this.bsonBinaryWriter.writeStartArray();
    }

    @Override
    public void writeEndArray() {
        this.bsonBinaryWriter.writeEndArray();
    }

    @Override
    public void writeBinaryData(String name, BsonBinary binary) {
        this.bsonBinaryWriter.writeBinaryData(name, binary);
    }

    @Override
    public void writeBinaryData(BsonBinary binary) {
        this.bsonBinaryWriter.writeBinaryData(binary);
    }

    @Override
    public void writeBoolean(String name, boolean value2) {
        this.bsonBinaryWriter.writeBoolean(name, value2);
    }

    @Override
    public void writeBoolean(boolean value2) {
        this.bsonBinaryWriter.writeBoolean(value2);
    }

    @Override
    public void writeDateTime(String name, long value2) {
        this.bsonBinaryWriter.writeDateTime(name, value2);
    }

    @Override
    public void writeDateTime(long value2) {
        this.bsonBinaryWriter.writeDateTime(value2);
    }

    @Override
    public void writeDBPointer(String name, BsonDbPointer value2) {
        this.bsonBinaryWriter.writeDBPointer(name, value2);
    }

    @Override
    public void writeDBPointer(BsonDbPointer value2) {
        this.bsonBinaryWriter.writeDBPointer(value2);
    }

    @Override
    public void writeDouble(String name, double value2) {
        this.bsonBinaryWriter.writeDouble(name, value2);
    }

    @Override
    public void writeDouble(double value2) {
        this.bsonBinaryWriter.writeDouble(value2);
    }

    @Override
    public void writeInt32(String name, int value2) {
        this.bsonBinaryWriter.writeInt32(name, value2);
    }

    @Override
    public void writeInt32(int value2) {
        this.bsonBinaryWriter.writeInt32(value2);
    }

    @Override
    public void writeInt64(String name, long value2) {
        this.bsonBinaryWriter.writeInt64(name, value2);
    }

    @Override
    public void writeInt64(long value2) {
        this.bsonBinaryWriter.writeInt64(value2);
    }

    @Override
    public void writeDecimal128(Decimal128 value2) {
        this.bsonBinaryWriter.writeDecimal128(value2);
    }

    @Override
    public void writeDecimal128(String name, Decimal128 value2) {
        this.bsonBinaryWriter.writeDecimal128(name, value2);
    }

    @Override
    public void writeJavaScript(String name, String code2) {
        this.bsonBinaryWriter.writeJavaScript(name, code2);
    }

    @Override
    public void writeJavaScript(String code2) {
        this.bsonBinaryWriter.writeJavaScript(code2);
    }

    @Override
    public void writeJavaScriptWithScope(String name, String code2) {
        this.bsonBinaryWriter.writeJavaScriptWithScope(name, code2);
    }

    @Override
    public void writeJavaScriptWithScope(String code2) {
        this.bsonBinaryWriter.writeJavaScriptWithScope(code2);
    }

    @Override
    public void writeMaxKey(String name) {
        this.bsonBinaryWriter.writeMaxKey(name);
    }

    @Override
    public void writeMaxKey() {
        this.bsonBinaryWriter.writeMaxKey();
    }

    @Override
    public void writeMinKey(String name) {
        this.bsonBinaryWriter.writeMinKey(name);
    }

    @Override
    public void writeMinKey() {
        this.bsonBinaryWriter.writeMinKey();
    }

    @Override
    public void writeName(String name) {
        this.bsonBinaryWriter.writeName(name);
    }

    @Override
    public void writeNull(String name) {
        this.bsonBinaryWriter.writeNull(name);
    }

    @Override
    public void writeNull() {
        this.bsonBinaryWriter.writeNull();
    }

    @Override
    public void writeObjectId(String name, ObjectId objectId) {
        this.bsonBinaryWriter.writeObjectId(name, objectId);
    }

    @Override
    public void writeObjectId(ObjectId objectId) {
        this.bsonBinaryWriter.writeObjectId(objectId);
    }

    @Override
    public void writeRegularExpression(String name, BsonRegularExpression regularExpression) {
        this.bsonBinaryWriter.writeRegularExpression(name, regularExpression);
    }

    @Override
    public void writeRegularExpression(BsonRegularExpression regularExpression) {
        this.bsonBinaryWriter.writeRegularExpression(regularExpression);
    }

    @Override
    public void writeString(String name, String value2) {
        this.bsonBinaryWriter.writeString(name, value2);
    }

    @Override
    public void writeString(String value2) {
        this.bsonBinaryWriter.writeString(value2);
    }

    @Override
    public void writeSymbol(String name, String value2) {
        this.bsonBinaryWriter.writeSymbol(name, value2);
    }

    @Override
    public void writeSymbol(String value2) {
        this.bsonBinaryWriter.writeSymbol(value2);
    }

    @Override
    public void writeTimestamp(String name, BsonTimestamp value2) {
        this.bsonBinaryWriter.writeTimestamp(name, value2);
    }

    @Override
    public void writeTimestamp(BsonTimestamp value2) {
        this.bsonBinaryWriter.writeTimestamp(value2);
    }

    @Override
    public void writeUndefined(String name) {
        this.bsonBinaryWriter.writeUndefined(name);
    }

    @Override
    public void writeUndefined() {
        this.bsonBinaryWriter.writeUndefined();
    }

    @Override
    public void pipe(BsonReader reader) {
        this.bsonBinaryWriter.pipe(reader);
    }

    @Override
    public void flush() {
        this.bsonBinaryWriter.flush();
    }
}

