/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.ByteBuf;
import org.bson.assertions.Assertions;

class CompositeByteBuf
implements ByteBuf {
    private final List<Component> components;
    private final AtomicInteger referenceCount = new AtomicInteger(1);
    private int position;
    private int limit;

    CompositeByteBuf(List<ByteBuf> buffers) {
        Assertions.notNull("buffers", buffers);
        Assertions.isTrueArgument("buffer list not empty", !buffers.isEmpty());
        this.components = new ArrayList<Component>(buffers.size());
        int offset = 0;
        for (ByteBuf cur : buffers) {
            Component component = new Component(cur.asReadOnly().order(ByteOrder.LITTLE_ENDIAN), offset);
            this.components.add(component);
            offset = component.endOffset;
        }
        this.limit = this.components.get(this.components.size() - 1).endOffset;
    }

    CompositeByteBuf(CompositeByteBuf from2) {
        this.components = from2.components;
        this.position = from2.position();
        this.limit = from2.limit();
    }

    @Override
    public ByteBuf order(ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            throw new UnsupportedOperationException(String.format("Only %s is supported", ByteOrder.BIG_ENDIAN));
        }
        return this;
    }

    @Override
    public int capacity() {
        return this.components.get(this.components.size() - 1).endOffset;
    }

    @Override
    public int remaining() {
        return this.limit() - this.position();
    }

    @Override
    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public ByteBuf position(int newPosition) {
        if (newPosition < 0 || newPosition > this.limit) {
            throw new IndexOutOfBoundsException(String.format("%d is out of bounds", newPosition));
        }
        this.position = newPosition;
        return this;
    }

    @Override
    public ByteBuf clear() {
        this.position = 0;
        this.limit = this.capacity();
        return this;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public byte get() {
        this.checkIndex(this.position);
        ++this.position;
        return this.get(this.position - 1);
    }

    @Override
    public byte get(int index2) {
        this.checkIndex(index2);
        Component component = this.findComponent(index2);
        return component.buffer.get(index2 - component.offset);
    }

    @Override
    public ByteBuf get(byte[] bytes2) {
        this.checkIndex(this.position, bytes2.length);
        this.position += bytes2.length;
        return this.get(this.position - bytes2.length, bytes2);
    }

    @Override
    public ByteBuf get(int index2, byte[] bytes2) {
        return this.get(index2, bytes2, 0, bytes2.length);
    }

    @Override
    public ByteBuf get(byte[] bytes2, int offset, int length2) {
        this.checkIndex(this.position, length2);
        this.position += length2;
        return this.get(this.position - length2, bytes2, offset, length2);
    }

    @Override
    public ByteBuf get(int index2, byte[] bytes2, int offset, int length2) {
        this.checkDstIndex(index2, length2, offset, bytes2.length);
        int i = this.findComponentIndex(index2);
        int curIndex = index2;
        int curOffset = offset;
        int curLength = length2;
        while (curLength > 0) {
            Component c = this.components.get(i);
            int localLength = Math.min(curLength, c.buffer.capacity() - (curIndex - c.offset));
            c.buffer.get(curIndex - c.offset, bytes2, curOffset, localLength);
            curIndex += localLength;
            curOffset += localLength;
            curLength -= localLength;
            ++i;
        }
        return this;
    }

    @Override
    public long getLong() {
        this.position += 8;
        return this.getLong(this.position - 8);
    }

    @Override
    public long getLong(int index2) {
        this.checkIndex(index2, 8);
        Component component = this.findComponent(index2);
        if (index2 + 8 <= component.endOffset) {
            return component.buffer.getLong(index2 - component.offset);
        }
        return (long)this.getInt(index2) & 0xFFFFFFFFL | ((long)this.getInt(index2 + 4) & 0xFFFFFFFFL) << 32;
    }

    @Override
    public double getDouble() {
        this.position += 8;
        return this.getDouble(this.position - 8);
    }

    @Override
    public double getDouble(int index2) {
        return Double.longBitsToDouble(this.getLong(index2));
    }

    @Override
    public int getInt() {
        this.position += 4;
        return this.getInt(this.position - 4);
    }

    @Override
    public int getInt(int index2) {
        this.checkIndex(index2, 4);
        Component component = this.findComponent(index2);
        if (index2 + 4 <= component.endOffset) {
            return component.buffer.getInt(index2 - component.offset);
        }
        return this.getShort(index2) & 0xFFFF | (this.getShort(index2 + 2) & 0xFFFF) << 16;
    }

    private int getShort(int index2) {
        this.checkIndex(index2, 2);
        return (short)(this.get(index2) & 0xFF | (this.get(index2 + 1) & 0xFF) << 8);
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public ByteBuf limit(int newLimit) {
        if (newLimit < 0 || newLimit > this.capacity()) {
            throw new IndexOutOfBoundsException(String.format("%d is out of bounds", newLimit));
        }
        this.limit = newLimit;
        return this;
    }

    @Override
    public ByteBuf put(int index2, byte b2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf put(byte[] src, int offset, int length2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf put(byte b2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf flip() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf asReadOnly() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf duplicate() {
        return new CompositeByteBuf(this);
    }

    @Override
    public ByteBuffer asNIO() {
        if (this.components.size() == 1) {
            ByteBuffer byteBuffer = this.components.get(0).buffer.asNIO().duplicate();
            ((Buffer)byteBuffer).position(this.position).limit(this.limit);
            return byteBuffer;
        }
        byte[] bytes2 = new byte[this.remaining()];
        this.get(this.position, bytes2, 0, bytes2.length);
        return ByteBuffer.wrap(bytes2);
    }

    @Override
    public int getReferenceCount() {
        return this.referenceCount.get();
    }

    @Override
    public ByteBuf retain() {
        if (this.referenceCount.incrementAndGet() == 1) {
            this.referenceCount.decrementAndGet();
            throw new IllegalStateException("Attempted to increment the reference count when it is already 0");
        }
        return this;
    }

    @Override
    public void release() {
        if (this.referenceCount.decrementAndGet() < 0) {
            this.referenceCount.incrementAndGet();
            throw new IllegalStateException("Attempted to decrement the reference count below 0");
        }
    }

    private Component findComponent(int index2) {
        return this.components.get(this.findComponentIndex(index2));
    }

    private int findComponentIndex(int index2) {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            Component cur = this.components.get(i);
            if (index2 < cur.offset) continue;
            return i;
        }
        throw new IndexOutOfBoundsException(String.format("%d is out of bounds", index2));
    }

    private void checkIndex(int index2) {
        this.ensureAccessible();
        if (index2 < 0 || index2 >= this.capacity()) {
            throw new IndexOutOfBoundsException(String.format("index: %d (expected: range(0, %d))", index2, this.capacity()));
        }
    }

    private void checkIndex(int index2, int fieldLength) {
        this.ensureAccessible();
        if (index2 < 0 || index2 > this.capacity() - fieldLength) {
            throw new IndexOutOfBoundsException(String.format("index: %d, length: %d (expected: range(0, %d))", index2, fieldLength, this.capacity()));
        }
    }

    private void checkDstIndex(int index2, int length2, int dstIndex, int dstCapacity) {
        this.checkIndex(index2, length2);
        if (dstIndex < 0 || dstIndex > dstCapacity - length2) {
            throw new IndexOutOfBoundsException(String.format("dstIndex: %d, length: %d (expected: range(0, %d))", dstIndex, length2, dstCapacity));
        }
    }

    private void ensureAccessible() {
        if (this.referenceCount.get() == 0) {
            throw new IllegalStateException("Reference count is 0");
        }
    }

    private static final class Component {
        private final ByteBuf buffer;
        private final int length;
        private final int offset;
        private final int endOffset;

        Component(ByteBuf buffer, int offset) {
            this.buffer = buffer;
            this.length = buffer.limit() - buffer.position();
            this.offset = offset;
            this.endOffset = offset + this.length;
        }
    }
}

