/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.connection.SplittablePayload;
import com.mongodb.internal.connection.MessageSettings;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonElement;
import org.bson.BsonMaximumSizeExceededException;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.io.BsonOutput;

final class BsonWriterHelper {
    private static final int DOCUMENT_HEADROOM = 16384;
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());
    private static final EncoderContext ENCODER_CONTEXT = EncoderContext.builder().build();

    static void writeElements(BsonWriter writer2, List<BsonElement> bsonElements) {
        for (BsonElement bsonElement : bsonElements) {
            writer2.writeName(bsonElement.getName());
            BsonWriterHelper.getCodec(bsonElement.getValue()).encode(writer2, bsonElement.getValue(), ENCODER_CONTEXT);
        }
    }

    static void writePayloadArray(BsonWriter writer2, BsonOutput bsonOutput, MessageSettings settings2, int messageStartPosition, SplittablePayload payload) {
        writer2.writeStartArray(payload.getPayloadName());
        BsonWriterHelper.writePayload(writer2, bsonOutput, BsonWriterHelper.getDocumentMessageSettings(settings2), messageStartPosition, payload);
        writer2.writeEndArray();
    }

    static void writePayload(BsonWriter writer2, BsonOutput bsonOutput, MessageSettings settings2, int messageStartPosition, SplittablePayload payload) {
        MessageSettings payloadSettings = BsonWriterHelper.getPayloadMessageSettings(payload.getPayloadType(), settings2);
        for (int i = 0; i < payload.getPayload().size() && BsonWriterHelper.writeDocument(writer2, bsonOutput, payloadSettings, payload.getPayload().get(i), messageStartPosition, i + 1); ++i) {
            payload.setPosition(i + 1);
        }
        if (payload.getPosition() == 0) {
            throw new BsonMaximumSizeExceededException(String.format("Payload document size is larger than maximum of %d.", payloadSettings.getMaxDocumentSize()));
        }
    }

    private static boolean writeDocument(BsonWriter writer2, BsonOutput bsonOutput, MessageSettings settings2, BsonDocument document2, int messageStartPosition, int batchItemCount) {
        int currentPosition = bsonOutput.getPosition();
        BsonWriterHelper.getCodec(document2).encode(writer2, document2, ENCODER_CONTEXT);
        int messageSize = bsonOutput.getPosition() - messageStartPosition;
        int documentSize = bsonOutput.getPosition() - currentPosition;
        if (BsonWriterHelper.exceedsLimits(settings2, messageSize, documentSize, batchItemCount)) {
            bsonOutput.truncateToPosition(currentPosition);
            return false;
        }
        return true;
    }

    private static Codec<BsonValue> getCodec(BsonValue bsonValue) {
        return REGISTRY.get(bsonValue.getClass());
    }

    private static MessageSettings getPayloadMessageSettings(SplittablePayload.Type type, MessageSettings settings2) {
        MessageSettings payloadMessageSettings = settings2;
        if (type != SplittablePayload.Type.INSERT) {
            payloadMessageSettings = BsonWriterHelper.createMessageSettingsBuilder(settings2).maxDocumentSize(settings2.getMaxDocumentSize() + 16384).build();
        }
        return payloadMessageSettings;
    }

    private static MessageSettings getDocumentMessageSettings(MessageSettings settings2) {
        return BsonWriterHelper.createMessageSettingsBuilder(settings2).maxMessageSize(settings2.getMaxDocumentSize() + 16384).build();
    }

    private static MessageSettings.Builder createMessageSettingsBuilder(MessageSettings settings2) {
        return MessageSettings.builder().maxBatchCount(settings2.getMaxBatchCount()).maxMessageSize(settings2.getMaxMessageSize()).maxDocumentSize(settings2.getMaxDocumentSize()).maxWireVersion(settings2.getMaxWireVersion());
    }

    private static boolean exceedsLimits(MessageSettings settings2, int messageSize, int documentSize, int batchItemCount) {
        if (batchItemCount > settings2.getMaxBatchCount()) {
            return true;
        }
        if (messageSize > settings2.getMaxMessageSize()) {
            return true;
        }
        return documentSize > settings2.getMaxDocumentSize();
    }

    private BsonWriterHelper() {
    }
}

