/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection.netty;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bson.ByteBuf;

final class NettyByteBuf
implements ByteBuf {
    private io.netty.buffer.ByteBuf proxied;
    private boolean isWriting = true;

    NettyByteBuf(io.netty.buffer.ByteBuf proxied) {
        this.proxied = proxied.order(ByteOrder.LITTLE_ENDIAN);
    }

    NettyByteBuf(io.netty.buffer.ByteBuf proxied, boolean isWriting) {
        this(proxied);
        this.isWriting = isWriting;
    }

    io.netty.buffer.ByteBuf asByteBuf() {
        return this.proxied;
    }

    @Override
    public int capacity() {
        return this.proxied.capacity();
    }

    @Override
    public ByteBuf put(int index2, byte b2) {
        this.proxied.setByte(index2, (int)b2);
        return this;
    }

    @Override
    public int remaining() {
        if (this.isWriting) {
            return this.proxied.writableBytes();
        }
        return this.proxied.readableBytes();
    }

    @Override
    public ByteBuf put(byte[] src, int offset, int length2) {
        this.proxied.writeBytes(src, offset, length2);
        return this;
    }

    @Override
    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    @Override
    public ByteBuf put(byte b2) {
        this.proxied.writeByte((int)b2);
        return this;
    }

    @Override
    public ByteBuf flip() {
        this.isWriting = !this.isWriting;
        return this;
    }

    @Override
    public byte[] array() {
        return this.proxied.array();
    }

    @Override
    public int limit() {
        if (this.isWriting) {
            return this.proxied.writerIndex() + this.remaining();
        }
        return this.proxied.readerIndex() + this.remaining();
    }

    @Override
    public ByteBuf position(int newPosition) {
        if (this.isWriting) {
            this.proxied.writerIndex(newPosition);
        } else {
            this.proxied.readerIndex(newPosition);
        }
        return this;
    }

    @Override
    public ByteBuf clear() {
        this.proxied.clear();
        return this;
    }

    @Override
    public ByteBuf order(ByteOrder byteOrder) {
        this.proxied = this.proxied.order(byteOrder);
        return this;
    }

    @Override
    public byte get() {
        return this.proxied.readByte();
    }

    @Override
    public byte get(int index2) {
        return this.proxied.getByte(index2);
    }

    @Override
    public ByteBuf get(byte[] bytes2) {
        this.proxied.readBytes(bytes2);
        return this;
    }

    @Override
    public ByteBuf get(int index2, byte[] bytes2) {
        this.proxied.getBytes(index2, bytes2);
        return this;
    }

    @Override
    public ByteBuf get(byte[] bytes2, int offset, int length2) {
        this.proxied.readBytes(bytes2, offset, length2);
        return this;
    }

    @Override
    public ByteBuf get(int index2, byte[] bytes2, int offset, int length2) {
        this.proxied.getBytes(index2, bytes2, offset, length2);
        return this;
    }

    @Override
    public long getLong() {
        return this.proxied.readLong();
    }

    @Override
    public long getLong(int index2) {
        return this.proxied.getLong(index2);
    }

    @Override
    public double getDouble() {
        return this.proxied.readDouble();
    }

    @Override
    public double getDouble(int index2) {
        return this.proxied.getDouble(index2);
    }

    @Override
    public int getInt() {
        return this.proxied.readInt();
    }

    @Override
    public int getInt(int index2) {
        return this.proxied.getInt(index2);
    }

    @Override
    public int position() {
        if (this.isWriting) {
            return this.proxied.writerIndex();
        }
        return this.proxied.readerIndex();
    }

    @Override
    public ByteBuf limit(int newLimit) {
        if (this.isWriting) {
            throw new UnsupportedOperationException("Can not set the limit while writing");
        }
        this.proxied.writerIndex(newLimit);
        return this;
    }

    @Override
    public ByteBuf asReadOnly() {
        return this;
    }

    @Override
    public ByteBuf duplicate() {
        return new NettyByteBuf(this.proxied.duplicate().retain(), this.isWriting);
    }

    @Override
    public ByteBuffer asNIO() {
        if (this.isWriting) {
            return this.proxied.nioBuffer(this.proxied.writerIndex(), this.proxied.writableBytes());
        }
        return this.proxied.nioBuffer(this.proxied.readerIndex(), this.proxied.readableBytes());
    }

    @Override
    public int getReferenceCount() {
        return this.proxied.refCnt();
    }

    @Override
    public ByteBuf retain() {
        this.proxied.retain();
        return this;
    }

    @Override
    public void release() {
        this.proxied.release();
    }
}

