/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.assertions.Assertions;
import org.bson.types.ObjectId;

public final class ClusterId {
    private final String value;
    private final String description;

    public ClusterId() {
        this(null);
    }

    public ClusterId(String description) {
        this.value = new ObjectId().toHexString();
        this.description = description;
    }

    ClusterId(String value2, String description) {
        this.value = Assertions.notNull("value", value2);
        this.description = description;
    }

    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterId clusterId = (ClusterId)o;
        if (!this.value.equals(clusterId.value)) {
            return false;
        }
        return !(this.description != null ? !this.description.equals(clusterId.description) : clusterId.description != null);
    }

    public int hashCode() {
        int result2 = this.value.hashCode();
        result2 = 31 * result2 + (this.description != null ? this.description.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "ClusterId{value='" + this.value + '\'' + ", description='" + this.description + '\'' + '}';
    }
}

