/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.geojson.codecs;

import com.mongodb.client.model.geojson.CoordinateReferenceSystem;
import com.mongodb.client.model.geojson.Geometry;
import com.mongodb.client.model.geojson.GeometryCollection;
import com.mongodb.client.model.geojson.LineString;
import com.mongodb.client.model.geojson.MultiLineString;
import com.mongodb.client.model.geojson.MultiPoint;
import com.mongodb.client.model.geojson.MultiPolygon;
import com.mongodb.client.model.geojson.Point;
import com.mongodb.client.model.geojson.Polygon;
import com.mongodb.client.model.geojson.PolygonCoordinates;
import com.mongodb.client.model.geojson.Position;
import java.util.List;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;

final class GeometryEncoderHelper {
    static void encodeGeometry(BsonWriter writer2, Geometry value2, EncoderContext encoderContext, CodecRegistry registry) {
        writer2.writeStartDocument();
        writer2.writeString("type", value2.getType().getTypeName());
        if (value2 instanceof GeometryCollection) {
            writer2.writeName("geometries");
            GeometryEncoderHelper.encodeGeometryCollection(writer2, (GeometryCollection)value2, encoderContext, registry);
        } else {
            writer2.writeName("coordinates");
            if (value2 instanceof Point) {
                GeometryEncoderHelper.encodePoint(writer2, (Point)value2);
            } else if (value2 instanceof MultiPoint) {
                GeometryEncoderHelper.encodeMultiPoint(writer2, (MultiPoint)value2);
            } else if (value2 instanceof Polygon) {
                GeometryEncoderHelper.encodePolygon(writer2, (Polygon)value2);
            } else if (value2 instanceof MultiPolygon) {
                GeometryEncoderHelper.encodeMultiPolygon(writer2, (MultiPolygon)value2);
            } else if (value2 instanceof LineString) {
                GeometryEncoderHelper.encodeLineString(writer2, (LineString)value2);
            } else if (value2 instanceof MultiLineString) {
                GeometryEncoderHelper.encodeMultiLineString(writer2, (MultiLineString)value2);
            } else {
                throw new CodecConfigurationException(String.format("Unsupported Geometry: %s", value2));
            }
        }
        GeometryEncoderHelper.encodeCoordinateReferenceSystem(writer2, value2, encoderContext, registry);
        writer2.writeEndDocument();
    }

    private static void encodePoint(BsonWriter writer2, Point value2) {
        GeometryEncoderHelper.encodePosition(writer2, value2.getPosition());
    }

    private static void encodeMultiPoint(BsonWriter writer2, MultiPoint value2) {
        writer2.writeStartArray();
        for (Position position2 : value2.getCoordinates()) {
            GeometryEncoderHelper.encodePosition(writer2, position2);
        }
        writer2.writeEndArray();
    }

    private static void encodePolygon(BsonWriter writer2, Polygon value2) {
        GeometryEncoderHelper.encodePolygonCoordinates(writer2, value2.getCoordinates());
    }

    private static void encodeMultiPolygon(BsonWriter writer2, MultiPolygon value2) {
        writer2.writeStartArray();
        for (PolygonCoordinates polygonCoordinates : value2.getCoordinates()) {
            GeometryEncoderHelper.encodePolygonCoordinates(writer2, polygonCoordinates);
        }
        writer2.writeEndArray();
    }

    private static void encodeLineString(BsonWriter writer2, LineString value2) {
        writer2.writeStartArray();
        for (Position position2 : value2.getCoordinates()) {
            GeometryEncoderHelper.encodePosition(writer2, position2);
        }
        writer2.writeEndArray();
    }

    private static void encodeMultiLineString(BsonWriter writer2, MultiLineString value2) {
        writer2.writeStartArray();
        for (List<Position> ring : value2.getCoordinates()) {
            writer2.writeStartArray();
            for (Position position2 : ring) {
                GeometryEncoderHelper.encodePosition(writer2, position2);
            }
            writer2.writeEndArray();
        }
        writer2.writeEndArray();
    }

    private static void encodeGeometryCollection(BsonWriter writer2, GeometryCollection value2, EncoderContext encoderContext, CodecRegistry registry) {
        writer2.writeStartArray();
        for (Geometry geometry : value2.getGeometries()) {
            GeometryEncoderHelper.encodeGeometry(writer2, geometry, encoderContext, registry);
        }
        writer2.writeEndArray();
    }

    static void encodeCoordinateReferenceSystem(BsonWriter writer2, Geometry geometry, EncoderContext encoderContext, CodecRegistry registry) {
        CoordinateReferenceSystem coordinateReferenceSystem = geometry.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem != null) {
            writer2.writeName("crs");
            Codec<?> codec = registry.get(coordinateReferenceSystem.getClass());
            encoderContext.encodeWithChildContext(codec, writer2, coordinateReferenceSystem);
        }
    }

    static void encodePolygonCoordinates(BsonWriter writer2, PolygonCoordinates polygonCoordinates) {
        writer2.writeStartArray();
        GeometryEncoderHelper.encodeLinearRing(polygonCoordinates.getExterior(), writer2);
        for (List<Position> ring : polygonCoordinates.getHoles()) {
            GeometryEncoderHelper.encodeLinearRing(ring, writer2);
        }
        writer2.writeEndArray();
    }

    private static void encodeLinearRing(List<Position> ring, BsonWriter writer2) {
        writer2.writeStartArray();
        for (Position position2 : ring) {
            GeometryEncoderHelper.encodePosition(writer2, position2);
        }
        writer2.writeEndArray();
    }

    static void encodePosition(BsonWriter writer2, Position value2) {
        writer2.writeStartArray();
        for (double number2 : value2.getValues()) {
            writer2.writeDouble(number2);
        }
        writer2.writeEndArray();
    }

    private GeometryEncoderHelper() {
    }
}

