/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.geojson;

import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Immutable
public final class Position {
    private final List<Double> values;

    public Position(List<Double> values2) {
        Assertions.notNull("values", values2);
        Assertions.isTrueArgument("value contains only non-null elements", !values2.contains(null));
        Assertions.isTrueArgument("value must contain at least two elements", values2.size() >= 2);
        this.values = Collections.unmodifiableList(values2);
    }

    public Position(double first2, double second2, double ... remaining) {
        ArrayList<Double> values2 = new ArrayList<Double>();
        values2.add(first2);
        values2.add(second2);
        for (double cur : remaining) {
            values2.add(cur);
        }
        this.values = Collections.unmodifiableList(values2);
    }

    public List<Double> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Position that2 = (Position)o;
        return this.values.equals(that2.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        return "Position{values=" + this.values + '}';
    }
}

